/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Origin properties needed for origin creation or update.
 */
@JsonFlatten
public class OriginUpdateParametersInner {
    /**
     * The address of the origin. Domain names, IPv4 addresses, and IPv6
     * addresses are supported.
     */
    @JsonProperty(value = "properties.hostName")
    private String hostName;

    /**
     * The value of the HTTP port. Must be between 1 and 65535.
     */
    @JsonProperty(value = "properties.httpPort")
    private Integer httpPort;

    /**
     * The value of the HTTPS port. Must be between 1 and 65535.
     */
    @JsonProperty(value = "properties.httpsPort")
    private Integer httpsPort;

    /**
     * Get the hostName value.
     *
     * @return the hostName value
     */
    public String hostName() {
        return this.hostName;
    }

    /**
     * Set the hostName value.
     *
     * @param hostName the hostName value to set
     * @return the OriginUpdateParametersInner object itself.
     */
    public OriginUpdateParametersInner withHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    /**
     * Get the httpPort value.
     *
     * @return the httpPort value
     */
    public Integer httpPort() {
        return this.httpPort;
    }

    /**
     * Set the httpPort value.
     *
     * @param httpPort the httpPort value to set
     * @return the OriginUpdateParametersInner object itself.
     */
    public OriginUpdateParametersInner withHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    /**
     * Get the httpsPort value.
     *
     * @return the httpsPort value
     */
    public Integer httpsPort() {
        return this.httpsPort;
    }

    /**
     * Set the httpsPort value.
     *
     * @param httpsPort the httpsPort value to set
     * @return the OriginUpdateParametersInner object itself.
     */
    public OriginUpdateParametersInner withHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

}
