/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.Disallowed;
import com.microsoft.azure.management.compute.DiskSkuTypes;
import com.microsoft.azure.management.compute.Gallery;
import com.microsoft.azure.management.compute.GalleryImage;
import com.microsoft.azure.management.compute.GalleryImageIdentifier;
import com.microsoft.azure.management.compute.GalleryImageVersion;
import com.microsoft.azure.management.compute.ImagePurchasePlan;
import com.microsoft.azure.management.compute.OperatingSystemStateTypes;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.RecommendedMachineConfiguration;
import com.microsoft.azure.management.compute.ResourceRange;
import com.microsoft.azure.management.compute.StorageAccountTypes;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.GalleryImageInner;
import com.microsoft.azure.management.compute.implementation.GalleryImagesInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import rx.Observable;

@LangDefinition
class GalleryImageImpl
extends CreatableUpdatableImpl<GalleryImage, GalleryImageInner, GalleryImageImpl>
implements GalleryImage,
GalleryImage.Definition,
GalleryImage.Update {
    private final ComputeManager manager;
    private String resourceGroupName;
    private String galleryName;
    private String galleryImageName;

    GalleryImageImpl(String name, ComputeManager manager) {
        super(name, (Object)new GalleryImageInner());
        this.manager = manager;
        this.galleryImageName = name;
    }

    GalleryImageImpl(GalleryImageInner inner, ComputeManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.galleryImageName = inner.name();
        this.resourceGroupName = GalleryImageImpl.getValueFromIdByName(inner.id(), "resourceGroups");
        this.galleryName = GalleryImageImpl.getValueFromIdByName(inner.id(), "galleries");
        this.galleryImageName = GalleryImageImpl.getValueFromIdByName(inner.id(), "images");
    }

    @Override
    public Observable<GalleryImageVersion> getVersionAsync(String versionName) {
        return this.manager().galleryImageVersions().getByGalleryImageAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, versionName);
    }

    @Override
    public GalleryImageVersion getVersion(String versionName) {
        return this.manager().galleryImageVersions().getByGalleryImage(this.resourceGroupName, this.galleryName, this.galleryImageName, versionName);
    }

    @Override
    public Observable<GalleryImageVersion> listVersionsAsync() {
        return this.manager().galleryImageVersions().listByGalleryImageAsync(this.resourceGroupName, this.galleryName, this.galleryImageName);
    }

    @Override
    public PagedList<GalleryImageVersion> listVersions() {
        return this.manager().galleryImageVersions().listByGalleryImage(this.resourceGroupName, this.galleryName, this.galleryImageName);
    }

    public ComputeManager manager() {
        return this.manager;
    }

    public Observable<GalleryImage> createResourceAsync() {
        GalleryImagesInner client = ((ComputeManagementClientImpl)((Object)this.manager().inner())).galleryImages();
        return client.createOrUpdateAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, (GalleryImageInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Observable<GalleryImage> updateResourceAsync() {
        GalleryImagesInner client = ((ComputeManagementClientImpl)((Object)this.manager().inner())).galleryImages();
        return client.createOrUpdateAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, (GalleryImageInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<GalleryImageInner> getInnerAsync() {
        GalleryImagesInner client = ((ComputeManagementClientImpl)((Object)this.manager().inner())).galleryImages();
        return client.getAsync(this.resourceGroupName, this.galleryName, this.galleryImageName);
    }

    public boolean isInCreateMode() {
        return ((GalleryImageInner)((Object)this.inner())).id() == null;
    }

    @Override
    public String description() {
        return ((GalleryImageInner)((Object)this.inner())).description();
    }

    @Override
    public List<DiskSkuTypes> unsupportedDiskTypes() {
        if (((GalleryImageInner)((Object)this.inner())).disallowed() == null || ((GalleryImageInner)((Object)this.inner())).disallowed().diskTypes() == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        ArrayList<DiskSkuTypes> diskTypes = new ArrayList<DiskSkuTypes>();
        for (String diskTypeStr : ((GalleryImageInner)((Object)this.inner())).disallowed().diskTypes()) {
            diskTypes.add(DiskSkuTypes.fromStorageAccountType(StorageAccountTypes.fromString(diskTypeStr)));
        }
        return Collections.unmodifiableList(diskTypes);
    }

    @Override
    public Disallowed disallowed() {
        return ((GalleryImageInner)((Object)this.inner())).disallowed();
    }

    @Override
    public DateTime endOfLifeDate() {
        return ((GalleryImageInner)((Object)this.inner())).endOfLifeDate();
    }

    @Override
    public String eula() {
        return ((GalleryImageInner)((Object)this.inner())).eula();
    }

    @Override
    public String id() {
        return ((GalleryImageInner)((Object)this.inner())).id();
    }

    @Override
    public GalleryImageIdentifier identifier() {
        return ((GalleryImageInner)((Object)this.inner())).identifier();
    }

    @Override
    public String location() {
        return ((GalleryImageInner)((Object)this.inner())).location();
    }

    @Override
    public String name() {
        return ((GalleryImageInner)((Object)this.inner())).name();
    }

    @Override
    public OperatingSystemStateTypes osState() {
        return ((GalleryImageInner)((Object)this.inner())).osState();
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((GalleryImageInner)((Object)this.inner())).osType();
    }

    @Override
    public String privacyStatementUri() {
        return ((GalleryImageInner)((Object)this.inner())).privacyStatementUri();
    }

    @Override
    public String provisioningState() {
        return ((GalleryImageInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public ImagePurchasePlan purchasePlan() {
        return ((GalleryImageInner)((Object)this.inner())).purchasePlan();
    }

    @Override
    public RecommendedMachineConfiguration recommendedVirtualMachineConfiguration() {
        return ((GalleryImageInner)((Object)this.inner())).recommended();
    }

    @Override
    public String releaseNoteUri() {
        return ((GalleryImageInner)((Object)this.inner())).releaseNoteUri();
    }

    @Override
    public Map<String, String> tags() {
        return ((GalleryImageInner)((Object)this.inner())).getTags();
    }

    @Override
    public String type() {
        return ((GalleryImageInner)((Object)this.inner())).type();
    }

    @Override
    public GalleryImageImpl withExistingGallery(String resourceGroupName, String galleryName) {
        this.resourceGroupName = resourceGroupName;
        this.galleryName = galleryName;
        return this;
    }

    @Override
    public GalleryImageImpl withExistingGallery(Gallery gallery) {
        this.resourceGroupName = gallery.resourceGroupName();
        this.galleryName = gallery.name();
        return this;
    }

    @Override
    public GalleryImageImpl withLocation(String location) {
        ((GalleryImageInner)((Object)this.inner())).withLocation(location);
        return this;
    }

    @Override
    public GalleryImageImpl withLocation(Region location) {
        ((GalleryImageInner)((Object)this.inner())).withLocation(location.toString());
        return this;
    }

    @Override
    public GalleryImageImpl withIdentifier(GalleryImageIdentifier identifier) {
        ((GalleryImageInner)((Object)this.inner())).withIdentifier(identifier);
        return this;
    }

    @Override
    public GalleryImageImpl withIdentifier(String publisher, String offer, String sku) {
        ((GalleryImageInner)((Object)this.inner())).withIdentifier(new GalleryImageIdentifier().withPublisher(publisher).withOffer(offer).withSku(sku));
        return this;
    }

    @Override
    public GalleryImageImpl withGeneralizedWindows() {
        return this.withWindows(OperatingSystemStateTypes.GENERALIZED);
    }

    @Override
    public GalleryImageImpl withGeneralizedLinux() {
        return this.withLinux(OperatingSystemStateTypes.GENERALIZED);
    }

    @Override
    public GalleryImageImpl withWindows(OperatingSystemStateTypes osState) {
        ((GalleryImageInner)((Object)this.inner())).withOsType(OperatingSystemTypes.WINDOWS).withOsState(osState);
        return this;
    }

    @Override
    public GalleryImageImpl withLinux(OperatingSystemStateTypes osState) {
        ((GalleryImageInner)((Object)this.inner())).withOsType(OperatingSystemTypes.LINUX).withOsState(osState);
        return this;
    }

    @Override
    public GalleryImageImpl withDescription(String description) {
        ((GalleryImageInner)((Object)this.inner())).withDescription(description);
        return this;
    }

    @Override
    public GalleryImageImpl withUnsupportedDiskType(DiskSkuTypes diskType) {
        if (((GalleryImageInner)((Object)this.inner())).disallowed() == null) {
            ((GalleryImageInner)((Object)this.inner())).withDisallowed(new Disallowed());
        }
        if (((GalleryImageInner)((Object)this.inner())).disallowed().diskTypes() == null) {
            ((GalleryImageInner)((Object)this.inner())).disallowed().withDiskTypes(new ArrayList<String>());
        }
        boolean found = false;
        String newDiskTypeStr = diskType.toString();
        for (String diskTypeStr : ((GalleryImageInner)((Object)this.inner())).disallowed().diskTypes()) {
            if (!diskTypeStr.equalsIgnoreCase(newDiskTypeStr)) continue;
            found = true;
            break;
        }
        if (!found) {
            ((GalleryImageInner)((Object)this.inner())).disallowed().diskTypes().add(diskType.toString());
        }
        return this;
    }

    @Override
    public GalleryImageImpl withUnsupportedDiskTypes(List<DiskSkuTypes> diskTypes) {
        if (((GalleryImageInner)((Object)this.inner())).disallowed() == null) {
            ((GalleryImageInner)((Object)this.inner())).withDisallowed(new Disallowed());
        }
        ((GalleryImageInner)((Object)this.inner())).disallowed().withDiskTypes(new ArrayList<String>());
        for (DiskSkuTypes diskType : diskTypes) {
            ((GalleryImageInner)((Object)this.inner())).disallowed().diskTypes().add(diskType.toString());
        }
        return this;
    }

    @Override
    public GalleryImageImpl withoutUnsupportedDiskType(DiskSkuTypes diskType) {
        if (((GalleryImageInner)((Object)this.inner())).disallowed() != null && ((GalleryImageInner)((Object)this.inner())).disallowed().diskTypes() != null) {
            int foundIndex = -1;
            int i = 0;
            String diskTypeToRemove = diskType.toString();
            for (String diskTypeStr : ((GalleryImageInner)((Object)this.inner())).disallowed().diskTypes()) {
                if (diskTypeStr.equalsIgnoreCase(diskTypeToRemove)) {
                    foundIndex = i;
                    break;
                }
                ++i;
            }
            if (foundIndex != -1) {
                ((GalleryImageInner)((Object)this.inner())).disallowed().diskTypes().remove(foundIndex);
            }
        }
        return this;
    }

    @Override
    public GalleryImageImpl withDisallowed(Disallowed disallowed) {
        ((GalleryImageInner)((Object)this.inner())).withDisallowed(disallowed);
        return this;
    }

    @Override
    public GalleryImageImpl withEndOfLifeDate(DateTime endOfLifeDate) {
        ((GalleryImageInner)((Object)this.inner())).withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    @Override
    public GalleryImageImpl withEula(String eula) {
        ((GalleryImageInner)((Object)this.inner())).withEula(eula);
        return this;
    }

    @Override
    public GalleryImageImpl withOsState(OperatingSystemStateTypes osState) {
        ((GalleryImageInner)((Object)this.inner())).withOsState(osState);
        return this;
    }

    @Override
    public GalleryImageImpl withPrivacyStatementUri(String privacyStatementUri) {
        ((GalleryImageInner)((Object)this.inner())).withPrivacyStatementUri(privacyStatementUri);
        return this;
    }

    @Override
    public GalleryImageImpl withPurchasePlan(String name, String publisher, String product) {
        return this.withPurchasePlan(new ImagePurchasePlan().withName(name).withPublisher(publisher).withProduct(product));
    }

    @Override
    public GalleryImageImpl withPurchasePlan(ImagePurchasePlan purchasePlan) {
        ((GalleryImageInner)((Object)this.inner())).withPurchasePlan(purchasePlan);
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedMinimumCPUsCountForVirtualMachine(int minCount) {
        if (((GalleryImageInner)((Object)this.inner())).recommended() == null) {
            ((GalleryImageInner)((Object)this.inner())).withRecommended(new RecommendedMachineConfiguration());
        }
        if (((GalleryImageInner)((Object)this.inner())).recommended().vCPUs() == null) {
            ((GalleryImageInner)((Object)this.inner())).recommended().withVCPUs(new ResourceRange());
        }
        ((GalleryImageInner)((Object)this.inner())).recommended().vCPUs().withMin(minCount);
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedMaximumCPUsCountForVirtualMachine(int maxCount) {
        if (((GalleryImageInner)((Object)this.inner())).recommended() == null) {
            ((GalleryImageInner)((Object)this.inner())).withRecommended(new RecommendedMachineConfiguration());
        }
        if (((GalleryImageInner)((Object)this.inner())).recommended().vCPUs() == null) {
            ((GalleryImageInner)((Object)this.inner())).recommended().withVCPUs(new ResourceRange());
        }
        ((GalleryImageInner)((Object)this.inner())).recommended().vCPUs().withMax(maxCount);
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedCPUsCountForVirtualMachine(int minCount, int maxCount) {
        if (((GalleryImageInner)((Object)this.inner())).recommended() == null) {
            ((GalleryImageInner)((Object)this.inner())).withRecommended(new RecommendedMachineConfiguration());
        }
        ((GalleryImageInner)((Object)this.inner())).recommended().withVCPUs(new ResourceRange());
        ((GalleryImageInner)((Object)this.inner())).recommended().vCPUs().withMin(minCount);
        ((GalleryImageInner)((Object)this.inner())).recommended().vCPUs().withMax(maxCount);
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedMinimumMemoryForVirtualMachine(int minMB) {
        if (((GalleryImageInner)((Object)this.inner())).recommended() == null) {
            ((GalleryImageInner)((Object)this.inner())).withRecommended(new RecommendedMachineConfiguration());
        }
        if (((GalleryImageInner)((Object)this.inner())).recommended().memory() == null) {
            ((GalleryImageInner)((Object)this.inner())).recommended().withMemory(new ResourceRange());
        }
        ((GalleryImageInner)((Object)this.inner())).recommended().memory().withMin(minMB);
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedMaximumMemoryForVirtualMachine(int maxMB) {
        if (((GalleryImageInner)((Object)this.inner())).recommended() == null) {
            ((GalleryImageInner)((Object)this.inner())).withRecommended(new RecommendedMachineConfiguration());
        }
        if (((GalleryImageInner)((Object)this.inner())).recommended().memory() == null) {
            ((GalleryImageInner)((Object)this.inner())).recommended().withMemory(new ResourceRange());
        }
        ((GalleryImageInner)((Object)this.inner())).recommended().memory().withMax(maxMB);
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedMemoryForVirtualMachine(int minMB, int maxMB) {
        if (((GalleryImageInner)((Object)this.inner())).recommended() == null) {
            ((GalleryImageInner)((Object)this.inner())).withRecommended(new RecommendedMachineConfiguration());
        }
        ((GalleryImageInner)((Object)this.inner())).recommended().withMemory(new ResourceRange());
        ((GalleryImageInner)((Object)this.inner())).recommended().memory().withMin(minMB);
        ((GalleryImageInner)((Object)this.inner())).recommended().memory().withMax(maxMB);
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedConfigurationForVirtualMachine(RecommendedMachineConfiguration recommendedConfig) {
        ((GalleryImageInner)((Object)this.inner())).withRecommended(recommendedConfig);
        return this;
    }

    @Override
    public GalleryImageImpl withReleaseNoteUri(String releaseNoteUri) {
        ((GalleryImageInner)((Object)this.inner())).withReleaseNoteUri(releaseNoteUri);
        return this;
    }

    @Override
    public GalleryImageImpl withTags(Map<String, String> tags) {
        ((GalleryImageInner)((Object)this.inner())).withTags(tags);
        return this;
    }

    private static String getValueFromIdByName(String id, String name) {
        if (id == null) {
            return null;
        }
        List<String> iterable = Arrays.asList(id.split("/"));
        Iterator itr = iterable.iterator();
        while (itr.hasNext()) {
            String part = (String)itr.next();
            if (part == null || part.trim() == "" || !part.equalsIgnoreCase(name)) continue;
            if (itr.hasNext()) {
                return (String)itr.next();
            }
            return null;
        }
        return null;
    }
}

