/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.implementation.ImageReferenceInner;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes a storage profile.
 */
public class StorageProfile {
    /**
     * The image reference.
     */
    @JsonProperty(value = "imageReference")
    private ImageReferenceInner imageReference;

    /**
     * The OS disk.
     */
    @JsonProperty(value = "osDisk")
    private OSDisk osDisk;

    /**
     * The data disks.
     */
    @JsonProperty(value = "dataDisks")
    private List<DataDisk> dataDisks;

    /**
     * Get the imageReference value.
     *
     * @return the imageReference value
     */
    public ImageReferenceInner imageReference() {
        return this.imageReference;
    }

    /**
     * Set the imageReference value.
     *
     * @param imageReference the imageReference value to set
     * @return the StorageProfile object itself.
     */
    public StorageProfile withImageReference(ImageReferenceInner imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    /**
     * Get the osDisk value.
     *
     * @return the osDisk value
     */
    public OSDisk osDisk() {
        return this.osDisk;
    }

    /**
     * Set the osDisk value.
     *
     * @param osDisk the osDisk value to set
     * @return the StorageProfile object itself.
     */
    public StorageProfile withOsDisk(OSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    /**
     * Get the dataDisks value.
     *
     * @return the dataDisks value
     */
    public List<DataDisk> dataDisks() {
        return this.dataDisks;
    }

    /**
     * Set the dataDisks value.
     *
     * @param dataDisks the dataDisks value to set
     * @return the StorageProfile object itself.
     */
    public StorageProfile withDataDisks(List<DataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

}
