/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.compute.CreationSource;
import com.microsoft.azure.management.compute.DiskCreateOption;
import com.microsoft.azure.management.compute.DiskSkuTypes;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.Snapshot;
import com.microsoft.azure.management.compute.VirtualMachineCustomImage;
import com.microsoft.azure.management.compute.VirtualMachineImage;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.DiskInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;

@Fluent
public interface Disk
extends GroupableResource<ComputeManager, DiskInner>,
Refreshable<Disk>,
Updatable<Update> {
    public DiskSkuTypes sku();

    public DiskCreateOption creationMethod();

    public boolean isAttachedToVirtualMachine();

    public String virtualMachineId();

    public int sizeInGB();

    public OperatingSystemTypes osType();

    public CreationSource source();

    public String grantAccess(int var1);

    public Observable<String> grantAccessAsync(int var1);

    public ServiceFuture<String> grantAccessAsync(int var1, ServiceCallback<String> var2);

    public void revokeAccess();

    public Completable revokeAccessAsync();

    public ServiceFuture<Void> revokeAccessAsync(ServiceCallback<Void> var1);

    public static interface Update
    extends Appliable<Disk>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithSize,
    UpdateStages.WithOSSettings {
    }

    public static interface UpdateStages {

        public static interface WithOSSettings {
            public Update withOSType(OperatingSystemTypes var1);
        }

        public static interface WithSize {
            public Update withSizeInGB(int var1);
        }

        public static interface WithSku {
            public Update withSku(DiskSkuTypes var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Disk>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSku {
        }

        public static interface WithSku {
            public WithCreate withSku(DiskSkuTypes var1);
        }

        public static interface WithCreateAndSize
        extends WithCreate {
            public WithCreateAndSize withSizeInGB(int var1);
        }

        public static interface WithDataDiskFromImage {
            public WithCreateAndSize fromImage(String var1, int var2);

            public WithCreateAndSize fromImage(VirtualMachineImage var1, int var2);

            public WithCreateAndSize fromImage(VirtualMachineCustomImage var1, int var2);
        }

        public static interface WithOSDiskFromImage {
            public WithCreateAndSize fromImage(String var1, OperatingSystemTypes var2);

            public WithCreateAndSize fromImage(VirtualMachineImage var1);

            public WithCreateAndSize fromImage(VirtualMachineCustomImage var1);
        }

        public static interface WithDataDiskFromSnapshot {
            public WithCreateAndSize fromSnapshot(String var1);

            public WithCreateAndSize fromSnapshot(Snapshot var1);
        }

        public static interface WithDataDiskFromDisk {
            public WithCreateAndSize fromDisk(String var1);

            public WithCreateAndSize fromDisk(Disk var1);
        }

        public static interface WithDataDiskFromVhd {
            public WithCreateAndSize fromVhd(String var1);
        }

        public static interface WithDataDiskSource
        extends WithDataDiskFromVhd,
        WithDataDiskFromDisk,
        WithDataDiskFromSnapshot {
            public WithCreate withSizeInGB(int var1);
        }

        public static interface WithData {
            public WithDataDiskSource withData();
        }

        public static interface WithLinuxDiskSource {
            public WithCreateAndSize withLinuxFromDisk(String var1);

            public WithCreateAndSize withLinuxFromDisk(Disk var1);

            public WithCreateAndSize withLinuxFromSnapshot(String var1);

            public WithCreateAndSize withLinuxFromSnapshot(Snapshot var1);

            public WithCreateAndSize withLinuxFromVhd(String var1);
        }

        public static interface WithWindowsDiskSource {
            public WithCreateAndSize withWindowsFromDisk(String var1);

            public WithCreateAndSize withWindowsFromDisk(Disk var1);

            public WithCreateAndSize withWindowsFromSnapshot(String var1);

            public WithCreateAndSize withWindowsFromSnapshot(Snapshot var1);

            public WithCreateAndSize withWindowsFromVhd(String var1);
        }

        public static interface WithDiskSource
        extends WithWindowsDiskSource,
        WithLinuxDiskSource,
        WithData {
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithDiskSource> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithDiskSource,
    DefinitionStages.WithWindowsDiskSource,
    DefinitionStages.WithLinuxDiskSource,
    DefinitionStages.WithData,
    DefinitionStages.WithDataDiskSource,
    DefinitionStages.WithDataDiskFromVhd,
    DefinitionStages.WithDataDiskFromDisk,
    DefinitionStages.WithDataDiskFromSnapshot,
    DefinitionStages.WithCreateAndSize,
    DefinitionStages.WithCreate {
    }
}

