/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.ImageReference;
import com.microsoft.azure.management.compute.KnownLinuxVirtualMachineImage;
import com.microsoft.azure.management.compute.KnownWindowsVirtualMachineImage;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.StorageAccountTypes;
import com.microsoft.azure.management.compute.UpgradeMode;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetExtension;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetNetworkProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetSku;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetSkuTypes;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetStorageProfile;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetVMs;
import com.microsoft.azure.management.compute.WinRMListener;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetInner;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerBackend;
import com.microsoft.azure.management.network.LoadBalancerInboundNatPool;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.VirtualMachineScaleSetNetworkInterface;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import rx.Completable;

@Fluent
public interface VirtualMachineScaleSet
extends GroupableResource<ComputeManager, VirtualMachineScaleSetInner>,
Refreshable<VirtualMachineScaleSet>,
Updatable<UpdateStages.WithPrimaryLoadBalancer> {
    public VirtualMachineScaleSetVMs virtualMachines();

    public PagedList<VirtualMachineScaleSetSku> listAvailableSkus();

    public void deallocate();

    public Completable deallocateAsync();

    public ServiceFuture<Void> deallocateAsync(ServiceCallback<Void> var1);

    public void powerOff();

    public Completable powerOffAsync();

    public ServiceFuture<Void> powerOffAsync(ServiceCallback<Void> var1);

    public void restart();

    public Completable restartAsync();

    public ServiceFuture<Void> restartAsync(ServiceCallback<Void> var1);

    public void start();

    public Completable startAsync();

    public ServiceFuture<Void> startAsync(ServiceCallback<Void> var1);

    public void reimage();

    public Completable reimageAsync();

    public ServiceFuture<Void> reimageAsync(ServiceCallback<Void> var1);

    public String computerNamePrefix();

    public OperatingSystemTypes osType();

    public CachingTypes osDiskCachingType();

    public String osDiskName();

    public UpgradeMode upgradeModel();

    public boolean overProvisionEnabled();

    public VirtualMachineScaleSetSkuTypes sku();

    public int capacity();

    public Network getPrimaryNetwork() throws IOException;

    public LoadBalancer getPrimaryInternetFacingLoadBalancer() throws IOException;

    public Map<String, LoadBalancerBackend> listPrimaryInternetFacingLoadBalancerBackends() throws IOException;

    public Map<String, LoadBalancerInboundNatPool> listPrimaryInternetFacingLoadBalancerInboundNatPools() throws IOException;

    public LoadBalancer getPrimaryInternalLoadBalancer() throws IOException;

    public Map<String, LoadBalancerBackend> listPrimaryInternalLoadBalancerBackends() throws IOException;

    public Map<String, LoadBalancerInboundNatPool> listPrimaryInternalLoadBalancerInboundNatPools() throws IOException;

    public List<String> primaryPublicIPAddressIds() throws IOException;

    public List<String> vhdContainers();

    public VirtualMachineScaleSetStorageProfile storageProfile();

    public VirtualMachineScaleSetNetworkProfile networkProfile();

    public Map<String, VirtualMachineScaleSetExtension> extensions();

    public VirtualMachineScaleSetNetworkInterface getNetworkInterfaceByInstanceId(String var1, String var2);

    public PagedList<VirtualMachineScaleSetNetworkInterface> listNetworkInterfaces();

    public PagedList<VirtualMachineScaleSetNetworkInterface> listNetworkInterfacesByInstanceId(String var1);

    public boolean isManagedDiskEnabled();

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public boolean isManagedServiceIdentityEnabled();

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public String managedServiceIdentityTenantId();

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public String managedServiceIdentityPrincipalId();

    public static interface Update
    extends UpdateStages.WithPrimaryLoadBalancer,
    UpdateStages.WithPrimaryInternetFacingLoadBalancerBackendOrNatPool,
    UpdateStages.WithPrimaryInternalLoadBalancerBackendOrNatPool {
    }

    public static interface UpdateStages {

        public static interface WithApply
        extends Appliable<VirtualMachineScaleSet>,
        Resource.UpdateWithTags<WithApply>,
        WithManagedDataDisk,
        WithUnmanagedDataDisk,
        WithSku,
        WithCapacity,
        WithExtension,
        WithoutPrimaryLoadBalancer,
        WithoutPrimaryLoadBalancerBackend,
        WithoutPrimaryLoadBalancerNatPool,
        WithManagedServiceIdentity {
        }

        public static interface WithManagedDataDisk {
            public WithApply withNewDataDisk(int var1);

            public WithApply withNewDataDisk(int var1, int var2, CachingTypes var3);

            public WithApply withNewDataDisk(int var1, int var2, CachingTypes var3, StorageAccountTypes var4);

            public WithApply withoutDataDisk(int var1);
        }

        public static interface WithUnmanagedDataDisk {
        }

        @Beta(value=Beta.SinceVersion.V1_2_0)
        public static interface WithRoleAndScopeOrApply
        extends WithApply {
            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrApply withRoleBasedAccessTo(String var1, BuiltInRole var2);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrApply withRoleBasedAccessToCurrentResourceGroup(BuiltInRole var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrApply withRoleDefinitionBasedAccessTo(String var1, String var2);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrApply withRoleDefinitionBasedAccessToCurrentResourceGroup(String var1);
        }

        @Beta(value=Beta.SinceVersion.V1_2_0)
        public static interface WithManagedServiceIdentity {
            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrApply withManagedServiceIdentity();

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrApply withManagedServiceIdentity(int var1);
        }

        public static interface WithoutPrimaryLoadBalancerNatPool {
            public WithApply withoutPrimaryInternetFacingLoadBalancerNatPools(String ... var1);

            public WithApply withoutPrimaryInternalLoadBalancerNatPools(String ... var1);
        }

        public static interface WithoutPrimaryLoadBalancerBackend {
            public WithApply withoutPrimaryInternetFacingLoadBalancerBackends(String ... var1);

            public WithApply withoutPrimaryInternalLoadBalancerBackends(String ... var1);
        }

        public static interface WithoutPrimaryLoadBalancer {
            public WithApply withoutPrimaryInternetFacingLoadBalancer();

            public WithApply withoutPrimaryInternalLoadBalancer();
        }

        public static interface WithExtension {
            public VirtualMachineScaleSetExtension.UpdateDefinitionStages.Blank<WithApply> defineNewExtension(String var1);

            public VirtualMachineScaleSetExtension.Update updateExtension(String var1);

            public WithApply withoutExtension(String var1);
        }

        public static interface WithCapacity {
            public WithApply withCapacity(int var1);
        }

        public static interface WithSku {
            public WithApply withSku(VirtualMachineScaleSetSkuTypes var1);

            public WithApply withSku(VirtualMachineScaleSetSku var1);
        }

        public static interface WithPrimaryInternalLoadBalancerNatPool
        extends WithApply {
            public WithApply withPrimaryInternalLoadBalancerInboundNatPools(String ... var1);
        }

        public static interface WithPrimaryInternalLoadBalancerBackendOrNatPool
        extends WithPrimaryInternalLoadBalancerNatPool {
            public WithPrimaryInternalLoadBalancerNatPool withPrimaryInternalLoadBalancerBackends(String ... var1);
        }

        public static interface WithPrimaryInternalLoadBalancer
        extends WithApply {
            public WithPrimaryInternalLoadBalancerBackendOrNatPool withExistingPrimaryInternalLoadBalancer(LoadBalancer var1);
        }

        public static interface WithPrimaryInternetFacingLoadBalancerNatPool
        extends WithPrimaryInternalLoadBalancer {
            public WithPrimaryInternalLoadBalancer withPrimaryInternetFacingLoadBalancerInboundNatPools(String ... var1);
        }

        public static interface WithPrimaryInternetFacingLoadBalancerBackendOrNatPool
        extends WithPrimaryInternetFacingLoadBalancerNatPool {
            public WithPrimaryInternetFacingLoadBalancerNatPool withPrimaryInternetFacingLoadBalancerBackends(String ... var1);
        }

        public static interface WithPrimaryLoadBalancer
        extends WithPrimaryInternalLoadBalancer {
            public WithPrimaryInternetFacingLoadBalancerBackendOrNatPool withExistingPrimaryInternetFacingLoadBalancer(LoadBalancer var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<VirtualMachineScaleSet>,
        WithOSDiskSettings,
        WithComputerNamePrefix,
        WithCapacity,
        WithUpgradePolicy,
        WithOverProvision,
        WithStorageAccount,
        WithCustomData,
        WithExtension,
        WithManagedServiceIdentity,
        Resource.DefinitionWithTags<WithCreate> {
        }

        @Beta(value=Beta.SinceVersion.V1_2_0)
        public static interface WithRoleAndScopeOrCreate
        extends WithCreate {
            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrCreate withRoleBasedAccessTo(String var1, BuiltInRole var2);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrCreate withRoleBasedAccessToCurrentResourceGroup(BuiltInRole var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrCreate withRoleDefinitionBasedAccessTo(String var1, String var2);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrCreate withRoleDefinitionBasedAccessToCurrentResourceGroup(String var1);
        }

        @Beta(value=Beta.SinceVersion.V1_2_0)
        public static interface WithManagedServiceIdentity {
            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrCreate withManagedServiceIdentity();

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public WithRoleAndScopeOrCreate withManagedServiceIdentity(int var1);
        }

        public static interface WithExtension {
            public VirtualMachineScaleSetExtension.DefinitionStages.Blank<WithCreate> defineNewExtension(String var1);
        }

        public static interface WithCustomData {
            public WithCreate withCustomData(String var1);
        }

        public static interface WithStorageAccount {
            public WithCreate withNewStorageAccount(String var1);

            public WithCreate withNewStorageAccount(Creatable<StorageAccount> var1);

            public WithCreate withExistingStorageAccount(StorageAccount var1);
        }

        public static interface WithOSDiskSettings {
            public WithCreate withOSDiskCaching(CachingTypes var1);

            public WithCreate withOSDiskName(String var1);
        }

        public static interface WithOverProvision {
            public WithCreate withOverProvision(boolean var1);

            public WithCreate withOverProvisioning();

            public WithCreate withoutOverProvisioning();
        }

        public static interface WithUpgradePolicy {
            public WithCreate withUpgradeMode(UpgradeMode var1);
        }

        public static interface WithCapacity {
            public WithCreate withCapacity(int var1);
        }

        public static interface WithComputerNamePrefix {
            public WithCreate withComputerNamePrefix(String var1);
        }

        public static interface WithUnmanagedCreate
        extends WithUnmanagedDataDisk,
        WithCreate {
        }

        public static interface WithUnmanagedDataDisk {
        }

        public static interface WithManagedCreate
        extends WithManagedDataDisk,
        WithManagedDiskOptionals,
        WithCreate {
        }

        public static interface WithManagedDiskOptionals {
            public WithManagedCreate withOSDiskStorageAccountType(StorageAccountTypes var1);

            public WithManagedCreate withDataDiskDefaultCachingType(CachingTypes var1);

            public WithManagedCreate withDataDiskDefaultStorageAccountType(StorageAccountTypes var1);
        }

        public static interface WithManagedDataDisk {
            public WithManagedCreate withNewDataDisk(int var1);

            public WithManagedCreate withNewDataDisk(int var1, int var2, CachingTypes var3);

            public WithManagedCreate withNewDataDisk(int var1, int var2, CachingTypes var3, StorageAccountTypes var4);

            public WithManagedCreate withNewDataDiskFromImage(int var1);

            public WithManagedCreate withNewDataDiskFromImage(int var1, int var2, CachingTypes var3);

            public WithManagedCreate withNewDataDiskFromImage(int var1, int var2, CachingTypes var3, StorageAccountTypes var4);
        }

        public static interface WithWindowsCreateUnmanaged
        extends WithUnmanagedCreate {
            public WithWindowsCreateUnmanaged withVMAgent();

            public WithWindowsCreateUnmanaged withoutVMAgent();

            public WithWindowsCreateUnmanaged withAutoUpdate();

            public WithWindowsCreateUnmanaged withoutAutoUpdate();

            public WithWindowsCreateUnmanaged withTimeZone(String var1);

            public WithWindowsCreateUnmanaged withWinRM(WinRMListener var1);
        }

        public static interface WithWindowsCreateManaged
        extends WithManagedCreate {
            public WithWindowsCreateManaged withVMAgent();

            public WithWindowsCreateManaged withoutVMAgent();

            public WithWindowsCreateManaged withAutoUpdate();

            public WithWindowsCreateManaged withoutAutoUpdate();

            public WithWindowsCreateManaged withTimeZone(String var1);

            public WithWindowsCreateManaged withWinRM(WinRMListener var1);
        }

        public static interface WithWindowsCreateManagedOrUnmanaged
        extends WithWindowsCreateManaged {
            public WithWindowsCreateUnmanaged withUnmanagedDisks();
        }

        public static interface WithLinuxCreateUnmanaged
        extends WithUnmanagedCreate {
            public WithLinuxCreateUnmanaged withSsh(String var1);
        }

        public static interface WithLinuxCreateManaged
        extends WithManagedCreate {
            public WithLinuxCreateManaged withSsh(String var1);
        }

        public static interface WithLinuxCreateManagedOrUnmanaged
        extends WithManagedCreate {
            public WithLinuxCreateManagedOrUnmanaged withSsh(String var1);

            public WithUnmanagedCreate withUnmanagedDisks();
        }

        public static interface WithWindowsAdminPasswordUnmanaged {
            public WithWindowsCreateUnmanaged withAdminPassword(String var1);
        }

        public static interface WithWindowsAdminPasswordManaged {
            public WithWindowsCreateManaged withAdminPassword(String var1);
        }

        public static interface WithWindowsAdminPasswordManagedOrUnmanaged {
            public WithWindowsCreateManagedOrUnmanaged withAdminPassword(String var1);
        }

        public static interface WithWindowsAdminUsernameUnmanaged {
            public WithWindowsAdminPasswordUnmanaged withAdminUsername(String var1);
        }

        public static interface WithWindowsAdminUsernameManaged {
            public WithWindowsAdminPasswordManaged withAdminUsername(String var1);
        }

        public static interface WithWindowsAdminUsernameManagedOrUnmanaged {
            public WithWindowsAdminPasswordManagedOrUnmanaged withAdminUsername(String var1);
        }

        public static interface WithLinuxRootPasswordOrPublicKeyUnmanaged {
            public WithLinuxCreateUnmanaged withRootPassword(String var1);

            public WithLinuxCreateUnmanaged withSsh(String var1);
        }

        public static interface WithLinuxRootPasswordOrPublicKeyManaged {
            public WithLinuxCreateManaged withRootPassword(String var1);

            public WithLinuxCreateManaged withSsh(String var1);
        }

        public static interface WithLinuxRootPasswordOrPublicKeyManagedOrUnmanaged {
            public WithLinuxCreateManagedOrUnmanaged withRootPassword(String var1);

            public WithLinuxCreateManagedOrUnmanaged withSsh(String var1);
        }

        public static interface WithLinuxRootUsernameUnmanaged {
            public WithLinuxRootPasswordOrPublicKeyUnmanaged withRootUsername(String var1);
        }

        public static interface WithLinuxRootUsernameManaged {
            public WithLinuxRootPasswordOrPublicKeyManaged withRootUsername(String var1);
        }

        public static interface WithLinuxRootUsernameManagedOrUnmanaged {
            public WithLinuxRootPasswordOrPublicKeyManagedOrUnmanaged withRootUsername(String var1);
        }

        public static interface WithOS {
            public WithWindowsAdminUsernameManagedOrUnmanaged withPopularWindowsImage(KnownWindowsVirtualMachineImage var1);

            public WithWindowsAdminUsernameManagedOrUnmanaged withLatestWindowsImage(String var1, String var2, String var3);

            public WithWindowsAdminUsernameManagedOrUnmanaged withSpecificWindowsImageVersion(ImageReference var1);

            public WithWindowsAdminUsernameManaged withWindowsCustomImage(String var1);

            public WithWindowsAdminUsernameUnmanaged withStoredWindowsImage(String var1);

            public WithLinuxRootUsernameManagedOrUnmanaged withPopularLinuxImage(KnownLinuxVirtualMachineImage var1);

            public WithLinuxRootUsernameManagedOrUnmanaged withLatestLinuxImage(String var1, String var2, String var3);

            public WithLinuxRootUsernameManagedOrUnmanaged withSpecificLinuxImageVersion(ImageReference var1);

            public WithLinuxRootUsernameManaged withLinuxCustomImage(String var1);

            public WithLinuxRootUsernameUnmanaged withStoredLinuxImage(String var1);
        }

        public static interface WithInternalInternalLoadBalancerNatPool
        extends WithOS {
            public WithOS withPrimaryInternalLoadBalancerInboundNatPools(String ... var1);
        }

        public static interface WithInternalLoadBalancerBackendOrNatPool
        extends WithInternalInternalLoadBalancerNatPool {
            public WithInternalInternalLoadBalancerNatPool withPrimaryInternalLoadBalancerBackends(String ... var1);
        }

        public static interface WithPrimaryInternetFacingLoadBalancerNatPool
        extends WithPrimaryInternalLoadBalancer {
            public WithPrimaryInternalLoadBalancer withPrimaryInternetFacingLoadBalancerInboundNatPools(String ... var1);
        }

        public static interface WithPrimaryInternetFacingLoadBalancerBackendOrNatPool
        extends WithPrimaryInternetFacingLoadBalancerNatPool {
            public WithPrimaryInternetFacingLoadBalancerNatPool withPrimaryInternetFacingLoadBalancerBackends(String ... var1);
        }

        public static interface WithPrimaryInternalLoadBalancer {
            public WithInternalLoadBalancerBackendOrNatPool withExistingPrimaryInternalLoadBalancer(LoadBalancer var1);

            public WithOS withoutPrimaryInternalLoadBalancer();
        }

        public static interface WithPrimaryInternetFacingLoadBalancer {
            public WithPrimaryInternetFacingLoadBalancerBackendOrNatPool withExistingPrimaryInternetFacingLoadBalancer(LoadBalancer var1);

            public WithPrimaryInternalLoadBalancer withoutPrimaryInternetFacingLoadBalancer();
        }

        public static interface WithNetworkSubnet {
            public WithPrimaryInternetFacingLoadBalancer withExistingPrimaryNetworkSubnet(Network var1, String var2);
        }

        public static interface WithSku {
            public WithNetworkSubnet withSku(VirtualMachineScaleSetSkuTypes var1);

            public WithNetworkSubnet withSku(VirtualMachineScaleSetSku var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSku> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface DefinitionUnmanaged
    extends DefinitionShared,
    DefinitionStages.WithLinuxRootUsernameUnmanaged,
    DefinitionStages.WithLinuxRootPasswordOrPublicKeyUnmanaged,
    DefinitionStages.WithWindowsAdminUsernameUnmanaged,
    DefinitionStages.WithWindowsAdminPasswordUnmanaged,
    DefinitionStages.WithLinuxCreateUnmanaged,
    DefinitionStages.WithWindowsCreateUnmanaged,
    DefinitionStages.WithUnmanagedCreate {
    }

    public static interface DefinitionManaged
    extends DefinitionShared,
    DefinitionStages.WithLinuxRootUsernameManaged,
    DefinitionStages.WithLinuxRootPasswordOrPublicKeyManaged,
    DefinitionStages.WithWindowsAdminUsernameManaged,
    DefinitionStages.WithWindowsAdminPasswordManaged,
    DefinitionStages.WithLinuxCreateManaged,
    DefinitionStages.WithWindowsCreateManaged,
    DefinitionStages.WithManagedCreate {
    }

    public static interface DefinitionManagedOrUnmanaged
    extends DefinitionShared,
    DefinitionStages.WithLinuxRootUsernameManagedOrUnmanaged,
    DefinitionStages.WithLinuxRootPasswordOrPublicKeyManagedOrUnmanaged,
    DefinitionStages.WithWindowsAdminUsernameManagedOrUnmanaged,
    DefinitionStages.WithWindowsAdminPasswordManagedOrUnmanaged,
    DefinitionStages.WithLinuxCreateManagedOrUnmanaged,
    DefinitionStages.WithWindowsCreateManagedOrUnmanaged,
    DefinitionStages.WithManagedCreate,
    DefinitionStages.WithUnmanagedCreate {
    }

    public static interface DefinitionShared
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithNetworkSubnet,
    DefinitionStages.WithPrimaryInternetFacingLoadBalancer,
    DefinitionStages.WithPrimaryInternalLoadBalancer,
    DefinitionStages.WithPrimaryInternetFacingLoadBalancerBackendOrNatPool,
    DefinitionStages.WithInternalLoadBalancerBackendOrNatPool,
    DefinitionStages.WithPrimaryInternetFacingLoadBalancerNatPool,
    DefinitionStages.WithInternalInternalLoadBalancerNatPool,
    DefinitionStages.WithOS,
    DefinitionStages.WithCreate {
    }
}

