/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.ContainerService;
import com.microsoft.azure.management.compute.ContainerServiceAgentPool;
import com.microsoft.azure.management.compute.ContainerServiceAgentPoolProfile;
import com.microsoft.azure.management.compute.ContainerServiceDiagnosticsProfile;
import com.microsoft.azure.management.compute.ContainerServiceLinuxProfile;
import com.microsoft.azure.management.compute.ContainerServiceMasterProfile;
import com.microsoft.azure.management.compute.ContainerServiceMasterProfileCount;
import com.microsoft.azure.management.compute.ContainerServiceOchestratorTypes;
import com.microsoft.azure.management.compute.ContainerServiceOrchestratorProfile;
import com.microsoft.azure.management.compute.ContainerServiceServicePrincipalProfile;
import com.microsoft.azure.management.compute.ContainerServiceSshConfiguration;
import com.microsoft.azure.management.compute.ContainerServiceSshPublicKey;
import com.microsoft.azure.management.compute.ContainerServiceVMDiagnostics;
import com.microsoft.azure.management.compute.ContainerServiceVMSizeTypes;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.ContainerServiceAgentPoolImpl;
import com.microsoft.azure.management.compute.implementation.ContainerServiceInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import java.util.ArrayList;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class ContainerServiceImpl
extends GroupableResourceImpl<ContainerService, ContainerServiceInner, ContainerServiceImpl, ComputeManager>
implements ContainerService,
ContainerService.Definition,
ContainerService.Update {
    protected ContainerServiceImpl(String name, ContainerServiceInner innerObject, ComputeManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        if (((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles() == null) {
            ((ContainerServiceInner)((Object)this.inner())).withAgentPoolProfiles(new ArrayList<ContainerServiceAgentPoolProfile>());
        }
    }

    @Override
    public int masterNodeCount() {
        if (((ContainerServiceInner)((Object)this.inner())).masterProfile() == null || ((ContainerServiceInner)((Object)this.inner())).masterProfile().count() == null) {
            return 0;
        }
        return ((ContainerServiceInner)((Object)this.inner())).masterProfile().count();
    }

    @Override
    public ContainerServiceOchestratorTypes orchestratorType() {
        if (((ContainerServiceInner)((Object)this.inner())).orchestratorProfile() == null) {
            throw new RuntimeException("Orchestrator profile is missing!");
        }
        return ((ContainerServiceInner)((Object)this.inner())).orchestratorProfile().orchestratorType();
    }

    @Override
    public String masterLeafDomainLabel() {
        if (((ContainerServiceInner)((Object)this.inner())).masterProfile() == null) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).masterProfile().dnsPrefix();
    }

    @Override
    public String masterFqdn() {
        if (((ContainerServiceInner)((Object)this.inner())).masterProfile() == null) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).masterProfile().fqdn();
    }

    @Override
    public String agentPoolName() {
        if (this.getSingleAgentPool() == null) {
            return null;
        }
        return this.getSingleAgentPool().name();
    }

    @Override
    public int agentPoolCount() {
        if (this.getSingleAgentPool() == null) {
            return 0;
        }
        return this.getSingleAgentPool().count();
    }

    @Override
    public String agentPoolLeafDomainLabel() {
        if (this.getSingleAgentPool() == null) {
            return null;
        }
        return this.getSingleAgentPool().dnsPrefix();
    }

    @Override
    public ContainerServiceVMSizeTypes agentPoolVMSize() {
        if (this.getSingleAgentPool() == null) {
            return new ContainerServiceVMSizeTypes("Unknown");
        }
        return this.getSingleAgentPool().vmSize();
    }

    @Override
    public String agentPoolFqdn() {
        if (this.getSingleAgentPool() == null) {
            return null;
        }
        return this.getSingleAgentPool().fqdn();
    }

    @Override
    public String linuxRootUsername() {
        if (((ContainerServiceInner)((Object)this.inner())).linuxProfile() == null) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).linuxProfile().adminUsername();
    }

    @Override
    public String sshKey() {
        if (((ContainerServiceInner)((Object)this.inner())).linuxProfile() == null || ((ContainerServiceInner)((Object)this.inner())).linuxProfile().ssh() == null || ((ContainerServiceInner)((Object)this.inner())).linuxProfile().ssh().publicKeys() == null || ((ContainerServiceInner)((Object)this.inner())).linuxProfile().ssh().publicKeys().size() == 0) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).linuxProfile().ssh().publicKeys().get(0).keyData();
    }

    @Override
    public String servicePrincipalClientId() {
        if (((ContainerServiceInner)((Object)this.inner())).servicePrincipalProfile() == null) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).servicePrincipalProfile().clientId();
    }

    @Override
    public String servicePrincipalSecret() {
        if (((ContainerServiceInner)((Object)this.inner())).servicePrincipalProfile() == null) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).servicePrincipalProfile().secret();
    }

    @Override
    public boolean isDiagnosticsEnabled() {
        if (((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile() == null || ((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile().vmDiagnostics() == null) {
            throw new RuntimeException("Diagnostic profile is missing!");
        }
        return ((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile().vmDiagnostics().enabled();
    }

    @Override
    public ContainerServiceImpl withMasterNodeCount(ContainerServiceMasterProfileCount profileCount) {
        ContainerServiceMasterProfile masterProfile = new ContainerServiceMasterProfile();
        masterProfile.withCount(profileCount.count());
        ((ContainerServiceInner)((Object)this.inner())).withMasterProfile(masterProfile);
        return this;
    }

    @Override
    public ContainerServiceImpl withMasterLeafDomainLabel(String dnsPrefix) {
        ((ContainerServiceInner)((Object)this.inner())).masterProfile().withDnsPrefix(dnsPrefix);
        return this;
    }

    public ContainerServiceAgentPoolImpl defineAgentPool(String name) {
        ContainerServiceAgentPoolProfile innerPoolProfile = new ContainerServiceAgentPoolProfile();
        innerPoolProfile.withName(name);
        return new ContainerServiceAgentPoolImpl(innerPoolProfile, this);
    }

    @Override
    public ContainerServiceImpl withDiagnostics() {
        this.withDiagnosticsProfile(true);
        return this;
    }

    @Override
    public ContainerServiceImpl withLinux() {
        if (((ContainerServiceInner)((Object)this.inner())).linuxProfile() == null) {
            ((ContainerServiceInner)((Object)this.inner())).withLinuxProfile(new ContainerServiceLinuxProfile());
        }
        return this;
    }

    @Override
    public ContainerServiceImpl withRootUsername(String rootUserName) {
        ((ContainerServiceInner)((Object)this.inner())).linuxProfile().withAdminUsername(rootUserName);
        return this;
    }

    @Override
    public ContainerServiceImpl withSshKey(String sshKeyData) {
        ContainerServiceSshConfiguration ssh = new ContainerServiceSshConfiguration();
        ssh.withPublicKeys(new ArrayList<ContainerServiceSshPublicKey>());
        ContainerServiceSshPublicKey sshPublicKey = new ContainerServiceSshPublicKey();
        sshPublicKey.withKeyData(sshKeyData);
        ssh.publicKeys().add(sshPublicKey);
        ((ContainerServiceInner)((Object)this.inner())).linuxProfile().withSsh(ssh);
        return this;
    }

    @Override
    public ContainerServiceImpl withSwarmOrchestration() {
        this.withOrchestratorProfile(ContainerServiceOchestratorTypes.SWARM);
        return this;
    }

    @Override
    public ContainerServiceImpl withDcosOrchestration() {
        this.withOrchestratorProfile(ContainerServiceOchestratorTypes.DCOS);
        return this;
    }

    @Override
    public ContainerServiceImpl withKubernetesOrchestration() {
        this.withOrchestratorProfile(ContainerServiceOchestratorTypes.KUBERNETES);
        return this;
    }

    @Override
    public ContainerServiceImpl withServicePrincipal(String clientId, String secret) {
        ContainerServiceServicePrincipalProfile serviceProfile = new ContainerServiceServicePrincipalProfile();
        serviceProfile.withClientId(clientId);
        serviceProfile.withSecret(secret);
        ((ContainerServiceInner)((Object)this.inner())).withServicePrincipalProfile(serviceProfile);
        return this;
    }

    void attachAgentPoolProfile(ContainerServiceAgentPool agentPoolProfile) {
        ((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles().add((ContainerServiceAgentPoolProfile)agentPoolProfile.inner());
    }

    private ContainerServiceImpl withOrchestratorProfile(ContainerServiceOchestratorTypes orchestratorType) {
        ContainerServiceOrchestratorProfile orchestratorProfile = new ContainerServiceOrchestratorProfile();
        orchestratorProfile.withOrchestratorType(orchestratorType);
        ((ContainerServiceInner)((Object)this.inner())).withOrchestratorProfile(orchestratorProfile);
        return this;
    }

    private ContainerServiceImpl withDiagnosticsProfile(boolean enabled) {
        if (((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile() == null) {
            ((ContainerServiceInner)((Object)this.inner())).withDiagnosticsProfile(new ContainerServiceDiagnosticsProfile());
        }
        if (((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile().vmDiagnostics() == null) {
            ((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile().withVmDiagnostics(new ContainerServiceVMDiagnostics());
        }
        ((ContainerServiceInner)((Object)this.inner())).diagnosticsProfile().vmDiagnostics().withEnabled(enabled);
        return this;
    }

    @Override
    public ContainerServiceImpl withAgentVMCount(int agentCount) {
        ((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles().get(0).withCount(agentCount);
        return this;
    }

    protected Observable<ContainerServiceInner> getInnerAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).containerServices().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<ContainerService> createResourceAsync() {
        final ContainerServiceImpl self = this;
        if (!this.isInCreateMode()) {
            ((ContainerServiceInner)((Object)this.inner())).withServicePrincipalProfile(null);
        }
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).containerServices().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ContainerServiceInner)((Object)this.inner())).map((Func1)new Func1<ContainerServiceInner, ContainerService>(){

            public ContainerService call(ContainerServiceInner containerServiceInner) {
                self.setInner((Object)containerServiceInner);
                return self;
            }
        });
    }

    private ContainerServiceAgentPoolProfile getSingleAgentPool() {
        if (((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles() == null || ((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles().size() == 0) {
            return null;
        }
        return ((ContainerServiceInner)((Object)this.inner())).agentPoolProfiles().get(0);
    }
}

