/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.implementation.AccessUriInner;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.GrantAccessDataInner;
import com.microsoft.azure.management.compute.implementation.OperationStatusResponseInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.compute.implementation.SnapshotInner;
import com.microsoft.azure.management.compute.implementation.SnapshotUpdateInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class SnapshotsInner
implements InnerSupportsGet<SnapshotInner>,
InnerSupportsDelete<OperationStatusResponseInner>,
InnerSupportsListing<SnapshotInner> {
    private SnapshotsService service;
    private ComputeManagementClientImpl client;

    public SnapshotsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (SnapshotsService)retrofit.create(SnapshotsService.class);
        this.client = client;
    }

    public SnapshotInner createOrUpdate(String resourceGroupName, String snapshotName, SnapshotInner snapshot) {
        return (SnapshotInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot).toBlocking().last()).body());
    }

    public ServiceFuture<SnapshotInner> createOrUpdateAsync(String resourceGroupName, String snapshotName, SnapshotInner snapshot, ServiceCallback<SnapshotInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot), serviceCallback);
    }

    public Observable<SnapshotInner> createOrUpdateAsync(String resourceGroupName, String snapshotName, SnapshotInner snapshot) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot).map((Func1)new Func1<ServiceResponse<SnapshotInner>, SnapshotInner>(){

            public SnapshotInner call(ServiceResponse<SnapshotInner> response) {
                return (SnapshotInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SnapshotInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String snapshotName, SnapshotInner snapshot) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (snapshotName == null) {
            throw new IllegalArgumentException("Parameter snapshotName is required and cannot be null.");
        }
        if (snapshot == null) {
            throw new IllegalArgumentException("Parameter snapshot is required and cannot be null.");
        }
        Validator.validate((Object)((Object)snapshot));
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, snapshotName, "2016-04-30-preview", snapshot, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SnapshotInner>(){}.getType());
    }

    public SnapshotInner beginCreateOrUpdate(String resourceGroupName, String snapshotName, SnapshotInner snapshot) {
        return (SnapshotInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot).toBlocking().single()).body());
    }

    public ServiceFuture<SnapshotInner> beginCreateOrUpdateAsync(String resourceGroupName, String snapshotName, SnapshotInner snapshot, ServiceCallback<SnapshotInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot), serviceCallback);
    }

    public Observable<SnapshotInner> beginCreateOrUpdateAsync(String resourceGroupName, String snapshotName, SnapshotInner snapshot) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot).map((Func1)new Func1<ServiceResponse<SnapshotInner>, SnapshotInner>(){

            public SnapshotInner call(ServiceResponse<SnapshotInner> response) {
                return (SnapshotInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SnapshotInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String snapshotName, SnapshotInner snapshot) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (snapshotName == null) {
            throw new IllegalArgumentException("Parameter snapshotName is required and cannot be null.");
        }
        if (snapshot == null) {
            throw new IllegalArgumentException("Parameter snapshot is required and cannot be null.");
        }
        Validator.validate((Object)((Object)snapshot));
        String apiVersion = "2016-04-30-preview";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, snapshotName, "2016-04-30-preview", snapshot, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SnapshotInner>>>(){

            public Observable<ServiceResponse<SnapshotInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SnapshotsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SnapshotInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SnapshotInner>(){}.getType()).register(202, new TypeToken<SnapshotInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SnapshotInner update(String resourceGroupName, String snapshotName, SnapshotUpdateInner snapshot) {
        return (SnapshotInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot).toBlocking().last()).body());
    }

    public ServiceFuture<SnapshotInner> updateAsync(String resourceGroupName, String snapshotName, SnapshotUpdateInner snapshot, ServiceCallback<SnapshotInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot), serviceCallback);
    }

    public Observable<SnapshotInner> updateAsync(String resourceGroupName, String snapshotName, SnapshotUpdateInner snapshot) {
        return this.updateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot).map((Func1)new Func1<ServiceResponse<SnapshotInner>, SnapshotInner>(){

            public SnapshotInner call(ServiceResponse<SnapshotInner> response) {
                return (SnapshotInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SnapshotInner>> updateWithServiceResponseAsync(String resourceGroupName, String snapshotName, SnapshotUpdateInner snapshot) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (snapshotName == null) {
            throw new IllegalArgumentException("Parameter snapshotName is required and cannot be null.");
        }
        if (snapshot == null) {
            throw new IllegalArgumentException("Parameter snapshot is required and cannot be null.");
        }
        Validator.validate((Object)snapshot);
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, snapshotName, "2016-04-30-preview", snapshot, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SnapshotInner>(){}.getType());
    }

    public SnapshotInner beginUpdate(String resourceGroupName, String snapshotName, SnapshotUpdateInner snapshot) {
        return (SnapshotInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot).toBlocking().single()).body());
    }

    public ServiceFuture<SnapshotInner> beginUpdateAsync(String resourceGroupName, String snapshotName, SnapshotUpdateInner snapshot, ServiceCallback<SnapshotInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot), serviceCallback);
    }

    public Observable<SnapshotInner> beginUpdateAsync(String resourceGroupName, String snapshotName, SnapshotUpdateInner snapshot) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, snapshotName, snapshot).map((Func1)new Func1<ServiceResponse<SnapshotInner>, SnapshotInner>(){

            public SnapshotInner call(ServiceResponse<SnapshotInner> response) {
                return (SnapshotInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SnapshotInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String snapshotName, SnapshotUpdateInner snapshot) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (snapshotName == null) {
            throw new IllegalArgumentException("Parameter snapshotName is required and cannot be null.");
        }
        if (snapshot == null) {
            throw new IllegalArgumentException("Parameter snapshot is required and cannot be null.");
        }
        Validator.validate((Object)snapshot);
        String apiVersion = "2016-04-30-preview";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, snapshotName, "2016-04-30-preview", snapshot, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SnapshotInner>>>(){

            public Observable<ServiceResponse<SnapshotInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SnapshotsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SnapshotInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SnapshotInner>(){}.getType()).register(202, new TypeToken<SnapshotInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SnapshotInner getByResourceGroup(String resourceGroupName, String snapshotName) {
        return (SnapshotInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, snapshotName).toBlocking().single()).body());
    }

    public ServiceFuture<SnapshotInner> getByResourceGroupAsync(String resourceGroupName, String snapshotName, ServiceCallback<SnapshotInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, snapshotName), serviceCallback);
    }

    public Observable<SnapshotInner> getByResourceGroupAsync(String resourceGroupName, String snapshotName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, snapshotName).map((Func1)new Func1<ServiceResponse<SnapshotInner>, SnapshotInner>(){

            public SnapshotInner call(ServiceResponse<SnapshotInner> response) {
                return (SnapshotInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SnapshotInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String snapshotName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (snapshotName == null) {
            throw new IllegalArgumentException("Parameter snapshotName is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, snapshotName, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SnapshotInner>>>(){

            public Observable<ServiceResponse<SnapshotInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SnapshotsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SnapshotInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SnapshotInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner delete(String resourceGroupName, String snapshotName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, snapshotName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> deleteAsync(String resourceGroupName, String snapshotName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, snapshotName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> deleteAsync(String resourceGroupName, String snapshotName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, snapshotName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> deleteWithServiceResponseAsync(String resourceGroupName, String snapshotName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (snapshotName == null) {
            throw new IllegalArgumentException("Parameter snapshotName is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, snapshotName, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginDelete(String resourceGroupName, String snapshotName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, snapshotName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginDeleteAsync(String resourceGroupName, String snapshotName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, snapshotName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginDeleteAsync(String resourceGroupName, String snapshotName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, snapshotName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String snapshotName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (snapshotName == null) {
            throw new IllegalArgumentException("Parameter snapshotName is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, snapshotName, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SnapshotsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SnapshotInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<SnapshotInner>((Page)response.body()){

            public Page<SnapshotInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SnapshotsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SnapshotInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<SnapshotInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(String nextPageLink) {
                return SnapshotsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SnapshotInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<SnapshotInner>>, Page<SnapshotInner>>(){

            public Page<SnapshotInner> call(ServiceResponse<Page<SnapshotInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SnapshotInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<SnapshotInner>>, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(ServiceResponse<Page<SnapshotInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SnapshotsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SnapshotInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SnapshotsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SnapshotInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SnapshotInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SnapshotInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<SnapshotInner>((Page)response.body()){

            public Page<SnapshotInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SnapshotsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SnapshotInner>> listAsync(ListOperationCallback<SnapshotInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(String nextPageLink) {
                return SnapshotsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SnapshotInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<SnapshotInner>>, Page<SnapshotInner>>(){

            public Page<SnapshotInner> call(ServiceResponse<Page<SnapshotInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SnapshotInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<SnapshotInner>>, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(ServiceResponse<Page<SnapshotInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SnapshotsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SnapshotInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.list(this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SnapshotsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SnapshotInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SnapshotInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AccessUriInner grantAccess(String resourceGroupName, String snapshotName, GrantAccessDataInner grantAccessData) {
        return (AccessUriInner)((ServiceResponse)this.grantAccessWithServiceResponseAsync(resourceGroupName, snapshotName, grantAccessData).toBlocking().last()).body();
    }

    public ServiceFuture<AccessUriInner> grantAccessAsync(String resourceGroupName, String snapshotName, GrantAccessDataInner grantAccessData, ServiceCallback<AccessUriInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.grantAccessWithServiceResponseAsync(resourceGroupName, snapshotName, grantAccessData), serviceCallback);
    }

    public Observable<AccessUriInner> grantAccessAsync(String resourceGroupName, String snapshotName, GrantAccessDataInner grantAccessData) {
        return this.grantAccessWithServiceResponseAsync(resourceGroupName, snapshotName, grantAccessData).map((Func1)new Func1<ServiceResponse<AccessUriInner>, AccessUriInner>(){

            public AccessUriInner call(ServiceResponse<AccessUriInner> response) {
                return (AccessUriInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AccessUriInner>> grantAccessWithServiceResponseAsync(String resourceGroupName, String snapshotName, GrantAccessDataInner grantAccessData) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (snapshotName == null) {
            throw new IllegalArgumentException("Parameter snapshotName is required and cannot be null.");
        }
        if (grantAccessData == null) {
            throw new IllegalArgumentException("Parameter grantAccessData is required and cannot be null.");
        }
        Validator.validate((Object)grantAccessData);
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.grantAccess(this.client.subscriptionId(), resourceGroupName, snapshotName, "2016-04-30-preview", grantAccessData, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<AccessUriInner>(){}.getType());
    }

    public AccessUriInner beginGrantAccess(String resourceGroupName, String snapshotName, GrantAccessDataInner grantAccessData) {
        return (AccessUriInner)((ServiceResponse)this.beginGrantAccessWithServiceResponseAsync(resourceGroupName, snapshotName, grantAccessData).toBlocking().single()).body();
    }

    public ServiceFuture<AccessUriInner> beginGrantAccessAsync(String resourceGroupName, String snapshotName, GrantAccessDataInner grantAccessData, ServiceCallback<AccessUriInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGrantAccessWithServiceResponseAsync(resourceGroupName, snapshotName, grantAccessData), serviceCallback);
    }

    public Observable<AccessUriInner> beginGrantAccessAsync(String resourceGroupName, String snapshotName, GrantAccessDataInner grantAccessData) {
        return this.beginGrantAccessWithServiceResponseAsync(resourceGroupName, snapshotName, grantAccessData).map((Func1)new Func1<ServiceResponse<AccessUriInner>, AccessUriInner>(){

            public AccessUriInner call(ServiceResponse<AccessUriInner> response) {
                return (AccessUriInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AccessUriInner>> beginGrantAccessWithServiceResponseAsync(String resourceGroupName, String snapshotName, GrantAccessDataInner grantAccessData) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (snapshotName == null) {
            throw new IllegalArgumentException("Parameter snapshotName is required and cannot be null.");
        }
        if (grantAccessData == null) {
            throw new IllegalArgumentException("Parameter grantAccessData is required and cannot be null.");
        }
        Validator.validate((Object)grantAccessData);
        String apiVersion = "2016-04-30-preview";
        return this.service.beginGrantAccess(this.client.subscriptionId(), resourceGroupName, snapshotName, "2016-04-30-preview", grantAccessData, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AccessUriInner>>>(){

            public Observable<ServiceResponse<AccessUriInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SnapshotsInner.this.beginGrantAccessDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AccessUriInner> beginGrantAccessDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AccessUriInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner revokeAccess(String resourceGroupName, String snapshotName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.revokeAccessWithServiceResponseAsync(resourceGroupName, snapshotName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> revokeAccessAsync(String resourceGroupName, String snapshotName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.revokeAccessWithServiceResponseAsync(resourceGroupName, snapshotName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> revokeAccessAsync(String resourceGroupName, String snapshotName) {
        return this.revokeAccessWithServiceResponseAsync(resourceGroupName, snapshotName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> revokeAccessWithServiceResponseAsync(String resourceGroupName, String snapshotName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (snapshotName == null) {
            throw new IllegalArgumentException("Parameter snapshotName is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.revokeAccess(this.client.subscriptionId(), resourceGroupName, snapshotName, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginRevokeAccess(String resourceGroupName, String snapshotName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginRevokeAccessWithServiceResponseAsync(resourceGroupName, snapshotName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginRevokeAccessAsync(String resourceGroupName, String snapshotName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRevokeAccessWithServiceResponseAsync(resourceGroupName, snapshotName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginRevokeAccessAsync(String resourceGroupName, String snapshotName) {
        return this.beginRevokeAccessWithServiceResponseAsync(resourceGroupName, snapshotName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginRevokeAccessWithServiceResponseAsync(String resourceGroupName, String snapshotName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (snapshotName == null) {
            throw new IllegalArgumentException("Parameter snapshotName is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.beginRevokeAccess(this.client.subscriptionId(), resourceGroupName, snapshotName, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SnapshotsInner.this.beginRevokeAccessDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginRevokeAccessDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SnapshotInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SnapshotInner>((Page)response.body()){

            public Page<SnapshotInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SnapshotsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SnapshotInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<SnapshotInner>> serviceFuture, ListOperationCallback<SnapshotInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(String nextPageLink) {
                return SnapshotsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SnapshotInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SnapshotInner>>, Page<SnapshotInner>>(){

            public Page<SnapshotInner> call(ServiceResponse<Page<SnapshotInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SnapshotInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SnapshotInner>>, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(ServiceResponse<Page<SnapshotInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SnapshotsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SnapshotInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SnapshotsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SnapshotInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SnapshotInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SnapshotInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SnapshotInner>((Page)response.body()){

            public Page<SnapshotInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SnapshotsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SnapshotInner>> listNextAsync(String nextPageLink, ServiceFuture<List<SnapshotInner>> serviceFuture, ListOperationCallback<SnapshotInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(String nextPageLink) {
                return SnapshotsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SnapshotInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SnapshotInner>>, Page<SnapshotInner>>(){

            public Page<SnapshotInner> call(ServiceResponse<Page<SnapshotInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SnapshotInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SnapshotInner>>, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(ServiceResponse<Page<SnapshotInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SnapshotsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SnapshotInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SnapshotInner>>>>(){

            public Observable<ServiceResponse<Page<SnapshotInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SnapshotsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<SnapshotInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<SnapshotInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SnapshotsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="snapshotName") String var3, @Query(value="api-version") String var4, @Body SnapshotInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="snapshotName") String var3, @Query(value="api-version") String var4, @Body SnapshotInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="snapshotName") String var3, @Query(value="api-version") String var4, @Body SnapshotUpdateInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="snapshotName") String var3, @Query(value="api-version") String var4, @Body SnapshotUpdateInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="snapshotName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="snapshotName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="snapshotName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/snapshots")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots grantAccess"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}/beginGetAccess")
        public Observable<Response<ResponseBody>> grantAccess(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="snapshotName") String var3, @Query(value="api-version") String var4, @Body GrantAccessDataInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots beginGrantAccess"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}/beginGetAccess")
        public Observable<Response<ResponseBody>> beginGrantAccess(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="snapshotName") String var3, @Query(value="api-version") String var4, @Body GrantAccessDataInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots revokeAccess"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}/endGetAccess")
        public Observable<Response<ResponseBody>> revokeAccess(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="snapshotName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots beginRevokeAccess"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}/endGetAccess")
        public Observable<Response<ResponseBody>> beginRevokeAccess(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="snapshotName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Snapshots listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

