/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.ResourceIdentityType;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineExtension;
import com.microsoft.azure.management.compute.VirtualMachineIdentity;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.RoleAssignment;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.tuple.Pair;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

@LangDefinition
class VirtualMachineMsiHelper {
    private static final String CURRENT_RESOURCE_GROUP_SCOPE = "CURRENT_RESOURCE_GROUP";
    private static final int DEFAULT_TOKEN_PORT = 50342;
    private static final String MSI_EXTENSION_PUBLISHER_NAME = "Microsoft.ManagedIdentity";
    private static final String LINUX_MSI_EXTENSION = "ManagedIdentityExtensionForLinux";
    private static final String WINDOWS_MSI_EXTENSION = "ManagedIdentityExtensionForWindows";
    private final GraphRbacManager rbacManager;
    private Integer tokenPort;
    private boolean requireSetup;
    private LinkedHashMap<String, Pair<String, BuiltInRole>> rolesToAssign;
    private LinkedHashMap<String, Pair<String, String>> roleDefinitionsToAssign;

    VirtualMachineMsiHelper(GraphRbacManager rbacManager) {
        this.rbacManager = rbacManager;
        this.rolesToAssign = new LinkedHashMap();
        this.roleDefinitionsToAssign = new LinkedHashMap();
        this.clear();
    }

    VirtualMachineMsiHelper withManagedServiceIdentity(VirtualMachineInner virtualMachineInner) {
        return this.withManagedServiceIdentity(null, virtualMachineInner);
    }

    VirtualMachineMsiHelper withManagedServiceIdentity(Integer port, VirtualMachineInner virtualMachineInner) {
        this.requireSetup = true;
        this.tokenPort = port;
        if (virtualMachineInner.identity() == null) {
            virtualMachineInner.withIdentity(new VirtualMachineIdentity());
        }
        if (virtualMachineInner.identity().type() == null) {
            virtualMachineInner.identity().withType(ResourceIdentityType.SYSTEM_ASSIGNED);
        }
        return this;
    }

    VirtualMachineMsiHelper withRoleBasedAccessToCurrentResourceGroup(BuiltInRole asRole) {
        return this.withRoleBasedAccessTo(CURRENT_RESOURCE_GROUP_SCOPE, asRole);
    }

    VirtualMachineMsiHelper withRoleBasedAccessTo(String scope, BuiltInRole asRole) {
        this.requireSetup = true;
        String key = scope.toLowerCase() + "_" + asRole.toString().toLowerCase();
        this.rolesToAssign.put(key, (Pair<String, BuiltInRole>)Pair.of((Object)scope, (Object)asRole));
        return this;
    }

    VirtualMachineMsiHelper withRoleDefinitionBasedAccessToCurrentResourceGroup(String roleDefinitionId) {
        return this.withRoleDefinitionBasedAccessTo(CURRENT_RESOURCE_GROUP_SCOPE, roleDefinitionId);
    }

    VirtualMachineMsiHelper withRoleDefinitionBasedAccessTo(String scope, String roleDefinitionId) {
        this.requireSetup = true;
        String key = scope.toLowerCase() + "_" + roleDefinitionId.toLowerCase();
        this.roleDefinitionsToAssign.put(key, (Pair<String, String>)Pair.of((Object)scope, (Object)roleDefinitionId));
        return this;
    }

    Observable<MSIResourcesSetupResult> setupVirtualMachineMSIResourcesAsync(final VirtualMachine virtualMachine) {
        if (!this.requireSetup) {
            return Observable.just((Object)new MSIResourcesSetupResult());
        }
        if (!virtualMachine.isManagedServiceIdentityEnabled()) {
            return Observable.just((Object)new MSIResourcesSetupResult());
        }
        OperatingSystemTypes osType = virtualMachine.osType();
        final String extensionTypeName = osType == OperatingSystemTypes.LINUX ? LINUX_MSI_EXTENSION : WINDOWS_MSI_EXTENSION;
        final MSIResourcesSetupResult result = new MSIResourcesSetupResult();
        return this.getMSIExtensionAsync(virtualMachine, extensionTypeName).flatMap((Func1)new Func1<VirtualMachineExtension, Observable<Boolean>>(){

            public Observable<Boolean> call(VirtualMachineExtension extension) {
                return VirtualMachineMsiHelper.this.updateMSIExtensionAsync(virtualMachine, extension, extensionTypeName);
            }
        }).switchIfEmpty(this.installMSIExtensionAsync(virtualMachine, extensionTypeName)).map((Func1)new Func1<Boolean, Void>(){

            public Void call(Boolean extensionInstalledOrUpdated) {
                result.isExtensionInstalledOrUpdated = extensionInstalledOrUpdated;
                return null;
            }
        }).flatMap((Func1)new Func1<Void, Observable<RoleAssignment>>(){

            public Observable<RoleAssignment> call(Void aVoid) {
                return VirtualMachineMsiHelper.this.createRbacRoleAssignmentsAsync(virtualMachine);
            }
        }).collect((Func0)new Func0<MSIResourcesSetupResult>(){

            public MSIResourcesSetupResult call() {
                return result;
            }
        }, (Action2)new Action2<MSIResourcesSetupResult, RoleAssignment>(){

            public void call(MSIResourcesSetupResult result, RoleAssignment roleAssignment) {
                result.roleAssignments.add(roleAssignment);
            }
        }).switchIfEmpty(Observable.just((Object)result)).doAfterTerminate(new Action0(){

            public void call() {
                VirtualMachineMsiHelper.this.clear();
            }
        });
    }

    private Observable<RoleAssignment> createRbacRoleAssignmentsAsync(VirtualMachine virtualMachine) {
        if (this.rolesToAssign.isEmpty() && this.roleDefinitionsToAssign.isEmpty()) {
            return Observable.empty();
        }
        return this.rbacManager.servicePrincipals().getByIdAsync(((VirtualMachineInner)((Object)virtualMachine.inner())).identity().principalId()).zipWith(this.resolveCurrentResourceGroupScopeAsync(virtualMachine), (Func2)new Func2<ServicePrincipal, Boolean, ServicePrincipal>(){

            public ServicePrincipal call(ServicePrincipal servicePrincipal, Boolean resolvedAny) {
                return servicePrincipal;
            }
        }).flatMap((Func1)new Func1<ServicePrincipal, Observable<RoleAssignment>>(){

            public Observable<RoleAssignment> call(final ServicePrincipal servicePrincipal) {
                Observable observable1 = Observable.from(VirtualMachineMsiHelper.this.rolesToAssign.values()).flatMap((Func1)new Func1<Pair<String, BuiltInRole>, Observable<RoleAssignment>>(){

                    public Observable<RoleAssignment> call(Pair<String, BuiltInRole> scopeAndRole) {
                        BuiltInRole role = (BuiltInRole)scopeAndRole.getRight();
                        String scope = (String)scopeAndRole.getLeft();
                        return VirtualMachineMsiHelper.this.createRbacRoleAssignmentIfNotExistsAsync(servicePrincipal, role.toString(), scope, true);
                    }
                });
                Observable observable2 = Observable.from(VirtualMachineMsiHelper.this.roleDefinitionsToAssign.values()).flatMap((Func1)new Func1<Pair<String, String>, Observable<RoleAssignment>>(){

                    public Observable<RoleAssignment> call(Pair<String, String> scopeAndRole) {
                        String roleDefinition = (String)scopeAndRole.getRight();
                        String scope = (String)scopeAndRole.getLeft();
                        return VirtualMachineMsiHelper.this.createRbacRoleAssignmentIfNotExistsAsync(servicePrincipal, roleDefinition, scope, false);
                    }
                });
                return Observable.mergeDelayError((Observable)observable1, (Observable)observable2);
            }
        });
    }

    private Observable<VirtualMachineExtension> getMSIExtensionAsync(VirtualMachine virtualMachine, final String typeName) {
        return virtualMachine.listExtensionsAsync().filter((Func1)new Func1<VirtualMachineExtension, Boolean>(){

            public Boolean call(VirtualMachineExtension extension) {
                return extension.publisherName().equalsIgnoreCase(VirtualMachineMsiHelper.MSI_EXTENSION_PUBLISHER_NAME) && extension.typeName().equalsIgnoreCase(typeName);
            }
        });
    }

    private Observable<Boolean> installMSIExtensionAsync(final VirtualMachine virtualMachine, final String typeName) {
        return Observable.defer((Func0)new Func0<Observable<Boolean>>(){

            public Observable<Boolean> call() {
                Integer tokenPortToUse = VirtualMachineMsiHelper.this.tokenPort != null ? VirtualMachineMsiHelper.this.tokenPort : 50342;
                VirtualMachineExtensionInner extensionParameter = new VirtualMachineExtensionInner();
                extensionParameter.withPublisher(VirtualMachineMsiHelper.MSI_EXTENSION_PUBLISHER_NAME).withVirtualMachineExtensionType(typeName).withTypeHandlerVersion("1.0").withAutoUpgradeMinorVersion(true).withLocation(virtualMachine.regionName());
                HashMap<String, Integer> settings = new HashMap<String, Integer>();
                settings.put("port", tokenPortToUse);
                extensionParameter.withSettings(settings);
                extensionParameter.withProtectedSettings(null);
                return ((ComputeManagementClientImpl)((Object)((ComputeManager)((Object)virtualMachine.manager())).inner())).virtualMachineExtensions().createOrUpdateAsync(virtualMachine.resourceGroupName(), virtualMachine.name(), typeName, extensionParameter).map((Func1)new Func1<VirtualMachineExtensionInner, Boolean>(){

                    public Boolean call(VirtualMachineExtensionInner extension) {
                        return true;
                    }
                });
            }
        });
    }

    private Observable<Boolean> updateMSIExtensionAsync(VirtualMachine virtualMachine, VirtualMachineExtension extension, String typeName) {
        Integer tokenPortToUse;
        Integer currentTokenPort = this.objectToInteger(extension.publicSettings().get("port"));
        if (this.tokenPort != null) {
            tokenPortToUse = this.tokenPort;
        } else if (currentTokenPort == null) {
            tokenPortToUse = 50342;
        } else {
            return Observable.just((Object)false);
        }
        HashMap<String, Integer> settings = new HashMap<String, Integer>();
        settings.put("port", tokenPortToUse);
        ((VirtualMachineExtensionInner)((Object)extension.inner())).withSettings(settings);
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)((Object)virtualMachine.manager())).inner())).virtualMachineExtensions().createOrUpdateAsync(virtualMachine.resourceGroupName(), virtualMachine.name(), typeName, (VirtualMachineExtensionInner)((Object)extension.inner())).map((Func1)new Func1<VirtualMachineExtensionInner, Boolean>(){

            public Boolean call(VirtualMachineExtensionInner extension) {
                return true;
            }
        });
    }

    private Observable<Boolean> resolveCurrentResourceGroupScopeAsync(final VirtualMachine virtualMachine) {
        final ArrayList<String> keysWithCurrentResourceGroupScopeForRoles = new ArrayList<String>();
        for (Map.Entry<String, Pair<String, BuiltInRole>> entrySet : this.rolesToAssign.entrySet()) {
            if (!((String)entrySet.getValue().getLeft()).equals(CURRENT_RESOURCE_GROUP_SCOPE)) continue;
            keysWithCurrentResourceGroupScopeForRoles.add(entrySet.getKey());
        }
        final ArrayList<String> keysWithCurrentResourceGroupScopeForRoleDefinitions = new ArrayList<String>();
        for (Map.Entry<String, Pair<String, String>> entrySet : this.roleDefinitionsToAssign.entrySet()) {
            if (!((String)entrySet.getValue().getLeft()).equals(CURRENT_RESOURCE_GROUP_SCOPE)) continue;
            keysWithCurrentResourceGroupScopeForRoleDefinitions.add(entrySet.getKey());
        }
        if (keysWithCurrentResourceGroupScopeForRoles.isEmpty() && keysWithCurrentResourceGroupScopeForRoleDefinitions.isEmpty()) {
            return Observable.just((Object)false);
        }
        return Observable.fromCallable((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((ResourceGroup)((ComputeManager)((Object)virtualMachine.manager())).resourceManager().resourceGroups().getByName(virtualMachine.resourceGroupName())).id();
            }
        }).subscribeOn(SdkContext.getRxScheduler()).map((Func1)new Func1<String, Boolean>(){

            public Boolean call(String resourceGroupScope) {
                for (String key : keysWithCurrentResourceGroupScopeForRoles) {
                    VirtualMachineMsiHelper.this.rolesToAssign.put(key, Pair.of((Object)resourceGroupScope, (Object)((Pair)VirtualMachineMsiHelper.this.rolesToAssign.get(key)).getRight()));
                }
                for (String key : keysWithCurrentResourceGroupScopeForRoleDefinitions) {
                    VirtualMachineMsiHelper.this.roleDefinitionsToAssign.put(key, Pair.of((Object)resourceGroupScope, (Object)((Pair)VirtualMachineMsiHelper.this.roleDefinitionsToAssign.get(key)).getRight()));
                }
                return true;
            }
        });
    }

    private Observable<RoleAssignment> createRbacRoleAssignmentIfNotExistsAsync(ServicePrincipal servicePrincipal, String roleOrRoleDefinition, String scope, boolean isRole) {
        Func1<Throwable, Observable<? extends Indexable>> onErrorResumeNext = new Func1<Throwable, Observable<? extends Indexable>>(){

            public Observable<? extends Indexable> call(Throwable throwable) {
                CloudException exception;
                if (throwable instanceof CloudException && (exception = (CloudException)throwable).body() != null && exception.body().code() != null && exception.body().code().equalsIgnoreCase("RoleAssignmentExists")) {
                    return Observable.empty();
                }
                return Observable.error((Throwable)throwable);
            }
        };
        String roleAssignmentName = SdkContext.randomUuid();
        if (isRole) {
            return ((RoleAssignment.DefinitionStages.Blank)this.rbacManager.roleAssignments().define(roleAssignmentName)).forServicePrincipal(servicePrincipal).withBuiltInRole(BuiltInRole.fromString((String)roleOrRoleDefinition)).withScope(scope).createAsync().last().onErrorResumeNext((Func1)onErrorResumeNext).map((Func1)new Func1<Indexable, RoleAssignment>(){

                public RoleAssignment call(Indexable indexable) {
                    return (RoleAssignment)indexable;
                }
            });
        }
        return ((RoleAssignment.DefinitionStages.Blank)this.rbacManager.roleAssignments().define(roleAssignmentName)).forServicePrincipal(servicePrincipal).withRoleDefinition(roleOrRoleDefinition).withScope(scope).createAsync().last().onErrorResumeNext((Func1)onErrorResumeNext).map((Func1)new Func1<Indexable, RoleAssignment>(){

            public RoleAssignment call(Indexable indexable) {
                return (RoleAssignment)indexable;
            }
        });
    }

    private Integer objectToInteger(Object obj) {
        Integer result = null;
        if (obj != null) {
            result = obj instanceof Integer ? (Integer)obj : Integer.valueOf((String)obj);
        }
        return result;
    }

    private void clear() {
        this.requireSetup = false;
        this.tokenPort = null;
        this.rolesToAssign.clear();
        this.roleDefinitionsToAssign.clear();
    }

    class MSIResourcesSetupResult {
        boolean isExtensionInstalledOrUpdated = false;
        List<RoleAssignment> roleAssignments = new ArrayList<RoleAssignment>();

        MSIResourcesSetupResult() {
        }
    }
}

