/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.compute.Disallowed;
import com.microsoft.azure.management.compute.DiskSkuTypes;
import com.microsoft.azure.management.compute.Gallery;
import com.microsoft.azure.management.compute.GalleryImageIdentifier;
import com.microsoft.azure.management.compute.GalleryImageVersion;
import com.microsoft.azure.management.compute.ImagePurchasePlan;
import com.microsoft.azure.management.compute.OperatingSystemStateTypes;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.RecommendedMachineConfiguration;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.GalleryImageInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import rx.Observable;

@Fluent
public interface GalleryImage
extends HasInner<GalleryImageInner>,
Indexable,
Refreshable<GalleryImage>,
Updatable<Update>,
HasManager<ComputeManager> {
    public String description();

    public List<DiskSkuTypes> unsupportedDiskTypes();

    public Disallowed disallowed();

    public DateTime endOfLifeDate();

    public String eula();

    public String id();

    public GalleryImageIdentifier identifier();

    public String location();

    public String name();

    public OperatingSystemStateTypes osState();

    public OperatingSystemTypes osType();

    public String privacyStatementUri();

    public String provisioningState();

    public ImagePurchasePlan purchasePlan();

    public RecommendedMachineConfiguration recommendedVirtualMachineConfiguration();

    public String releaseNoteUri();

    public Map<String, String> tags();

    public String type();

    public Observable<GalleryImageVersion> getVersionAsync(String var1);

    public GalleryImageVersion getVersion(String var1);

    public Observable<GalleryImageVersion> listVersionsAsync();

    public PagedList<GalleryImageVersion> listVersions();

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }

        public static interface WithReleaseNoteUri {
            public Update withReleaseNoteUri(String var1);
        }

        public static interface WithRecommendedVMConfiguration {
            public Update withRecommendedMinimumCPUsCountForVirtualMachine(int var1);

            public Update withRecommendedMaximumCPUsCountForVirtualMachine(int var1);

            public Update withRecommendedCPUsCountForVirtualMachine(int var1, int var2);

            public Update withRecommendedMinimumMemoryForVirtualMachine(int var1);

            public Update withRecommendedMaximumMemoryForVirtualMachine(int var1);

            public Update withRecommendedMemoryForVirtualMachine(int var1, int var2);

            public Update withRecommendedConfigurationForVirtualMachine(RecommendedMachineConfiguration var1);
        }

        public static interface WithPrivacyStatementUri {
            public Update withPrivacyStatementUri(String var1);
        }

        public static interface WithOsState {
            public Update withOsState(OperatingSystemStateTypes var1);
        }

        public static interface WithEula {
            public Update withEula(String var1);
        }

        public static interface WithEndOfLifeDate {
            public Update withEndOfLifeDate(DateTime var1);
        }

        public static interface WithDisallowed {
            public Update withUnsupportedDiskType(DiskSkuTypes var1);

            public Update withUnsupportedDiskTypes(List<DiskSkuTypes> var1);

            public Update withoutUnsupportedDiskType(DiskSkuTypes var1);

            public Update withDisallowed(Disallowed var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }
    }

    public static interface Update
    extends Appliable<GalleryImage>,
    UpdateStages.WithDescription,
    UpdateStages.WithDisallowed,
    UpdateStages.WithEndOfLifeDate,
    UpdateStages.WithEula,
    UpdateStages.WithOsState,
    UpdateStages.WithPrivacyStatementUri,
    UpdateStages.WithRecommendedVMConfiguration,
    UpdateStages.WithReleaseNoteUri,
    UpdateStages.WithTags {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<GalleryImage>,
        WithDescription,
        WithDisallowed,
        WithEndOfLifeDate,
        WithEula,
        WithPrivacyStatementUri,
        WithPurchasePlan,
        WithRecommendedVMConfiguration,
        WithReleaseNoteUri,
        WithTags {
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithReleaseNoteUri {
            public WithCreate withReleaseNoteUri(String var1);
        }

        public static interface WithRecommendedVMConfiguration {
            public WithCreate withRecommendedMinimumCPUsCountForVirtualMachine(int var1);

            public WithCreate withRecommendedMaximumCPUsCountForVirtualMachine(int var1);

            public WithCreate withRecommendedCPUsCountForVirtualMachine(int var1, int var2);

            public WithCreate withRecommendedMinimumMemoryForVirtualMachine(int var1);

            public WithCreate withRecommendedMaximumMemoryForVirtualMachine(int var1);

            public WithCreate withRecommendedMemoryForVirtualMachine(int var1, int var2);

            public WithCreate withRecommendedConfigurationForVirtualMachine(RecommendedMachineConfiguration var1);
        }

        public static interface WithPurchasePlan {
            public WithCreate withPurchasePlan(String var1, String var2, String var3);

            public WithCreate withPurchasePlan(ImagePurchasePlan var1);
        }

        public static interface WithPrivacyStatementUri {
            public WithCreate withPrivacyStatementUri(String var1);
        }

        public static interface WithEula {
            public WithCreate withEula(String var1);
        }

        public static interface WithEndOfLifeDate {
            public WithCreate withEndOfLifeDate(DateTime var1);
        }

        public static interface WithDisallowed {
            public WithCreate withUnsupportedDiskType(DiskSkuTypes var1);

            public WithCreate withUnsupportedDiskTypes(List<DiskSkuTypes> var1);

            public WithCreate withDisallowed(Disallowed var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithOsTypeAndState {
            public WithCreate withGeneralizedWindows();

            public WithCreate withGeneralizedLinux();

            public WithCreate withWindows(OperatingSystemStateTypes var1);

            public WithCreate withLinux(OperatingSystemStateTypes var1);
        }

        public static interface WithIdentifier {
            public WithOsTypeAndState withIdentifier(GalleryImageIdentifier var1);

            public WithOsTypeAndState withIdentifier(String var1, String var2, String var3);
        }

        public static interface WithLocation {
            public WithIdentifier withLocation(String var1);

            public WithIdentifier withLocation(Region var1);
        }

        public static interface WithGallery {
            public WithLocation withExistingGallery(String var1, String var2);

            public WithLocation withExistingGallery(Gallery var1);
        }

        public static interface Blank
        extends WithGallery {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGallery,
    DefinitionStages.WithLocation,
    DefinitionStages.WithIdentifier,
    DefinitionStages.WithOsTypeAndState,
    DefinitionStages.WithCreate {
    }
}

