/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.compute.DiskVolumeEncryptionMonitor;
import com.microsoft.azure.management.compute.EncryptionStatus;
import com.microsoft.azure.management.compute.InstanceViewStatus;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.EncryptionExtensionIdentifier;
import com.microsoft.azure.management.compute.implementation.LinuxDiskVolumeLegacyEncryptionMonitorImpl;
import com.microsoft.azure.management.compute.implementation.LinuxDiskVolumeNoAADEncryptionMonitorImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.compute.implementation.WindowsVolumeLegacyEncryptionMonitorImpl;
import com.microsoft.azure.management.compute.implementation.WindowsVolumeNoAADEncryptionMonitorImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

class ProxyEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String vmId;
    private final OperatingSystemTypes osType;
    private final ComputeManager computeManager;
    private DiskVolumeEncryptionMonitor resolvedEncryptionMonitor;

    ProxyEncryptionMonitorImpl(VirtualMachine virtualMachine) {
        this.vmId = virtualMachine.id();
        this.osType = virtualMachine.osType();
        this.computeManager = (ComputeManager)((Object)virtualMachine.manager());
    }

    @Override
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    @Override
    public String progressMessage() {
        return this.resolvedEncryptionMonitor != null ? this.resolvedEncryptionMonitor.progressMessage() : null;
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        return this.resolvedEncryptionMonitor != null ? this.resolvedEncryptionMonitor.osDiskStatus() : EncryptionStatus.NOT_ENCRYPTED;
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        return this.resolvedEncryptionMonitor != null ? this.resolvedEncryptionMonitor.dataDiskStatus() : EncryptionStatus.NOT_ENCRYPTED;
    }

    @Override
    public Map<String, InstanceViewStatus> diskInstanceViewEncryptionStatuses() {
        return this.resolvedEncryptionMonitor != null ? this.resolvedEncryptionMonitor.diskInstanceViewEncryptionStatuses() : new HashMap();
    }

    public DiskVolumeEncryptionMonitor refresh() {
        return (DiskVolumeEncryptionMonitor)this.refreshAsync().toBlocking().last();
    }

    @Override
    public Observable<DiskVolumeEncryptionMonitor> refreshAsync() {
        if (this.resolvedEncryptionMonitor != null) {
            return this.resolvedEncryptionMonitor.refreshAsync();
        }
        final ProxyEncryptionMonitorImpl self = this;
        return this.retrieveVirtualMachineAsync().flatMap((Func1)new Func1<VirtualMachineInner, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VirtualMachineInner virtualMachine) {
                VirtualMachineExtensionInner extension = ProxyEncryptionMonitorImpl.this.encryptionExtension(virtualMachine);
                if (extension != null) {
                    if (EncryptionExtensionIdentifier.isNoAADVersion(ProxyEncryptionMonitorImpl.this.osType(), extension.typeHandlerVersion())) {
                        self.resolvedEncryptionMonitor = ProxyEncryptionMonitorImpl.this.osType() == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), ProxyEncryptionMonitorImpl.this.computeManager) : new WindowsVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), ProxyEncryptionMonitorImpl.this.computeManager);
                    } else {
                        self.resolvedEncryptionMonitor = ProxyEncryptionMonitorImpl.this.osType() == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), ProxyEncryptionMonitorImpl.this.computeManager) : new WindowsVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), ProxyEncryptionMonitorImpl.this.computeManager);
                    }
                    return self.resolvedEncryptionMonitor.refreshAsync();
                }
                return Observable.just((Object)self);
            }
        });
    }

    private Observable<VirtualMachineInner> retrieveVirtualMachineAsync() {
        return ((ComputeManagementClientImpl)((Object)this.computeManager.inner())).virtualMachines().getByResourceGroupAsync(ResourceUtils.groupFromResourceId((String)this.vmId), ResourceUtils.nameFromResourceId((String)this.vmId)).flatMap((Func1)new Func1<VirtualMachineInner, Observable<VirtualMachineInner>>(){

            public Observable<VirtualMachineInner> call(VirtualMachineInner virtualMachine) {
                if (virtualMachine == null) {
                    return Observable.error((Throwable)new Exception(String.format("VM with id '%s' not found.", ProxyEncryptionMonitorImpl.this.vmId)));
                }
                return Observable.just((Object)((Object)virtualMachine));
            }
        });
    }

    private VirtualMachineExtensionInner encryptionExtension(VirtualMachineInner vm) {
        if (vm.resources() != null) {
            for (VirtualMachineExtensionInner extension : vm.resources()) {
                if (!EncryptionExtensionIdentifier.isEncryptionPublisherName(extension.publisher()) || !EncryptionExtensionIdentifier.isEncryptionTypeName(extension.virtualMachineExtensionType(), this.osType())) continue;
                return extension;
            }
        }
        return null;
    }
}

