/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.AccessRights;
import com.microsoft.azure.management.eventhub.AuthorizationRule;
import com.microsoft.azure.management.eventhub.EventHubAuthorizationKey;
import com.microsoft.azure.management.eventhub.KeyType;
import com.microsoft.azure.management.eventhub.implementation.AccessKeysInner;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRuleInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubAuthorizationKeyImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.eventhub.implementation.NestedResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
abstract class AuthorizationRuleBaseImpl<RuleT extends AuthorizationRule<RuleT>, RuleImpl extends IndexableRefreshableWrapperImpl<RuleT, AuthorizationRuleInner>>
extends NestedResourceImpl<RuleT, AuthorizationRuleInner, RuleImpl>
implements AuthorizationRule<RuleT> {
    protected AuthorizationRuleBaseImpl(String name, AuthorizationRuleInner inner, EventHubManager manager) {
        super(name, inner, manager);
    }

    @Override
    public Observable<EventHubAuthorizationKey> getKeysAsync() {
        return this.getKeysInnerAsync().map((Func1)new Func1<AccessKeysInner, EventHubAuthorizationKey>(){

            public EventHubAuthorizationKey call(AccessKeysInner inner) {
                return new EventHubAuthorizationKeyImpl(inner);
            }
        });
    }

    @Override
    public EventHubAuthorizationKey getKeys() {
        return (EventHubAuthorizationKey)this.getKeysAsync().toBlocking().last();
    }

    @Override
    public Observable<EventHubAuthorizationKey> regenerateKeyAsync(KeyType keyType) {
        return this.regenerateKeysInnerAsync(keyType).map((Func1)new Func1<AccessKeysInner, EventHubAuthorizationKey>(){

            public EventHubAuthorizationKey call(AccessKeysInner inner) {
                return new EventHubAuthorizationKeyImpl(inner);
            }
        });
    }

    @Override
    public EventHubAuthorizationKey regenerateKey(KeyType keyType) {
        return (EventHubAuthorizationKey)this.regenerateKeyAsync(keyType).toBlocking().last();
    }

    @Override
    public List<AccessRights> rights() {
        if (((AuthorizationRuleInner)((Object)this.inner())).rights() == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(((AuthorizationRuleInner)((Object)this.inner())).rights());
    }

    public RuleImpl withListenAccess() {
        if (((AuthorizationRuleInner)((Object)this.inner())).rights() == null) {
            ((AuthorizationRuleInner)((Object)this.inner())).withRights(new ArrayList<AccessRights>());
        }
        if (!((AuthorizationRuleInner)((Object)this.inner())).rights().contains((Object)AccessRights.LISTEN)) {
            ((AuthorizationRuleInner)((Object)this.inner())).rights().add(AccessRights.LISTEN);
        }
        return (RuleImpl)this;
    }

    public RuleImpl withSendAccess() {
        if (((AuthorizationRuleInner)((Object)this.inner())).rights() == null) {
            ((AuthorizationRuleInner)((Object)this.inner())).withRights(new ArrayList<AccessRights>());
        }
        if (!((AuthorizationRuleInner)((Object)this.inner())).rights().contains((Object)AccessRights.SEND)) {
            ((AuthorizationRuleInner)((Object)this.inner())).rights().add(AccessRights.SEND);
        }
        return (RuleImpl)this;
    }

    public RuleImpl withSendAndListenAccess() {
        this.withListenAccess();
        this.withSendAccess();
        return (RuleImpl)this;
    }

    public RuleImpl withManageAccess() {
        this.withListenAccess();
        this.withSendAccess();
        if (!((AuthorizationRuleInner)((Object)this.inner())).rights().contains((Object)AccessRights.MANAGE)) {
            ((AuthorizationRuleInner)((Object)this.inner())).rights().add(AccessRights.MANAGE);
        }
        return (RuleImpl)this;
    }

    protected abstract Observable<AccessKeysInner> getKeysInnerAsync();

    protected abstract Observable<AccessKeysInner> regenerateKeysInnerAsync(KeyType var1);

    protected abstract Observable<AuthorizationRuleInner> getInnerAsync();

    public abstract Observable<RuleT> createResourceAsync();
}

