/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.eventhub.ErrorResponseException;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.MessagingRegionsInner;
import com.microsoft.azure.management.eventhub.implementation.PageImpl;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RegionsInner {
    private RegionsService service;
    private EventHubManagementClientImpl client;

    public RegionsInner(Retrofit retrofit, EventHubManagementClientImpl client) {
        this.service = (RegionsService)retrofit.create(RegionsService.class);
        this.client = client;
    }

    public PagedList<MessagingRegionsInner> listBySku(String sku) {
        ServiceResponse response = (ServiceResponse)this.listBySkuSinglePageAsync(sku).toBlocking().single();
        return new PagedList<MessagingRegionsInner>((Page)response.body()){

            public Page<MessagingRegionsInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RegionsInner.this.listBySkuNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<MessagingRegionsInner>> listBySkuAsync(String sku, ListOperationCallback<MessagingRegionsInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBySkuSinglePageAsync(sku), (Func1)new Func1<String, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>(){

            public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(String nextPageLink) {
                return RegionsInner.this.listBySkuNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<MessagingRegionsInner>> listBySkuAsync(String sku) {
        return this.listBySkuWithServiceResponseAsync(sku).map((Func1)new Func1<ServiceResponse<Page<MessagingRegionsInner>>, Page<MessagingRegionsInner>>(){

            public Page<MessagingRegionsInner> call(ServiceResponse<Page<MessagingRegionsInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<MessagingRegionsInner>>> listBySkuWithServiceResponseAsync(String sku) {
        return this.listBySkuSinglePageAsync(sku).concatMap((Func1)new Func1<ServiceResponse<Page<MessagingRegionsInner>>, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>(){

            public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(ServiceResponse<Page<MessagingRegionsInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RegionsInner.this.listBySkuNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<MessagingRegionsInner>>> listBySkuSinglePageAsync(String sku) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (sku == null) {
            throw new IllegalArgumentException("Parameter sku is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listBySku(this.client.subscriptionId(), sku, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>(){

            public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RegionsInner.this.listBySkuDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MessagingRegionsInner>> listBySkuDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MessagingRegionsInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<MessagingRegionsInner> listBySkuNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listBySkuNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<MessagingRegionsInner>((Page)response.body()){

            public Page<MessagingRegionsInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RegionsInner.this.listBySkuNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<MessagingRegionsInner>> listBySkuNextAsync(String nextPageLink, ServiceFuture<List<MessagingRegionsInner>> serviceFuture, ListOperationCallback<MessagingRegionsInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBySkuNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>(){

            public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(String nextPageLink) {
                return RegionsInner.this.listBySkuNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<MessagingRegionsInner>> listBySkuNextAsync(String nextPageLink) {
        return this.listBySkuNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<MessagingRegionsInner>>, Page<MessagingRegionsInner>>(){

            public Page<MessagingRegionsInner> call(ServiceResponse<Page<MessagingRegionsInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<MessagingRegionsInner>>> listBySkuNextWithServiceResponseAsync(String nextPageLink) {
        return this.listBySkuNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<MessagingRegionsInner>>, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>(){

            public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(ServiceResponse<Page<MessagingRegionsInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RegionsInner.this.listBySkuNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<MessagingRegionsInner>>> listBySkuNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listBySkuNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>(){

            public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RegionsInner.this.listBySkuNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MessagingRegionsInner>> listBySkuNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MessagingRegionsInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface RegionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Regions listBySku"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.EventHub/sku/{sku}/regions")
        public Observable<Response<ResponseBody>> listBySku(@Path(value="subscriptionId") String var1, @Path(value="sku") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Regions listBySkuNext"})
        @GET
        public Observable<Response<ResponseBody>> listBySkuNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

