/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The password profile associated with a user.
 */
public class PasswordProfile {
    /**
     * Password.
     */
    @JsonProperty(value = "password", required = true)
    private String password;

    /**
     * Whether to force a password change on next login.
     */
    @JsonProperty(value = "forceChangePasswordNextLogin")
    private Boolean forceChangePasswordNextLogin;

    /**
     * Get the password value.
     *
     * @return the password value
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password value.
     *
     * @param password the password value to set
     * @return the PasswordProfile object itself.
     */
    public PasswordProfile withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the forceChangePasswordNextLogin value.
     *
     * @return the forceChangePasswordNextLogin value
     */
    public Boolean forceChangePasswordNextLogin() {
        return this.forceChangePasswordNextLogin;
    }

    /**
     * Set the forceChangePasswordNextLogin value.
     *
     * @param forceChangePasswordNextLogin the forceChangePasswordNextLogin value to set
     * @return the PasswordProfile object itself.
     */
    public PasswordProfile withForceChangePasswordNextLogin(Boolean forceChangePasswordNextLogin) {
        this.forceChangePasswordNextLogin = forceChangePasswordNextLogin;
        return this;
    }

}
