/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.UserGetMemberGroupsParameters;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl1;
import com.microsoft.azure.management.graphrbac.implementation.UserCreateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.UserInner;
import com.microsoft.azure.management.graphrbac.implementation.UserUpdateParametersInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class UsersInner {
    private UsersService service;
    private GraphRbacManagementClientImpl client;

    public UsersInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = (UsersService)retrofit.create(UsersService.class);
        this.client = client;
    }

    public UserInner create(UserCreateParametersInner parameters) {
        return (UserInner)((ServiceResponse)this.createWithServiceResponseAsync(parameters).toBlocking().single()).body();
    }

    public ServiceFuture<UserInner> createAsync(UserCreateParametersInner parameters, ServiceCallback<UserInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(parameters), serviceCallback);
    }

    public Observable<UserInner> createAsync(UserCreateParametersInner parameters) {
        return this.createWithServiceResponseAsync(parameters).map((Func1)new Func1<ServiceResponse<UserInner>, UserInner>(){

            public UserInner call(ServiceResponse<UserInner> response) {
                return (UserInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<UserInner>> createWithServiceResponseAsync(UserCreateParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.create(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserInner>>>(){

            public Observable<ServiceResponse<UserInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = UsersInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<UserInner> createDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<UserInner>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public PagedList<UserInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<UserInner>((Page)response.body()){

            public Page<UserInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)UsersInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<UserInner>> listAsync(ListOperationCallback<UserInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<UserInner>>>>(){

            public Observable<ServiceResponse<Page<UserInner>>> call(String nextLink) {
                return UsersInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<UserInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<UserInner>>, Page<UserInner>>(){

            public Page<UserInner> call(ServiceResponse<Page<UserInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<UserInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<UserInner>>, Observable<ServiceResponse<Page<UserInner>>>>(){

            public Observable<ServiceResponse<Page<UserInner>>> call(ServiceResponse<Page<UserInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(UsersInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<UserInner>>> listSinglePageAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UserInner>>>>(){

            public Observable<ServiceResponse<Page<UserInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = UsersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<UserInner> list(String filter) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<UserInner>((Page)response.body()){

            public Page<UserInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)UsersInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<UserInner>> listAsync(String filter, ListOperationCallback<UserInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<UserInner>>>>(){

            public Observable<ServiceResponse<Page<UserInner>>> call(String nextLink) {
                return UsersInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<UserInner>> listAsync(String filter) {
        return this.listWithServiceResponseAsync(filter).map((Func1)new Func1<ServiceResponse<Page<UserInner>>, Page<UserInner>>(){

            public Page<UserInner> call(ServiceResponse<Page<UserInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<UserInner>>> listWithServiceResponseAsync(String filter) {
        return this.listSinglePageAsync(filter).concatMap((Func1)new Func1<ServiceResponse<Page<UserInner>>, Observable<ServiceResponse<Page<UserInner>>>>(){

            public Observable<ServiceResponse<Page<UserInner>>> call(ServiceResponse<Page<UserInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(UsersInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<UserInner>>> listSinglePageAsync(String filter) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UserInner>>>>(){

            public Observable<ServiceResponse<Page<UserInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = UsersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UserInner>> listDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<UserInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public UserInner get(String upnOrObjectId) {
        return (UserInner)((ServiceResponse)this.getWithServiceResponseAsync(upnOrObjectId).toBlocking().single()).body();
    }

    public ServiceFuture<UserInner> getAsync(String upnOrObjectId, ServiceCallback<UserInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(upnOrObjectId), serviceCallback);
    }

    public Observable<UserInner> getAsync(String upnOrObjectId) {
        return this.getWithServiceResponseAsync(upnOrObjectId).map((Func1)new Func1<ServiceResponse<UserInner>, UserInner>(){

            public UserInner call(ServiceResponse<UserInner> response) {
                return (UserInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<UserInner>> getWithServiceResponseAsync(String upnOrObjectId) {
        if (upnOrObjectId == null) {
            throw new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(upnOrObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserInner>>>(){

            public Observable<ServiceResponse<UserInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = UsersInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<UserInner> getDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<UserInner>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void update(String upnOrObjectId, UserUpdateParametersInner parameters) {
        ((ServiceResponse)this.updateWithServiceResponseAsync(upnOrObjectId, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> updateAsync(String upnOrObjectId, UserUpdateParametersInner parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(upnOrObjectId, parameters), serviceCallback);
    }

    public Observable<Void> updateAsync(String upnOrObjectId, UserUpdateParametersInner parameters) {
        return this.updateWithServiceResponseAsync(upnOrObjectId, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> updateWithServiceResponseAsync(String upnOrObjectId, UserUpdateParametersInner parameters) {
        if (upnOrObjectId == null) {
            throw new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.update(upnOrObjectId, this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = UsersInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> updateDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void delete(String upnOrObjectId) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(upnOrObjectId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String upnOrObjectId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(upnOrObjectId), serviceCallback);
    }

    public Observable<Void> deleteAsync(String upnOrObjectId) {
        return this.deleteWithServiceResponseAsync(upnOrObjectId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String upnOrObjectId) {
        if (upnOrObjectId == null) {
            throw new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(upnOrObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = UsersInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public List<String> getMemberGroups(String objectId, boolean securityEnabledOnly) {
        return (List)((ServiceResponse)this.getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly).toBlocking().single()).body();
    }

    public ServiceFuture<List<String>> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly, ServiceCallback<List<String>> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly), serviceCallback);
    }

    public Observable<List<String>> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly) {
        return this.getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly).map((Func1)new Func1<ServiceResponse<List<String>>, List<String>>(){

            public List<String> call(ServiceResponse<List<String>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<String>>> getMemberGroupsWithServiceResponseAsync(String objectId, boolean securityEnabledOnly) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        UserGetMemberGroupsParameters parameters = new UserGetMemberGroupsParameters();
        parameters.withSecurityEnabledOnly(securityEnabledOnly);
        return this.service.getMemberGroups(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<String>>>>(){

            public Observable<ServiceResponse<List<String>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = UsersInner.this.getMemberGroupsDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<String>> getMemberGroupsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<String>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public PagedList<UserInner> listNext(String nextLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<UserInner>((Page)response.body()){

            public Page<UserInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)UsersInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<UserInner>> listNextAsync(String nextLink, ServiceFuture<List<UserInner>> serviceFuture, ListOperationCallback<UserInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<UserInner>>>>(){

            public Observable<ServiceResponse<Page<UserInner>>> call(String nextLink) {
                return UsersInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<UserInner>> listNextAsync(String nextLink) {
        return this.listNextWithServiceResponseAsync(nextLink).map((Func1)new Func1<ServiceResponse<Page<UserInner>>, Page<UserInner>>(){

            public Page<UserInner> call(ServiceResponse<Page<UserInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<UserInner>>> listNextWithServiceResponseAsync(String nextLink) {
        return this.listNextSinglePageAsync(nextLink).concatMap((Func1)new Func1<ServiceResponse<Page<UserInner>>, Observable<ServiceResponse<Page<UserInner>>>>(){

            public Observable<ServiceResponse<Page<UserInner>>> call(ServiceResponse<Page<UserInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(UsersInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<UserInner>>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String nextUrl = String.format("%s/%s", this.client.tenantID(), nextLink);
        return this.service.listNext(nextUrl, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UserInner>>>>(){

            public Observable<ServiceResponse<Page<UserInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = UsersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UserInner>> listNextDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<UserInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    static interface UsersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users create"})
        @POST(value="{tenantID}/users")
        public Observable<Response<ResponseBody>> create(@Path(value="tenantID") String var1, @Body UserCreateParametersInner var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users list"})
        @GET(value="{tenantID}/users")
        public Observable<Response<ResponseBody>> list(@Path(value="tenantID") String var1, @Query(value="$filter") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users get"})
        @GET(value="{tenantID}/users/{upnOrObjectId}")
        public Observable<Response<ResponseBody>> get(@Path(value="upnOrObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users update"})
        @PATCH(value="{tenantID}/users/{upnOrObjectId}")
        public Observable<Response<ResponseBody>> update(@Path(value="upnOrObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Body UserUpdateParametersInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users delete"})
        @HTTP(path="{tenantID}/users/{upnOrObjectId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="upnOrObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users getMemberGroups"})
        @POST(value="{tenantID}/users/{objectId}/getMemberGroups")
        public Observable<Response<ResponseBody>> getMemberGroups(@Path(value="objectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body UserGetMemberGroupsParameters var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

