/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.DeploymentOperation;
import com.microsoft.azure.management.resources.models.DeploymentOperationProperties;
import com.microsoft.azure.management.resources.models.DeploymentOperationsGetResult;
import com.microsoft.azure.management.resources.models.DeploymentOperationsListParameters;
import com.microsoft.azure.management.resources.models.DeploymentOperationsListResult;
import com.microsoft.azure.management.resources.models.TargetResource;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

/**
* Operations for managing deployment operations.
*/
public class DeploymentOperationOperationsImpl implements ServiceOperations<ResourceManagementClientImpl>, DeploymentOperationOperations {
    /**
    * Initializes a new instance of the DeploymentOperationOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    DeploymentOperationOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }
    
    private ResourceManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.resources.ResourceManagementClientImpl.
    * @return The Client value.
    */
    public ResourceManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Get a list of deployments operations.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param operationId Required. Operation Id.
    * @return Deployment operation.
    */
    @Override
    public Future<DeploymentOperationsGetResult> getAsync(final String resourceGroupName, final String deploymentName, final String operationId) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentOperationsGetResult>() { 
            @Override
            public DeploymentOperationsGetResult call() throws Exception {
                return get(resourceGroupName, deploymentName, operationId);
            }
         });
    }
    
    /**
    * Get a list of deployments operations.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param operationId Required. Operation Id.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Deployment operation.
    */
    @Override
    public DeploymentOperationsGetResult get(String resourceGroupName, String deploymentName, String operationId) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (operationId == null) {
            throw new NullPointerException("operationId");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("operationId", operationId);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/operations/";
        url = url + URLEncoder.encode(operationId, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentOperationsGetResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentOperationsGetResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    DeploymentOperation operationInstance = new DeploymentOperation();
                    result.setOperation(operationInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        operationInstance.setId(idInstance);
                    }
                    
                    JsonNode operationIdValue = responseDoc.get("operationId");
                    if (operationIdValue != null && operationIdValue instanceof NullNode == false) {
                        String operationIdInstance;
                        operationIdInstance = operationIdValue.getTextValue();
                        operationInstance.setOperationId(operationIdInstance);
                    }
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        DeploymentOperationProperties propertiesInstance = new DeploymentOperationProperties();
                        operationInstance.setProperties(propertiesInstance);
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode timestampValue = propertiesValue.get("timestamp");
                        if (timestampValue != null && timestampValue instanceof NullNode == false) {
                            Calendar timestampInstance;
                            timestampInstance = DatatypeConverter.parseDateTime(timestampValue.getTextValue());
                            propertiesInstance.setTimestamp(timestampInstance);
                        }
                        
                        JsonNode statusCodeValue = propertiesValue.get("statusCode");
                        if (statusCodeValue != null && statusCodeValue instanceof NullNode == false) {
                            String statusCodeInstance;
                            statusCodeInstance = statusCodeValue.getTextValue();
                            propertiesInstance.setStatusCode(statusCodeInstance);
                        }
                        
                        JsonNode statusMessageValue = propertiesValue.get("statusMessage");
                        if (statusMessageValue != null && statusMessageValue instanceof NullNode == false) {
                            String statusMessageInstance;
                            statusMessageInstance = statusMessageValue.getTextValue();
                            propertiesInstance.setStatusMessage(statusMessageInstance);
                        }
                        
                        JsonNode targetResourceValue = propertiesValue.get("targetResource");
                        if (targetResourceValue != null && targetResourceValue instanceof NullNode == false) {
                            TargetResource targetResourceInstance = new TargetResource();
                            propertiesInstance.setTargetResource(targetResourceInstance);
                            
                            JsonNode idValue2 = targetResourceValue.get("id");
                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                String idInstance2;
                                idInstance2 = idValue2.getTextValue();
                                targetResourceInstance.setId(idInstance2);
                            }
                            
                            JsonNode resourceNameValue = targetResourceValue.get("resourceName");
                            if (resourceNameValue != null && resourceNameValue instanceof NullNode == false) {
                                String resourceNameInstance;
                                resourceNameInstance = resourceNameValue.getTextValue();
                                targetResourceInstance.setResourceName(resourceNameInstance);
                            }
                            
                            JsonNode resourceTypeValue = targetResourceValue.get("resourceType");
                            if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                String resourceTypeInstance;
                                resourceTypeInstance = resourceTypeValue.getTextValue();
                                targetResourceInstance.setResourceType(resourceTypeInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a list of deployments operations.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Optional. Query parameters.
    * @return List of deployment operations.
    */
    @Override
    public Future<DeploymentOperationsListResult> listAsync(final String resourceGroupName, final String deploymentName, final DeploymentOperationsListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentOperationsListResult>() { 
            @Override
            public DeploymentOperationsListResult call() throws Exception {
                return list(resourceGroupName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * Gets a list of deployments operations.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Optional. Query parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of deployment operations.
    */
    @Override
    public DeploymentOperationsListResult list(String resourceGroupName, String deploymentName, DeploymentOperationsListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/operations";
        ArrayList<String> queryParameters = new ArrayList<String>();
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentOperationsListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentOperationsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            DeploymentOperation deploymentOperationInstance = new DeploymentOperation();
                            result.getOperations().add(deploymentOperationInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                deploymentOperationInstance.setId(idInstance);
                            }
                            
                            JsonNode operationIdValue = valueValue.get("operationId");
                            if (operationIdValue != null && operationIdValue instanceof NullNode == false) {
                                String operationIdInstance;
                                operationIdInstance = operationIdValue.getTextValue();
                                deploymentOperationInstance.setOperationId(operationIdInstance);
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                DeploymentOperationProperties propertiesInstance = new DeploymentOperationProperties();
                                deploymentOperationInstance.setProperties(propertiesInstance);
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    propertiesInstance.setProvisioningState(provisioningStateInstance);
                                }
                                
                                JsonNode timestampValue = propertiesValue.get("timestamp");
                                if (timestampValue != null && timestampValue instanceof NullNode == false) {
                                    Calendar timestampInstance;
                                    timestampInstance = DatatypeConverter.parseDateTime(timestampValue.getTextValue());
                                    propertiesInstance.setTimestamp(timestampInstance);
                                }
                                
                                JsonNode statusCodeValue = propertiesValue.get("statusCode");
                                if (statusCodeValue != null && statusCodeValue instanceof NullNode == false) {
                                    String statusCodeInstance;
                                    statusCodeInstance = statusCodeValue.getTextValue();
                                    propertiesInstance.setStatusCode(statusCodeInstance);
                                }
                                
                                JsonNode statusMessageValue = propertiesValue.get("statusMessage");
                                if (statusMessageValue != null && statusMessageValue instanceof NullNode == false) {
                                    String statusMessageInstance;
                                    statusMessageInstance = statusMessageValue.getTextValue();
                                    propertiesInstance.setStatusMessage(statusMessageInstance);
                                }
                                
                                JsonNode targetResourceValue = propertiesValue.get("targetResource");
                                if (targetResourceValue != null && targetResourceValue instanceof NullNode == false) {
                                    TargetResource targetResourceInstance = new TargetResource();
                                    propertiesInstance.setTargetResource(targetResourceInstance);
                                    
                                    JsonNode idValue2 = targetResourceValue.get("id");
                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                        String idInstance2;
                                        idInstance2 = idValue2.getTextValue();
                                        targetResourceInstance.setId(idInstance2);
                                    }
                                    
                                    JsonNode resourceNameValue = targetResourceValue.get("resourceName");
                                    if (resourceNameValue != null && resourceNameValue instanceof NullNode == false) {
                                        String resourceNameInstance;
                                        resourceNameInstance = resourceNameValue.getTextValue();
                                        targetResourceInstance.setResourceName(resourceNameInstance);
                                    }
                                    
                                    JsonNode resourceTypeValue = targetResourceValue.get("resourceType");
                                    if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                        String resourceTypeInstance;
                                        resourceTypeInstance = resourceTypeValue.getTextValue();
                                        targetResourceInstance.setResourceType(resourceTypeInstance);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a next list of deployments operations.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return List of deployment operations.
    */
    @Override
    public Future<DeploymentOperationsListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentOperationsListResult>() { 
            @Override
            public DeploymentOperationsListResult call() throws Exception {
                return listNext(nextLink);
            }
         });
    }
    
    /**
    * Gets a next list of deployments operations.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of deployment operations.
    */
    @Override
    public DeploymentOperationsListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter(invocationId, this, "listNextAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentOperationsListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentOperationsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            DeploymentOperation deploymentOperationInstance = new DeploymentOperation();
                            result.getOperations().add(deploymentOperationInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                deploymentOperationInstance.setId(idInstance);
                            }
                            
                            JsonNode operationIdValue = valueValue.get("operationId");
                            if (operationIdValue != null && operationIdValue instanceof NullNode == false) {
                                String operationIdInstance;
                                operationIdInstance = operationIdValue.getTextValue();
                                deploymentOperationInstance.setOperationId(operationIdInstance);
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                DeploymentOperationProperties propertiesInstance = new DeploymentOperationProperties();
                                deploymentOperationInstance.setProperties(propertiesInstance);
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    propertiesInstance.setProvisioningState(provisioningStateInstance);
                                }
                                
                                JsonNode timestampValue = propertiesValue.get("timestamp");
                                if (timestampValue != null && timestampValue instanceof NullNode == false) {
                                    Calendar timestampInstance;
                                    timestampInstance = DatatypeConverter.parseDateTime(timestampValue.getTextValue());
                                    propertiesInstance.setTimestamp(timestampInstance);
                                }
                                
                                JsonNode statusCodeValue = propertiesValue.get("statusCode");
                                if (statusCodeValue != null && statusCodeValue instanceof NullNode == false) {
                                    String statusCodeInstance;
                                    statusCodeInstance = statusCodeValue.getTextValue();
                                    propertiesInstance.setStatusCode(statusCodeInstance);
                                }
                                
                                JsonNode statusMessageValue = propertiesValue.get("statusMessage");
                                if (statusMessageValue != null && statusMessageValue instanceof NullNode == false) {
                                    String statusMessageInstance;
                                    statusMessageInstance = statusMessageValue.getTextValue();
                                    propertiesInstance.setStatusMessage(statusMessageInstance);
                                }
                                
                                JsonNode targetResourceValue = propertiesValue.get("targetResource");
                                if (targetResourceValue != null && targetResourceValue instanceof NullNode == false) {
                                    TargetResource targetResourceInstance = new TargetResource();
                                    propertiesInstance.setTargetResource(targetResourceInstance);
                                    
                                    JsonNode idValue2 = targetResourceValue.get("id");
                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                        String idInstance2;
                                        idInstance2 = idValue2.getTextValue();
                                        targetResourceInstance.setId(idInstance2);
                                    }
                                    
                                    JsonNode resourceNameValue = targetResourceValue.get("resourceName");
                                    if (resourceNameValue != null && resourceNameValue instanceof NullNode == false) {
                                        String resourceNameInstance;
                                        resourceNameInstance = resourceNameValue.getTextValue();
                                        targetResourceInstance.setResourceName(resourceNameInstance);
                                    }
                                    
                                    JsonNode resourceTypeValue = targetResourceValue.get("resourceType");
                                    if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                        String resourceTypeInstance;
                                        resourceTypeInstance = resourceTypeValue.getTextValue();
                                        targetResourceInstance.setResourceType(resourceTypeInstance);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
