/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.Deployment;
import com.microsoft.azure.management.resources.models.DeploymentExistsResult;
import com.microsoft.azure.management.resources.models.DeploymentGetResult;
import com.microsoft.azure.management.resources.models.DeploymentListParameters;
import com.microsoft.azure.management.resources.models.DeploymentListResult;
import com.microsoft.azure.management.resources.models.DeploymentOperationsCreateResult;
import com.microsoft.azure.management.resources.models.DeploymentValidateResponse;
import com.microsoft.azure.management.resources.models.LongRunningOperationResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Operations for managing deployments.
*/
public interface DeploymentOperations {
    /**
    * Begin deleting deployment.To determine whether the operation has finished
    * processing the request, call GetLongRunningOperationStatus.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment to be deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response for long running operations.
    */
    LongRunningOperationResponse beginDeleting(String resourceGroupName, String deploymentName) throws IOException, ServiceException;
    
    /**
    * Begin deleting deployment.To determine whether the operation has finished
    * processing the request, call GetLongRunningOperationStatus.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment to be deleted.
    * @return A standard service response for long running operations.
    */
    Future<LongRunningOperationResponse> beginDeletingAsync(String resourceGroupName, String deploymentName);
    
    /**
    * Cancel a currently running template deployment.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse cancel(String resourceGroupName, String deploymentName) throws IOException, ServiceException;
    
    /**
    * Cancel a currently running template deployment.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> cancelAsync(String resourceGroupName, String deploymentName);
    
    /**
    * Checks whether deployment exists.
    *
    * @param resourceGroupName Required. The name of the resource group to
    * check. The name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Deployment information.
    */
    DeploymentExistsResult checkExistence(String resourceGroupName, String deploymentName) throws IOException, ServiceException;
    
    /**
    * Checks whether deployment exists.
    *
    * @param resourceGroupName Required. The name of the resource group to
    * check. The name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @return Deployment information.
    */
    Future<DeploymentExistsResult> checkExistenceAsync(String resourceGroupName, String deploymentName);
    
    /**
    * Create a named template deployment using a template.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Additional parameters supplied to the
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Template deployment operation create result.
    */
    DeploymentOperationsCreateResult createOrUpdate(String resourceGroupName, String deploymentName, Deployment parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Create a named template deployment using a template.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Additional parameters supplied to the
    * operation.
    * @return Template deployment operation create result.
    */
    Future<DeploymentOperationsCreateResult> createOrUpdateAsync(String resourceGroupName, String deploymentName, Deployment parameters);
    
    /**
    * Delete deployment and all of its resources.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment to be deleted.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String deploymentName) throws InterruptedException, ExecutionException, IOException, ServiceException;
    
    /**
    * Delete deployment and all of its resources.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment to be deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String deploymentName);
    
    /**
    * Get a deployment.
    *
    * @param resourceGroupName Required. The name of the resource group to get.
    * The name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Template deployment information.
    */
    DeploymentGetResult get(String resourceGroupName, String deploymentName) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get a deployment.
    *
    * @param resourceGroupName Required. The name of the resource group to get.
    * The name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @return Template deployment information.
    */
    Future<DeploymentGetResult> getAsync(String resourceGroupName, String deploymentName);
    
    /**
    * Get a list of deployments.
    *
    * @param resourceGroupName Required. The name of the resource group to
    * filter by. The name is case insensitive.
    * @param parameters Optional. Query parameters. If null is passed returns
    * all deployments.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of deployments.
    */
    DeploymentListResult list(String resourceGroupName, DeploymentListParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get a list of deployments.
    *
    * @param resourceGroupName Required. The name of the resource group to
    * filter by. The name is case insensitive.
    * @param parameters Optional. Query parameters. If null is passed returns
    * all deployments.
    * @return List of deployments.
    */
    Future<DeploymentListResult> listAsync(String resourceGroupName, DeploymentListParameters parameters);
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of deployments.
    */
    DeploymentListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return List of deployments.
    */
    Future<DeploymentListResult> listNextAsync(String nextLink);
    
    /**
    * Validate a deployment template.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Deployment to validate.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Information from validate template deployment response.
    */
    DeploymentValidateResponse validate(String resourceGroupName, String deploymentName, Deployment parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Validate a deployment template.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Deployment to validate.
    * @return Information from validate template deployment response.
    */
    Future<DeploymentValidateResponse> validateAsync(String resourceGroupName, String deploymentName, Deployment parameters);
}
