/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.BasicDependency;
import com.microsoft.azure.management.resources.models.Dependency;
import com.microsoft.azure.management.resources.models.Deployment;
import com.microsoft.azure.management.resources.models.DeploymentExistsResult;
import com.microsoft.azure.management.resources.models.DeploymentExtended;
import com.microsoft.azure.management.resources.models.DeploymentGetResult;
import com.microsoft.azure.management.resources.models.DeploymentListParameters;
import com.microsoft.azure.management.resources.models.DeploymentListResult;
import com.microsoft.azure.management.resources.models.DeploymentMode;
import com.microsoft.azure.management.resources.models.DeploymentOperationsCreateResult;
import com.microsoft.azure.management.resources.models.DeploymentPropertiesExtended;
import com.microsoft.azure.management.resources.models.DeploymentValidateResponse;
import com.microsoft.azure.management.resources.models.LongRunningOperationResponse;
import com.microsoft.azure.management.resources.models.ParametersLink;
import com.microsoft.azure.management.resources.models.Provider;
import com.microsoft.azure.management.resources.models.ProviderResourceType;
import com.microsoft.azure.management.resources.models.ResourceManagementError;
import com.microsoft.azure.management.resources.models.ResourceManagementErrorWithDetails;
import com.microsoft.azure.management.resources.models.TemplateLink;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

/**
* Operations for managing deployments.
*/
public class DeploymentOperationsImpl implements ServiceOperations<ResourceManagementClientImpl>, DeploymentOperations {
    /**
    * Initializes a new instance of the DeploymentOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    DeploymentOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }
    
    private ResourceManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.resources.ResourceManagementClientImpl.
    * @return The Client value.
    */
    public ResourceManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Begin deleting deployment.To determine whether the operation has finished
    * processing the request, call GetLongRunningOperationStatus.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment to be deleted.
    * @return A standard service response for long running operations.
    */
    @Override
    public Future<LongRunningOperationResponse> beginDeletingAsync(final String resourceGroupName, final String deploymentName) {
        return this.getClient().getExecutorService().submit(new Callable<LongRunningOperationResponse>() { 
            @Override
            public LongRunningOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, deploymentName);
            }
         });
    }
    
    /**
    * Begin deleting deployment.To determine whether the operation has finished
    * processing the request, call GetLongRunningOperationStatus.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment to be deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response for long running operations.
    */
    @Override
    public LongRunningOperationResponse beginDeleting(String resourceGroupName, String deploymentName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            LongRunningOperationResponse result = null;
            // Deserialize Response
            result = new LongRunningOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Location").length > 0) {
                result.setOperationStatusLink(httpResponse.getFirstHeader("Location").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_CONFLICT) {
                result.setStatus(OperationStatus.Failed);
            }
            if (statusCode == HttpStatus.SC_ACCEPTED) {
                result.setStatus(OperationStatus.InProgress);
            }
            if (statusCode == HttpStatus.SC_NO_CONTENT) {
                result.setStatus(OperationStatus.Succeeded);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Cancel a currently running template deployment.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> cancelAsync(final String resourceGroupName, final String deploymentName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return cancel(resourceGroupName, deploymentName);
            }
         });
    }
    
    /**
    * Cancel a currently running template deployment.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse cancel(String resourceGroupName, String deploymentName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            CloudTracing.enter(invocationId, this, "cancelAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/cancel";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Checks whether deployment exists.
    *
    * @param resourceGroupName Required. The name of the resource group to
    * check. The name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @return Deployment information.
    */
    @Override
    public Future<DeploymentExistsResult> checkExistenceAsync(final String resourceGroupName, final String deploymentName) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentExistsResult>() { 
            @Override
            public DeploymentExistsResult call() throws Exception {
                return checkExistence(resourceGroupName, deploymentName);
            }
         });
    }
    
    /**
    * Checks whether deployment exists.
    *
    * @param resourceGroupName Required. The name of the resource group to
    * check. The name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Deployment information.
    */
    @Override
    public DeploymentExistsResult checkExistence(String resourceGroupName, String deploymentName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            CloudTracing.enter(invocationId, this, "checkExistenceAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpHead httpRequest = new HttpHead(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_NO_CONTENT && statusCode != HttpStatus.SC_NOT_FOUND) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentExistsResult result = null;
            // Deserialize Response
            result = new DeploymentExistsResult();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_NO_CONTENT) {
                result.setExists(true);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Create a named template deployment using a template.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Additional parameters supplied to the
    * operation.
    * @return Template deployment operation create result.
    */
    @Override
    public Future<DeploymentOperationsCreateResult> createOrUpdateAsync(final String resourceGroupName, final String deploymentName, final Deployment parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentOperationsCreateResult>() { 
            @Override
            public DeploymentOperationsCreateResult call() throws Exception {
                return createOrUpdate(resourceGroupName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * Create a named template deployment using a template.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Additional parameters supplied to the
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Template deployment operation create result.
    */
    @Override
    public DeploymentOperationsCreateResult createOrUpdate(String resourceGroupName, String deploymentName, Deployment parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() != null) {
            if (parameters.getProperties().getParametersLink() != null) {
                if (parameters.getProperties().getParametersLink().getUri() == null) {
                    throw new NullPointerException("parameters.Properties.ParametersLink.Uri");
                }
            }
            if (parameters.getProperties().getTemplateLink() != null) {
                if (parameters.getProperties().getTemplateLink().getUri() == null) {
                    throw new NullPointerException("parameters.Properties.TemplateLink.Uri");
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode deploymentValue = objectMapper.createObjectNode();
        requestDoc = deploymentValue;
        
        if (parameters.getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) deploymentValue).put("properties", propertiesValue);
            
            if (parameters.getProperties().getTemplate() != null) {
                ((ObjectNode) propertiesValue).put("template", objectMapper.readTree(parameters.getProperties().getTemplate()));
            }
            
            if (parameters.getProperties().getTemplateLink() != null) {
                ObjectNode templateLinkValue = objectMapper.createObjectNode();
                ((ObjectNode) propertiesValue).put("templateLink", templateLinkValue);
                
                ((ObjectNode) templateLinkValue).put("uri", parameters.getProperties().getTemplateLink().getUri().toString());
                
                if (parameters.getProperties().getTemplateLink().getContentVersion() != null) {
                    ((ObjectNode) templateLinkValue).put("contentVersion", parameters.getProperties().getTemplateLink().getContentVersion());
                }
            }
            
            if (parameters.getProperties().getParameters() != null) {
                ((ObjectNode) propertiesValue).put("parameters", objectMapper.readTree(parameters.getProperties().getParameters()));
            }
            
            if (parameters.getProperties().getParametersLink() != null) {
                ObjectNode parametersLinkValue = objectMapper.createObjectNode();
                ((ObjectNode) propertiesValue).put("parametersLink", parametersLinkValue);
                
                ((ObjectNode) parametersLinkValue).put("uri", parameters.getProperties().getParametersLink().getUri().toString());
                
                if (parameters.getProperties().getParametersLink().getContentVersion() != null) {
                    ((ObjectNode) parametersLinkValue).put("contentVersion", parameters.getProperties().getParametersLink().getContentVersion());
                }
            }
            
            if (parameters.getProperties().getMode() != null) {
                ((ObjectNode) propertiesValue).put("mode", parameters.getProperties().getMode().toString());
            }
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentOperationsCreateResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentOperationsCreateResult();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    DeploymentExtended deploymentInstance = new DeploymentExtended();
                    result.setDeployment(deploymentInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        deploymentInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        deploymentInstance.setName(nameInstance);
                    }
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        DeploymentPropertiesExtended propertiesInstance = new DeploymentPropertiesExtended();
                        deploymentInstance.setProperties(propertiesInstance);
                        
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode correlationIdValue = propertiesValue2.get("correlationId");
                        if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                            String correlationIdInstance;
                            correlationIdInstance = correlationIdValue.getTextValue();
                            propertiesInstance.setCorrelationId(correlationIdInstance);
                        }
                        
                        JsonNode timestampValue = propertiesValue2.get("timestamp");
                        if (timestampValue != null && timestampValue instanceof NullNode == false) {
                            Calendar timestampInstance;
                            timestampInstance = DatatypeConverter.parseDateTime(timestampValue.getTextValue());
                            propertiesInstance.setTimestamp(timestampInstance);
                        }
                        
                        JsonNode outputsValue = propertiesValue2.get("outputs");
                        if (outputsValue != null && outputsValue instanceof NullNode == false) {
                            String outputsInstance;
                            outputsInstance = outputsValue.getTextValue();
                            propertiesInstance.setOutputs(outputsInstance);
                        }
                        
                        JsonNode providersArray = propertiesValue2.get("providers");
                        if (providersArray != null && providersArray instanceof NullNode == false) {
                            for (JsonNode providersValue : ((ArrayNode) providersArray)) {
                                Provider providerInstance = new Provider();
                                propertiesInstance.getProviders().add(providerInstance);
                                
                                JsonNode idValue2 = providersValue.get("id");
                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                    String idInstance2;
                                    idInstance2 = idValue2.getTextValue();
                                    providerInstance.setId(idInstance2);
                                }
                                
                                JsonNode namespaceValue = providersValue.get("namespace");
                                if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                    String namespaceInstance;
                                    namespaceInstance = namespaceValue.getTextValue();
                                    providerInstance.setNamespace(namespaceInstance);
                                }
                                
                                JsonNode registrationStateValue = providersValue.get("registrationState");
                                if (registrationStateValue != null && registrationStateValue instanceof NullNode == false) {
                                    String registrationStateInstance;
                                    registrationStateInstance = registrationStateValue.getTextValue();
                                    providerInstance.setRegistrationState(registrationStateInstance);
                                }
                                
                                JsonNode resourceTypesArray = providersValue.get("resourceTypes");
                                if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                                    for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                                        ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                        providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                        
                                        JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                        if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                            String resourceTypeInstance;
                                            resourceTypeInstance = resourceTypeValue.getTextValue();
                                            providerResourceTypeInstance.setName(resourceTypeInstance);
                                        }
                                        
                                        JsonNode locationsArray = resourceTypesValue.get("locations");
                                        if (locationsArray != null && locationsArray instanceof NullNode == false) {
                                            for (JsonNode locationsValue : ((ArrayNode) locationsArray)) {
                                                providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                            }
                                        }
                                        
                                        JsonNode apiVersionsArray = resourceTypesValue.get("apiVersions");
                                        if (apiVersionsArray != null && apiVersionsArray instanceof NullNode == false) {
                                            for (JsonNode apiVersionsValue : ((ArrayNode) apiVersionsArray)) {
                                                providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                            }
                                        }
                                        
                                        JsonNode propertiesSequenceElement = ((JsonNode) resourceTypesValue.get("properties"));
                                        if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr = propertiesSequenceElement.getFields();
                                            while (itr.hasNext()) {
                                                Map.Entry<String, JsonNode> property = itr.next();
                                                String propertiesKey = property.getKey();
                                                String propertiesValue3 = property.getValue().getTextValue();
                                                providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue3);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        
                        JsonNode dependenciesArray = propertiesValue2.get("dependencies");
                        if (dependenciesArray != null && dependenciesArray instanceof NullNode == false) {
                            for (JsonNode dependenciesValue : ((ArrayNode) dependenciesArray)) {
                                Dependency dependencyInstance = new Dependency();
                                propertiesInstance.getDependencies().add(dependencyInstance);
                                
                                JsonNode dependsOnArray = dependenciesValue.get("dependsOn");
                                if (dependsOnArray != null && dependsOnArray instanceof NullNode == false) {
                                    for (JsonNode dependsOnValue : ((ArrayNode) dependsOnArray)) {
                                        BasicDependency basicDependencyInstance = new BasicDependency();
                                        dependencyInstance.getDependsOn().add(basicDependencyInstance);
                                        
                                        JsonNode idValue3 = dependsOnValue.get("id");
                                        if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                            String idInstance3;
                                            idInstance3 = idValue3.getTextValue();
                                            basicDependencyInstance.setId(idInstance3);
                                        }
                                        
                                        JsonNode resourceTypeValue2 = dependsOnValue.get("resourceType");
                                        if (resourceTypeValue2 != null && resourceTypeValue2 instanceof NullNode == false) {
                                            String resourceTypeInstance2;
                                            resourceTypeInstance2 = resourceTypeValue2.getTextValue();
                                            basicDependencyInstance.setResourceType(resourceTypeInstance2);
                                        }
                                        
                                        JsonNode resourceNameValue = dependsOnValue.get("resourceName");
                                        if (resourceNameValue != null && resourceNameValue instanceof NullNode == false) {
                                            String resourceNameInstance;
                                            resourceNameInstance = resourceNameValue.getTextValue();
                                            basicDependencyInstance.setResourceName(resourceNameInstance);
                                        }
                                    }
                                }
                                
                                JsonNode idValue4 = dependenciesValue.get("id");
                                if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                    String idInstance4;
                                    idInstance4 = idValue4.getTextValue();
                                    dependencyInstance.setId(idInstance4);
                                }
                                
                                JsonNode resourceTypeValue3 = dependenciesValue.get("resourceType");
                                if (resourceTypeValue3 != null && resourceTypeValue3 instanceof NullNode == false) {
                                    String resourceTypeInstance3;
                                    resourceTypeInstance3 = resourceTypeValue3.getTextValue();
                                    dependencyInstance.setResourceType(resourceTypeInstance3);
                                }
                                
                                JsonNode resourceNameValue2 = dependenciesValue.get("resourceName");
                                if (resourceNameValue2 != null && resourceNameValue2 instanceof NullNode == false) {
                                    String resourceNameInstance2;
                                    resourceNameInstance2 = resourceNameValue2.getTextValue();
                                    dependencyInstance.setResourceName(resourceNameInstance2);
                                }
                            }
                        }
                        
                        JsonNode templateValue = propertiesValue2.get("template");
                        if (templateValue != null && templateValue instanceof NullNode == false) {
                            String templateInstance;
                            templateInstance = templateValue.getTextValue();
                            propertiesInstance.setTemplate(templateInstance);
                        }
                        
                        JsonNode templateLinkValue2 = propertiesValue2.get("templateLink");
                        if (templateLinkValue2 != null && templateLinkValue2 instanceof NullNode == false) {
                            TemplateLink templateLinkInstance = new TemplateLink();
                            propertiesInstance.setTemplateLink(templateLinkInstance);
                            
                            JsonNode uriValue = templateLinkValue2.get("uri");
                            if (uriValue != null && uriValue instanceof NullNode == false) {
                                URI uriInstance;
                                uriInstance = new URI(uriValue.getTextValue());
                                templateLinkInstance.setUri(uriInstance);
                            }
                            
                            JsonNode contentVersionValue = templateLinkValue2.get("contentVersion");
                            if (contentVersionValue != null && contentVersionValue instanceof NullNode == false) {
                                String contentVersionInstance;
                                contentVersionInstance = contentVersionValue.getTextValue();
                                templateLinkInstance.setContentVersion(contentVersionInstance);
                            }
                        }
                        
                        JsonNode parametersValue = propertiesValue2.get("parameters");
                        if (parametersValue != null && parametersValue instanceof NullNode == false) {
                            String parametersInstance;
                            parametersInstance = parametersValue.getTextValue();
                            propertiesInstance.setParameters(parametersInstance);
                        }
                        
                        JsonNode parametersLinkValue2 = propertiesValue2.get("parametersLink");
                        if (parametersLinkValue2 != null && parametersLinkValue2 instanceof NullNode == false) {
                            ParametersLink parametersLinkInstance = new ParametersLink();
                            propertiesInstance.setParametersLink(parametersLinkInstance);
                            
                            JsonNode uriValue2 = parametersLinkValue2.get("uri");
                            if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                URI uriInstance2;
                                uriInstance2 = new URI(uriValue2.getTextValue());
                                parametersLinkInstance.setUri(uriInstance2);
                            }
                            
                            JsonNode contentVersionValue2 = parametersLinkValue2.get("contentVersion");
                            if (contentVersionValue2 != null && contentVersionValue2 instanceof NullNode == false) {
                                String contentVersionInstance2;
                                contentVersionInstance2 = contentVersionValue2.getTextValue();
                                parametersLinkInstance.setContentVersion(contentVersionInstance2);
                            }
                        }
                        
                        JsonNode modeValue = propertiesValue2.get("mode");
                        if (modeValue != null && modeValue instanceof NullNode == false) {
                            DeploymentMode modeInstance;
                            modeInstance = Enum.valueOf(DeploymentMode.class, modeValue.getTextValue());
                            propertiesInstance.setMode(modeInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Delete deployment and all of its resources.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment to be deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String deploymentName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, deploymentName);
            }
         });
    }
    
    /**
    * Delete deployment and all of its resources.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment to be deleted.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String deploymentName) throws InterruptedException, ExecutionException, IOException, ServiceException {
        ResourceManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            LongRunningOperationResponse response = client2.getDeploymentsOperations().beginDeletingAsync(resourceGroupName, deploymentName).get();
            LongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getOperationStatusLink()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getOperationStatusLink()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Get a deployment.
    *
    * @param resourceGroupName Required. The name of the resource group to get.
    * The name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @return Template deployment information.
    */
    @Override
    public Future<DeploymentGetResult> getAsync(final String resourceGroupName, final String deploymentName) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentGetResult>() { 
            @Override
            public DeploymentGetResult call() throws Exception {
                return get(resourceGroupName, deploymentName);
            }
         });
    }
    
    /**
    * Get a deployment.
    *
    * @param resourceGroupName Required. The name of the resource group to get.
    * The name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Template deployment information.
    */
    @Override
    public DeploymentGetResult get(String resourceGroupName, String deploymentName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentGetResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentGetResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    DeploymentExtended deploymentInstance = new DeploymentExtended();
                    result.setDeployment(deploymentInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        deploymentInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        deploymentInstance.setName(nameInstance);
                    }
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        DeploymentPropertiesExtended propertiesInstance = new DeploymentPropertiesExtended();
                        deploymentInstance.setProperties(propertiesInstance);
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode correlationIdValue = propertiesValue.get("correlationId");
                        if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                            String correlationIdInstance;
                            correlationIdInstance = correlationIdValue.getTextValue();
                            propertiesInstance.setCorrelationId(correlationIdInstance);
                        }
                        
                        JsonNode timestampValue = propertiesValue.get("timestamp");
                        if (timestampValue != null && timestampValue instanceof NullNode == false) {
                            Calendar timestampInstance;
                            timestampInstance = DatatypeConverter.parseDateTime(timestampValue.getTextValue());
                            propertiesInstance.setTimestamp(timestampInstance);
                        }
                        
                        JsonNode outputsValue = propertiesValue.get("outputs");
                        if (outputsValue != null && outputsValue instanceof NullNode == false) {
                            String outputsInstance;
                            outputsInstance = outputsValue.getTextValue();
                            propertiesInstance.setOutputs(outputsInstance);
                        }
                        
                        JsonNode providersArray = propertiesValue.get("providers");
                        if (providersArray != null && providersArray instanceof NullNode == false) {
                            for (JsonNode providersValue : ((ArrayNode) providersArray)) {
                                Provider providerInstance = new Provider();
                                propertiesInstance.getProviders().add(providerInstance);
                                
                                JsonNode idValue2 = providersValue.get("id");
                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                    String idInstance2;
                                    idInstance2 = idValue2.getTextValue();
                                    providerInstance.setId(idInstance2);
                                }
                                
                                JsonNode namespaceValue = providersValue.get("namespace");
                                if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                    String namespaceInstance;
                                    namespaceInstance = namespaceValue.getTextValue();
                                    providerInstance.setNamespace(namespaceInstance);
                                }
                                
                                JsonNode registrationStateValue = providersValue.get("registrationState");
                                if (registrationStateValue != null && registrationStateValue instanceof NullNode == false) {
                                    String registrationStateInstance;
                                    registrationStateInstance = registrationStateValue.getTextValue();
                                    providerInstance.setRegistrationState(registrationStateInstance);
                                }
                                
                                JsonNode resourceTypesArray = providersValue.get("resourceTypes");
                                if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                                    for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                                        ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                        providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                        
                                        JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                        if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                            String resourceTypeInstance;
                                            resourceTypeInstance = resourceTypeValue.getTextValue();
                                            providerResourceTypeInstance.setName(resourceTypeInstance);
                                        }
                                        
                                        JsonNode locationsArray = resourceTypesValue.get("locations");
                                        if (locationsArray != null && locationsArray instanceof NullNode == false) {
                                            for (JsonNode locationsValue : ((ArrayNode) locationsArray)) {
                                                providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                            }
                                        }
                                        
                                        JsonNode apiVersionsArray = resourceTypesValue.get("apiVersions");
                                        if (apiVersionsArray != null && apiVersionsArray instanceof NullNode == false) {
                                            for (JsonNode apiVersionsValue : ((ArrayNode) apiVersionsArray)) {
                                                providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                            }
                                        }
                                        
                                        JsonNode propertiesSequenceElement = ((JsonNode) resourceTypesValue.get("properties"));
                                        if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr = propertiesSequenceElement.getFields();
                                            while (itr.hasNext()) {
                                                Map.Entry<String, JsonNode> property = itr.next();
                                                String propertiesKey = property.getKey();
                                                String propertiesValue2 = property.getValue().getTextValue();
                                                providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue2);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        
                        JsonNode dependenciesArray = propertiesValue.get("dependencies");
                        if (dependenciesArray != null && dependenciesArray instanceof NullNode == false) {
                            for (JsonNode dependenciesValue : ((ArrayNode) dependenciesArray)) {
                                Dependency dependencyInstance = new Dependency();
                                propertiesInstance.getDependencies().add(dependencyInstance);
                                
                                JsonNode dependsOnArray = dependenciesValue.get("dependsOn");
                                if (dependsOnArray != null && dependsOnArray instanceof NullNode == false) {
                                    for (JsonNode dependsOnValue : ((ArrayNode) dependsOnArray)) {
                                        BasicDependency basicDependencyInstance = new BasicDependency();
                                        dependencyInstance.getDependsOn().add(basicDependencyInstance);
                                        
                                        JsonNode idValue3 = dependsOnValue.get("id");
                                        if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                            String idInstance3;
                                            idInstance3 = idValue3.getTextValue();
                                            basicDependencyInstance.setId(idInstance3);
                                        }
                                        
                                        JsonNode resourceTypeValue2 = dependsOnValue.get("resourceType");
                                        if (resourceTypeValue2 != null && resourceTypeValue2 instanceof NullNode == false) {
                                            String resourceTypeInstance2;
                                            resourceTypeInstance2 = resourceTypeValue2.getTextValue();
                                            basicDependencyInstance.setResourceType(resourceTypeInstance2);
                                        }
                                        
                                        JsonNode resourceNameValue = dependsOnValue.get("resourceName");
                                        if (resourceNameValue != null && resourceNameValue instanceof NullNode == false) {
                                            String resourceNameInstance;
                                            resourceNameInstance = resourceNameValue.getTextValue();
                                            basicDependencyInstance.setResourceName(resourceNameInstance);
                                        }
                                    }
                                }
                                
                                JsonNode idValue4 = dependenciesValue.get("id");
                                if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                    String idInstance4;
                                    idInstance4 = idValue4.getTextValue();
                                    dependencyInstance.setId(idInstance4);
                                }
                                
                                JsonNode resourceTypeValue3 = dependenciesValue.get("resourceType");
                                if (resourceTypeValue3 != null && resourceTypeValue3 instanceof NullNode == false) {
                                    String resourceTypeInstance3;
                                    resourceTypeInstance3 = resourceTypeValue3.getTextValue();
                                    dependencyInstance.setResourceType(resourceTypeInstance3);
                                }
                                
                                JsonNode resourceNameValue2 = dependenciesValue.get("resourceName");
                                if (resourceNameValue2 != null && resourceNameValue2 instanceof NullNode == false) {
                                    String resourceNameInstance2;
                                    resourceNameInstance2 = resourceNameValue2.getTextValue();
                                    dependencyInstance.setResourceName(resourceNameInstance2);
                                }
                            }
                        }
                        
                        JsonNode templateValue = propertiesValue.get("template");
                        if (templateValue != null && templateValue instanceof NullNode == false) {
                            String templateInstance;
                            templateInstance = templateValue.getTextValue();
                            propertiesInstance.setTemplate(templateInstance);
                        }
                        
                        JsonNode templateLinkValue = propertiesValue.get("templateLink");
                        if (templateLinkValue != null && templateLinkValue instanceof NullNode == false) {
                            TemplateLink templateLinkInstance = new TemplateLink();
                            propertiesInstance.setTemplateLink(templateLinkInstance);
                            
                            JsonNode uriValue = templateLinkValue.get("uri");
                            if (uriValue != null && uriValue instanceof NullNode == false) {
                                URI uriInstance;
                                uriInstance = new URI(uriValue.getTextValue());
                                templateLinkInstance.setUri(uriInstance);
                            }
                            
                            JsonNode contentVersionValue = templateLinkValue.get("contentVersion");
                            if (contentVersionValue != null && contentVersionValue instanceof NullNode == false) {
                                String contentVersionInstance;
                                contentVersionInstance = contentVersionValue.getTextValue();
                                templateLinkInstance.setContentVersion(contentVersionInstance);
                            }
                        }
                        
                        JsonNode parametersValue = propertiesValue.get("parameters");
                        if (parametersValue != null && parametersValue instanceof NullNode == false) {
                            String parametersInstance;
                            parametersInstance = parametersValue.getTextValue();
                            propertiesInstance.setParameters(parametersInstance);
                        }
                        
                        JsonNode parametersLinkValue = propertiesValue.get("parametersLink");
                        if (parametersLinkValue != null && parametersLinkValue instanceof NullNode == false) {
                            ParametersLink parametersLinkInstance = new ParametersLink();
                            propertiesInstance.setParametersLink(parametersLinkInstance);
                            
                            JsonNode uriValue2 = parametersLinkValue.get("uri");
                            if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                URI uriInstance2;
                                uriInstance2 = new URI(uriValue2.getTextValue());
                                parametersLinkInstance.setUri(uriInstance2);
                            }
                            
                            JsonNode contentVersionValue2 = parametersLinkValue.get("contentVersion");
                            if (contentVersionValue2 != null && contentVersionValue2 instanceof NullNode == false) {
                                String contentVersionInstance2;
                                contentVersionInstance2 = contentVersionValue2.getTextValue();
                                parametersLinkInstance.setContentVersion(contentVersionInstance2);
                            }
                        }
                        
                        JsonNode modeValue = propertiesValue.get("mode");
                        if (modeValue != null && modeValue instanceof NullNode == false) {
                            DeploymentMode modeInstance;
                            modeInstance = Enum.valueOf(DeploymentMode.class, modeValue.getTextValue());
                            propertiesInstance.setMode(modeInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get a list of deployments.
    *
    * @param resourceGroupName Required. The name of the resource group to
    * filter by. The name is case insensitive.
    * @param parameters Optional. Query parameters. If null is passed returns
    * all deployments.
    * @return List of deployments.
    */
    @Override
    public Future<DeploymentListResult> listAsync(final String resourceGroupName, final DeploymentListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentListResult>() { 
            @Override
            public DeploymentListResult call() throws Exception {
                return list(resourceGroupName, parameters);
            }
         });
    }
    
    /**
    * Get a list of deployments.
    *
    * @param resourceGroupName Required. The name of the resource group to
    * filter by. The name is case insensitive.
    * @param parameters Optional. Query parameters. If null is passed returns
    * all deployments.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of deployments.
    */
    @Override
    public DeploymentListResult list(String resourceGroupName, DeploymentListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/";
        url = url + "resourcegroups/" + URLEncoder.encode(resourceGroupName, "UTF-8") + "/";
        url = url + "deployments/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        ArrayList<String> odataFilter = new ArrayList<String>();
        if (parameters != null && parameters.getProvisioningState() != null) {
            odataFilter.add("provisioningState eq '" + URLEncoder.encode(parameters.getProvisioningState(), "UTF-8") + "'");
        }
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, null));
        }
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            DeploymentExtended deploymentExtendedInstance = new DeploymentExtended();
                            result.getDeployments().add(deploymentExtendedInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                deploymentExtendedInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                deploymentExtendedInstance.setName(nameInstance);
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                DeploymentPropertiesExtended propertiesInstance = new DeploymentPropertiesExtended();
                                deploymentExtendedInstance.setProperties(propertiesInstance);
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    propertiesInstance.setProvisioningState(provisioningStateInstance);
                                }
                                
                                JsonNode correlationIdValue = propertiesValue.get("correlationId");
                                if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                                    String correlationIdInstance;
                                    correlationIdInstance = correlationIdValue.getTextValue();
                                    propertiesInstance.setCorrelationId(correlationIdInstance);
                                }
                                
                                JsonNode timestampValue = propertiesValue.get("timestamp");
                                if (timestampValue != null && timestampValue instanceof NullNode == false) {
                                    Calendar timestampInstance;
                                    timestampInstance = DatatypeConverter.parseDateTime(timestampValue.getTextValue());
                                    propertiesInstance.setTimestamp(timestampInstance);
                                }
                                
                                JsonNode outputsValue = propertiesValue.get("outputs");
                                if (outputsValue != null && outputsValue instanceof NullNode == false) {
                                    String outputsInstance;
                                    outputsInstance = outputsValue.getTextValue();
                                    propertiesInstance.setOutputs(outputsInstance);
                                }
                                
                                JsonNode providersArray = propertiesValue.get("providers");
                                if (providersArray != null && providersArray instanceof NullNode == false) {
                                    for (JsonNode providersValue : ((ArrayNode) providersArray)) {
                                        Provider providerInstance = new Provider();
                                        propertiesInstance.getProviders().add(providerInstance);
                                        
                                        JsonNode idValue2 = providersValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            providerInstance.setId(idInstance2);
                                        }
                                        
                                        JsonNode namespaceValue = providersValue.get("namespace");
                                        if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                            String namespaceInstance;
                                            namespaceInstance = namespaceValue.getTextValue();
                                            providerInstance.setNamespace(namespaceInstance);
                                        }
                                        
                                        JsonNode registrationStateValue = providersValue.get("registrationState");
                                        if (registrationStateValue != null && registrationStateValue instanceof NullNode == false) {
                                            String registrationStateInstance;
                                            registrationStateInstance = registrationStateValue.getTextValue();
                                            providerInstance.setRegistrationState(registrationStateInstance);
                                        }
                                        
                                        JsonNode resourceTypesArray = providersValue.get("resourceTypes");
                                        if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                                            for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                                                ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                                providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                                
                                                JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                                if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                                    String resourceTypeInstance;
                                                    resourceTypeInstance = resourceTypeValue.getTextValue();
                                                    providerResourceTypeInstance.setName(resourceTypeInstance);
                                                }
                                                
                                                JsonNode locationsArray = resourceTypesValue.get("locations");
                                                if (locationsArray != null && locationsArray instanceof NullNode == false) {
                                                    for (JsonNode locationsValue : ((ArrayNode) locationsArray)) {
                                                        providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                                    }
                                                }
                                                
                                                JsonNode apiVersionsArray = resourceTypesValue.get("apiVersions");
                                                if (apiVersionsArray != null && apiVersionsArray instanceof NullNode == false) {
                                                    for (JsonNode apiVersionsValue : ((ArrayNode) apiVersionsArray)) {
                                                        providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                                    }
                                                }
                                                
                                                JsonNode propertiesSequenceElement = ((JsonNode) resourceTypesValue.get("properties"));
                                                if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                                    Iterator<Map.Entry<String, JsonNode>> itr = propertiesSequenceElement.getFields();
                                                    while (itr.hasNext()) {
                                                        Map.Entry<String, JsonNode> property = itr.next();
                                                        String propertiesKey = property.getKey();
                                                        String propertiesValue2 = property.getValue().getTextValue();
                                                        providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue2);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode dependenciesArray = propertiesValue.get("dependencies");
                                if (dependenciesArray != null && dependenciesArray instanceof NullNode == false) {
                                    for (JsonNode dependenciesValue : ((ArrayNode) dependenciesArray)) {
                                        Dependency dependencyInstance = new Dependency();
                                        propertiesInstance.getDependencies().add(dependencyInstance);
                                        
                                        JsonNode dependsOnArray = dependenciesValue.get("dependsOn");
                                        if (dependsOnArray != null && dependsOnArray instanceof NullNode == false) {
                                            for (JsonNode dependsOnValue : ((ArrayNode) dependsOnArray)) {
                                                BasicDependency basicDependencyInstance = new BasicDependency();
                                                dependencyInstance.getDependsOn().add(basicDependencyInstance);
                                                
                                                JsonNode idValue3 = dependsOnValue.get("id");
                                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                    String idInstance3;
                                                    idInstance3 = idValue3.getTextValue();
                                                    basicDependencyInstance.setId(idInstance3);
                                                }
                                                
                                                JsonNode resourceTypeValue2 = dependsOnValue.get("resourceType");
                                                if (resourceTypeValue2 != null && resourceTypeValue2 instanceof NullNode == false) {
                                                    String resourceTypeInstance2;
                                                    resourceTypeInstance2 = resourceTypeValue2.getTextValue();
                                                    basicDependencyInstance.setResourceType(resourceTypeInstance2);
                                                }
                                                
                                                JsonNode resourceNameValue = dependsOnValue.get("resourceName");
                                                if (resourceNameValue != null && resourceNameValue instanceof NullNode == false) {
                                                    String resourceNameInstance;
                                                    resourceNameInstance = resourceNameValue.getTextValue();
                                                    basicDependencyInstance.setResourceName(resourceNameInstance);
                                                }
                                            }
                                        }
                                        
                                        JsonNode idValue4 = dependenciesValue.get("id");
                                        if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                            String idInstance4;
                                            idInstance4 = idValue4.getTextValue();
                                            dependencyInstance.setId(idInstance4);
                                        }
                                        
                                        JsonNode resourceTypeValue3 = dependenciesValue.get("resourceType");
                                        if (resourceTypeValue3 != null && resourceTypeValue3 instanceof NullNode == false) {
                                            String resourceTypeInstance3;
                                            resourceTypeInstance3 = resourceTypeValue3.getTextValue();
                                            dependencyInstance.setResourceType(resourceTypeInstance3);
                                        }
                                        
                                        JsonNode resourceNameValue2 = dependenciesValue.get("resourceName");
                                        if (resourceNameValue2 != null && resourceNameValue2 instanceof NullNode == false) {
                                            String resourceNameInstance2;
                                            resourceNameInstance2 = resourceNameValue2.getTextValue();
                                            dependencyInstance.setResourceName(resourceNameInstance2);
                                        }
                                    }
                                }
                                
                                JsonNode templateValue = propertiesValue.get("template");
                                if (templateValue != null && templateValue instanceof NullNode == false) {
                                    String templateInstance;
                                    templateInstance = templateValue.getTextValue();
                                    propertiesInstance.setTemplate(templateInstance);
                                }
                                
                                JsonNode templateLinkValue = propertiesValue.get("templateLink");
                                if (templateLinkValue != null && templateLinkValue instanceof NullNode == false) {
                                    TemplateLink templateLinkInstance = new TemplateLink();
                                    propertiesInstance.setTemplateLink(templateLinkInstance);
                                    
                                    JsonNode uriValue = templateLinkValue.get("uri");
                                    if (uriValue != null && uriValue instanceof NullNode == false) {
                                        URI uriInstance;
                                        uriInstance = new URI(uriValue.getTextValue());
                                        templateLinkInstance.setUri(uriInstance);
                                    }
                                    
                                    JsonNode contentVersionValue = templateLinkValue.get("contentVersion");
                                    if (contentVersionValue != null && contentVersionValue instanceof NullNode == false) {
                                        String contentVersionInstance;
                                        contentVersionInstance = contentVersionValue.getTextValue();
                                        templateLinkInstance.setContentVersion(contentVersionInstance);
                                    }
                                }
                                
                                JsonNode parametersValue = propertiesValue.get("parameters");
                                if (parametersValue != null && parametersValue instanceof NullNode == false) {
                                    String parametersInstance;
                                    parametersInstance = parametersValue.getTextValue();
                                    propertiesInstance.setParameters(parametersInstance);
                                }
                                
                                JsonNode parametersLinkValue = propertiesValue.get("parametersLink");
                                if (parametersLinkValue != null && parametersLinkValue instanceof NullNode == false) {
                                    ParametersLink parametersLinkInstance = new ParametersLink();
                                    propertiesInstance.setParametersLink(parametersLinkInstance);
                                    
                                    JsonNode uriValue2 = parametersLinkValue.get("uri");
                                    if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                        URI uriInstance2;
                                        uriInstance2 = new URI(uriValue2.getTextValue());
                                        parametersLinkInstance.setUri(uriInstance2);
                                    }
                                    
                                    JsonNode contentVersionValue2 = parametersLinkValue.get("contentVersion");
                                    if (contentVersionValue2 != null && contentVersionValue2 instanceof NullNode == false) {
                                        String contentVersionInstance2;
                                        contentVersionInstance2 = contentVersionValue2.getTextValue();
                                        parametersLinkInstance.setContentVersion(contentVersionInstance2);
                                    }
                                }
                                
                                JsonNode modeValue = propertiesValue.get("mode");
                                if (modeValue != null && modeValue instanceof NullNode == false) {
                                    DeploymentMode modeInstance;
                                    modeInstance = Enum.valueOf(DeploymentMode.class, modeValue.getTextValue());
                                    propertiesInstance.setMode(modeInstance);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return List of deployments.
    */
    @Override
    public Future<DeploymentListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentListResult>() { 
            @Override
            public DeploymentListResult call() throws Exception {
                return listNext(nextLink);
            }
         });
    }
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of deployments.
    */
    @Override
    public DeploymentListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter(invocationId, this, "listNextAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            DeploymentExtended deploymentExtendedInstance = new DeploymentExtended();
                            result.getDeployments().add(deploymentExtendedInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                deploymentExtendedInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                deploymentExtendedInstance.setName(nameInstance);
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                DeploymentPropertiesExtended propertiesInstance = new DeploymentPropertiesExtended();
                                deploymentExtendedInstance.setProperties(propertiesInstance);
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    propertiesInstance.setProvisioningState(provisioningStateInstance);
                                }
                                
                                JsonNode correlationIdValue = propertiesValue.get("correlationId");
                                if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                                    String correlationIdInstance;
                                    correlationIdInstance = correlationIdValue.getTextValue();
                                    propertiesInstance.setCorrelationId(correlationIdInstance);
                                }
                                
                                JsonNode timestampValue = propertiesValue.get("timestamp");
                                if (timestampValue != null && timestampValue instanceof NullNode == false) {
                                    Calendar timestampInstance;
                                    timestampInstance = DatatypeConverter.parseDateTime(timestampValue.getTextValue());
                                    propertiesInstance.setTimestamp(timestampInstance);
                                }
                                
                                JsonNode outputsValue = propertiesValue.get("outputs");
                                if (outputsValue != null && outputsValue instanceof NullNode == false) {
                                    String outputsInstance;
                                    outputsInstance = outputsValue.getTextValue();
                                    propertiesInstance.setOutputs(outputsInstance);
                                }
                                
                                JsonNode providersArray = propertiesValue.get("providers");
                                if (providersArray != null && providersArray instanceof NullNode == false) {
                                    for (JsonNode providersValue : ((ArrayNode) providersArray)) {
                                        Provider providerInstance = new Provider();
                                        propertiesInstance.getProviders().add(providerInstance);
                                        
                                        JsonNode idValue2 = providersValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            providerInstance.setId(idInstance2);
                                        }
                                        
                                        JsonNode namespaceValue = providersValue.get("namespace");
                                        if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                            String namespaceInstance;
                                            namespaceInstance = namespaceValue.getTextValue();
                                            providerInstance.setNamespace(namespaceInstance);
                                        }
                                        
                                        JsonNode registrationStateValue = providersValue.get("registrationState");
                                        if (registrationStateValue != null && registrationStateValue instanceof NullNode == false) {
                                            String registrationStateInstance;
                                            registrationStateInstance = registrationStateValue.getTextValue();
                                            providerInstance.setRegistrationState(registrationStateInstance);
                                        }
                                        
                                        JsonNode resourceTypesArray = providersValue.get("resourceTypes");
                                        if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                                            for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                                                ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                                providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                                
                                                JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                                if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                                    String resourceTypeInstance;
                                                    resourceTypeInstance = resourceTypeValue.getTextValue();
                                                    providerResourceTypeInstance.setName(resourceTypeInstance);
                                                }
                                                
                                                JsonNode locationsArray = resourceTypesValue.get("locations");
                                                if (locationsArray != null && locationsArray instanceof NullNode == false) {
                                                    for (JsonNode locationsValue : ((ArrayNode) locationsArray)) {
                                                        providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                                    }
                                                }
                                                
                                                JsonNode apiVersionsArray = resourceTypesValue.get("apiVersions");
                                                if (apiVersionsArray != null && apiVersionsArray instanceof NullNode == false) {
                                                    for (JsonNode apiVersionsValue : ((ArrayNode) apiVersionsArray)) {
                                                        providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                                    }
                                                }
                                                
                                                JsonNode propertiesSequenceElement = ((JsonNode) resourceTypesValue.get("properties"));
                                                if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                                    Iterator<Map.Entry<String, JsonNode>> itr = propertiesSequenceElement.getFields();
                                                    while (itr.hasNext()) {
                                                        Map.Entry<String, JsonNode> property = itr.next();
                                                        String propertiesKey = property.getKey();
                                                        String propertiesValue2 = property.getValue().getTextValue();
                                                        providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue2);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode dependenciesArray = propertiesValue.get("dependencies");
                                if (dependenciesArray != null && dependenciesArray instanceof NullNode == false) {
                                    for (JsonNode dependenciesValue : ((ArrayNode) dependenciesArray)) {
                                        Dependency dependencyInstance = new Dependency();
                                        propertiesInstance.getDependencies().add(dependencyInstance);
                                        
                                        JsonNode dependsOnArray = dependenciesValue.get("dependsOn");
                                        if (dependsOnArray != null && dependsOnArray instanceof NullNode == false) {
                                            for (JsonNode dependsOnValue : ((ArrayNode) dependsOnArray)) {
                                                BasicDependency basicDependencyInstance = new BasicDependency();
                                                dependencyInstance.getDependsOn().add(basicDependencyInstance);
                                                
                                                JsonNode idValue3 = dependsOnValue.get("id");
                                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                    String idInstance3;
                                                    idInstance3 = idValue3.getTextValue();
                                                    basicDependencyInstance.setId(idInstance3);
                                                }
                                                
                                                JsonNode resourceTypeValue2 = dependsOnValue.get("resourceType");
                                                if (resourceTypeValue2 != null && resourceTypeValue2 instanceof NullNode == false) {
                                                    String resourceTypeInstance2;
                                                    resourceTypeInstance2 = resourceTypeValue2.getTextValue();
                                                    basicDependencyInstance.setResourceType(resourceTypeInstance2);
                                                }
                                                
                                                JsonNode resourceNameValue = dependsOnValue.get("resourceName");
                                                if (resourceNameValue != null && resourceNameValue instanceof NullNode == false) {
                                                    String resourceNameInstance;
                                                    resourceNameInstance = resourceNameValue.getTextValue();
                                                    basicDependencyInstance.setResourceName(resourceNameInstance);
                                                }
                                            }
                                        }
                                        
                                        JsonNode idValue4 = dependenciesValue.get("id");
                                        if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                            String idInstance4;
                                            idInstance4 = idValue4.getTextValue();
                                            dependencyInstance.setId(idInstance4);
                                        }
                                        
                                        JsonNode resourceTypeValue3 = dependenciesValue.get("resourceType");
                                        if (resourceTypeValue3 != null && resourceTypeValue3 instanceof NullNode == false) {
                                            String resourceTypeInstance3;
                                            resourceTypeInstance3 = resourceTypeValue3.getTextValue();
                                            dependencyInstance.setResourceType(resourceTypeInstance3);
                                        }
                                        
                                        JsonNode resourceNameValue2 = dependenciesValue.get("resourceName");
                                        if (resourceNameValue2 != null && resourceNameValue2 instanceof NullNode == false) {
                                            String resourceNameInstance2;
                                            resourceNameInstance2 = resourceNameValue2.getTextValue();
                                            dependencyInstance.setResourceName(resourceNameInstance2);
                                        }
                                    }
                                }
                                
                                JsonNode templateValue = propertiesValue.get("template");
                                if (templateValue != null && templateValue instanceof NullNode == false) {
                                    String templateInstance;
                                    templateInstance = templateValue.getTextValue();
                                    propertiesInstance.setTemplate(templateInstance);
                                }
                                
                                JsonNode templateLinkValue = propertiesValue.get("templateLink");
                                if (templateLinkValue != null && templateLinkValue instanceof NullNode == false) {
                                    TemplateLink templateLinkInstance = new TemplateLink();
                                    propertiesInstance.setTemplateLink(templateLinkInstance);
                                    
                                    JsonNode uriValue = templateLinkValue.get("uri");
                                    if (uriValue != null && uriValue instanceof NullNode == false) {
                                        URI uriInstance;
                                        uriInstance = new URI(uriValue.getTextValue());
                                        templateLinkInstance.setUri(uriInstance);
                                    }
                                    
                                    JsonNode contentVersionValue = templateLinkValue.get("contentVersion");
                                    if (contentVersionValue != null && contentVersionValue instanceof NullNode == false) {
                                        String contentVersionInstance;
                                        contentVersionInstance = contentVersionValue.getTextValue();
                                        templateLinkInstance.setContentVersion(contentVersionInstance);
                                    }
                                }
                                
                                JsonNode parametersValue = propertiesValue.get("parameters");
                                if (parametersValue != null && parametersValue instanceof NullNode == false) {
                                    String parametersInstance;
                                    parametersInstance = parametersValue.getTextValue();
                                    propertiesInstance.setParameters(parametersInstance);
                                }
                                
                                JsonNode parametersLinkValue = propertiesValue.get("parametersLink");
                                if (parametersLinkValue != null && parametersLinkValue instanceof NullNode == false) {
                                    ParametersLink parametersLinkInstance = new ParametersLink();
                                    propertiesInstance.setParametersLink(parametersLinkInstance);
                                    
                                    JsonNode uriValue2 = parametersLinkValue.get("uri");
                                    if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                        URI uriInstance2;
                                        uriInstance2 = new URI(uriValue2.getTextValue());
                                        parametersLinkInstance.setUri(uriInstance2);
                                    }
                                    
                                    JsonNode contentVersionValue2 = parametersLinkValue.get("contentVersion");
                                    if (contentVersionValue2 != null && contentVersionValue2 instanceof NullNode == false) {
                                        String contentVersionInstance2;
                                        contentVersionInstance2 = contentVersionValue2.getTextValue();
                                        parametersLinkInstance.setContentVersion(contentVersionInstance2);
                                    }
                                }
                                
                                JsonNode modeValue = propertiesValue.get("mode");
                                if (modeValue != null && modeValue instanceof NullNode == false) {
                                    DeploymentMode modeInstance;
                                    modeInstance = Enum.valueOf(DeploymentMode.class, modeValue.getTextValue());
                                    propertiesInstance.setMode(modeInstance);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Validate a deployment template.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Deployment to validate.
    * @return Information from validate template deployment response.
    */
    @Override
    public Future<DeploymentValidateResponse> validateAsync(final String resourceGroupName, final String deploymentName, final Deployment parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentValidateResponse>() { 
            @Override
            public DeploymentValidateResponse call() throws Exception {
                return validate(resourceGroupName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * Validate a deployment template.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Deployment to validate.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Information from validate template deployment response.
    */
    @Override
    public DeploymentValidateResponse validate(String resourceGroupName, String deploymentName, Deployment parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() != null) {
            if (parameters.getProperties().getParametersLink() != null) {
                if (parameters.getProperties().getParametersLink().getUri() == null) {
                    throw new NullPointerException("parameters.Properties.ParametersLink.Uri");
                }
            }
            if (parameters.getProperties().getTemplateLink() != null) {
                if (parameters.getProperties().getTemplateLink().getUri() == null) {
                    throw new NullPointerException("parameters.Properties.TemplateLink.Uri");
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "validateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/microsoft.resources/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/validate";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode deploymentValue = objectMapper.createObjectNode();
        requestDoc = deploymentValue;
        
        if (parameters.getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) deploymentValue).put("properties", propertiesValue);
            
            if (parameters.getProperties().getTemplate() != null) {
                ((ObjectNode) propertiesValue).put("template", objectMapper.readTree(parameters.getProperties().getTemplate()));
            }
            
            if (parameters.getProperties().getTemplateLink() != null) {
                ObjectNode templateLinkValue = objectMapper.createObjectNode();
                ((ObjectNode) propertiesValue).put("templateLink", templateLinkValue);
                
                ((ObjectNode) templateLinkValue).put("uri", parameters.getProperties().getTemplateLink().getUri().toString());
                
                if (parameters.getProperties().getTemplateLink().getContentVersion() != null) {
                    ((ObjectNode) templateLinkValue).put("contentVersion", parameters.getProperties().getTemplateLink().getContentVersion());
                }
            }
            
            if (parameters.getProperties().getParameters() != null) {
                ((ObjectNode) propertiesValue).put("parameters", objectMapper.readTree(parameters.getProperties().getParameters()));
            }
            
            if (parameters.getProperties().getParametersLink() != null) {
                ObjectNode parametersLinkValue = objectMapper.createObjectNode();
                ((ObjectNode) propertiesValue).put("parametersLink", parametersLinkValue);
                
                ((ObjectNode) parametersLinkValue).put("uri", parameters.getProperties().getParametersLink().getUri().toString());
                
                if (parameters.getProperties().getParametersLink().getContentVersion() != null) {
                    ((ObjectNode) parametersLinkValue).put("contentVersion", parameters.getProperties().getParametersLink().getContentVersion());
                }
            }
            
            if (parameters.getProperties().getMode() != null) {
                ((ObjectNode) propertiesValue).put("mode", parameters.getProperties().getMode().toString());
            }
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentValidateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_BAD_REQUEST) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentValidateResponse();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        ResourceManagementErrorWithDetails errorInstance = new ResourceManagementErrorWithDetails();
                        result.setError(errorInstance);
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ResourceManagementError resourceManagementErrorInstance = new ResourceManagementError();
                                errorInstance.getDetails().add(resourceManagementErrorInstance);
                                
                                JsonNode codeValue = detailsValue.get("code");
                                if (codeValue != null && codeValue instanceof NullNode == false) {
                                    String codeInstance;
                                    codeInstance = codeValue.getTextValue();
                                    resourceManagementErrorInstance.setCode(codeInstance);
                                }
                                
                                JsonNode messageValue = detailsValue.get("message");
                                if (messageValue != null && messageValue instanceof NullNode == false) {
                                    String messageInstance;
                                    messageInstance = messageValue.getTextValue();
                                    resourceManagementErrorInstance.setMessage(messageInstance);
                                }
                                
                                JsonNode targetValue = detailsValue.get("target");
                                if (targetValue != null && targetValue instanceof NullNode == false) {
                                    String targetInstance;
                                    targetInstance = targetValue.getTextValue();
                                    resourceManagementErrorInstance.setTarget(targetInstance);
                                }
                            }
                        }
                        
                        JsonNode codeValue2 = errorValue.get("code");
                        if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                            String codeInstance2;
                            codeInstance2 = codeValue2.getTextValue();
                            errorInstance.setCode(codeInstance2);
                        }
                        
                        JsonNode messageValue2 = errorValue.get("message");
                        if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                            String messageInstance2;
                            messageInstance2 = messageValue2.getTextValue();
                            errorInstance.setMessage(messageInstance2);
                        }
                        
                        JsonNode targetValue2 = errorValue.get("target");
                        if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                            String targetInstance2;
                            targetInstance2 = targetValue2.getTextValue();
                            errorInstance.setTarget(targetInstance2);
                        }
                    }
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        DeploymentPropertiesExtended propertiesInstance = new DeploymentPropertiesExtended();
                        result.setProperties(propertiesInstance);
                        
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode correlationIdValue = propertiesValue2.get("correlationId");
                        if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                            String correlationIdInstance;
                            correlationIdInstance = correlationIdValue.getTextValue();
                            propertiesInstance.setCorrelationId(correlationIdInstance);
                        }
                        
                        JsonNode timestampValue = propertiesValue2.get("timestamp");
                        if (timestampValue != null && timestampValue instanceof NullNode == false) {
                            Calendar timestampInstance;
                            timestampInstance = DatatypeConverter.parseDateTime(timestampValue.getTextValue());
                            propertiesInstance.setTimestamp(timestampInstance);
                        }
                        
                        JsonNode outputsValue = propertiesValue2.get("outputs");
                        if (outputsValue != null && outputsValue instanceof NullNode == false) {
                            String outputsInstance;
                            outputsInstance = outputsValue.getTextValue();
                            propertiesInstance.setOutputs(outputsInstance);
                        }
                        
                        JsonNode providersArray = propertiesValue2.get("providers");
                        if (providersArray != null && providersArray instanceof NullNode == false) {
                            for (JsonNode providersValue : ((ArrayNode) providersArray)) {
                                Provider providerInstance = new Provider();
                                propertiesInstance.getProviders().add(providerInstance);
                                
                                JsonNode idValue = providersValue.get("id");
                                if (idValue != null && idValue instanceof NullNode == false) {
                                    String idInstance;
                                    idInstance = idValue.getTextValue();
                                    providerInstance.setId(idInstance);
                                }
                                
                                JsonNode namespaceValue = providersValue.get("namespace");
                                if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                    String namespaceInstance;
                                    namespaceInstance = namespaceValue.getTextValue();
                                    providerInstance.setNamespace(namespaceInstance);
                                }
                                
                                JsonNode registrationStateValue = providersValue.get("registrationState");
                                if (registrationStateValue != null && registrationStateValue instanceof NullNode == false) {
                                    String registrationStateInstance;
                                    registrationStateInstance = registrationStateValue.getTextValue();
                                    providerInstance.setRegistrationState(registrationStateInstance);
                                }
                                
                                JsonNode resourceTypesArray = providersValue.get("resourceTypes");
                                if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                                    for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                                        ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                        providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                        
                                        JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                        if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                            String resourceTypeInstance;
                                            resourceTypeInstance = resourceTypeValue.getTextValue();
                                            providerResourceTypeInstance.setName(resourceTypeInstance);
                                        }
                                        
                                        JsonNode locationsArray = resourceTypesValue.get("locations");
                                        if (locationsArray != null && locationsArray instanceof NullNode == false) {
                                            for (JsonNode locationsValue : ((ArrayNode) locationsArray)) {
                                                providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                            }
                                        }
                                        
                                        JsonNode apiVersionsArray = resourceTypesValue.get("apiVersions");
                                        if (apiVersionsArray != null && apiVersionsArray instanceof NullNode == false) {
                                            for (JsonNode apiVersionsValue : ((ArrayNode) apiVersionsArray)) {
                                                providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                            }
                                        }
                                        
                                        JsonNode propertiesSequenceElement = ((JsonNode) resourceTypesValue.get("properties"));
                                        if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr = propertiesSequenceElement.getFields();
                                            while (itr.hasNext()) {
                                                Map.Entry<String, JsonNode> property = itr.next();
                                                String propertiesKey = property.getKey();
                                                String propertiesValue3 = property.getValue().getTextValue();
                                                providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue3);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        
                        JsonNode dependenciesArray = propertiesValue2.get("dependencies");
                        if (dependenciesArray != null && dependenciesArray instanceof NullNode == false) {
                            for (JsonNode dependenciesValue : ((ArrayNode) dependenciesArray)) {
                                Dependency dependencyInstance = new Dependency();
                                propertiesInstance.getDependencies().add(dependencyInstance);
                                
                                JsonNode dependsOnArray = dependenciesValue.get("dependsOn");
                                if (dependsOnArray != null && dependsOnArray instanceof NullNode == false) {
                                    for (JsonNode dependsOnValue : ((ArrayNode) dependsOnArray)) {
                                        BasicDependency basicDependencyInstance = new BasicDependency();
                                        dependencyInstance.getDependsOn().add(basicDependencyInstance);
                                        
                                        JsonNode idValue2 = dependsOnValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            basicDependencyInstance.setId(idInstance2);
                                        }
                                        
                                        JsonNode resourceTypeValue2 = dependsOnValue.get("resourceType");
                                        if (resourceTypeValue2 != null && resourceTypeValue2 instanceof NullNode == false) {
                                            String resourceTypeInstance2;
                                            resourceTypeInstance2 = resourceTypeValue2.getTextValue();
                                            basicDependencyInstance.setResourceType(resourceTypeInstance2);
                                        }
                                        
                                        JsonNode resourceNameValue = dependsOnValue.get("resourceName");
                                        if (resourceNameValue != null && resourceNameValue instanceof NullNode == false) {
                                            String resourceNameInstance;
                                            resourceNameInstance = resourceNameValue.getTextValue();
                                            basicDependencyInstance.setResourceName(resourceNameInstance);
                                        }
                                    }
                                }
                                
                                JsonNode idValue3 = dependenciesValue.get("id");
                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                    String idInstance3;
                                    idInstance3 = idValue3.getTextValue();
                                    dependencyInstance.setId(idInstance3);
                                }
                                
                                JsonNode resourceTypeValue3 = dependenciesValue.get("resourceType");
                                if (resourceTypeValue3 != null && resourceTypeValue3 instanceof NullNode == false) {
                                    String resourceTypeInstance3;
                                    resourceTypeInstance3 = resourceTypeValue3.getTextValue();
                                    dependencyInstance.setResourceType(resourceTypeInstance3);
                                }
                                
                                JsonNode resourceNameValue2 = dependenciesValue.get("resourceName");
                                if (resourceNameValue2 != null && resourceNameValue2 instanceof NullNode == false) {
                                    String resourceNameInstance2;
                                    resourceNameInstance2 = resourceNameValue2.getTextValue();
                                    dependencyInstance.setResourceName(resourceNameInstance2);
                                }
                            }
                        }
                        
                        JsonNode templateValue = propertiesValue2.get("template");
                        if (templateValue != null && templateValue instanceof NullNode == false) {
                            String templateInstance;
                            templateInstance = templateValue.getTextValue();
                            propertiesInstance.setTemplate(templateInstance);
                        }
                        
                        JsonNode templateLinkValue2 = propertiesValue2.get("templateLink");
                        if (templateLinkValue2 != null && templateLinkValue2 instanceof NullNode == false) {
                            TemplateLink templateLinkInstance = new TemplateLink();
                            propertiesInstance.setTemplateLink(templateLinkInstance);
                            
                            JsonNode uriValue = templateLinkValue2.get("uri");
                            if (uriValue != null && uriValue instanceof NullNode == false) {
                                URI uriInstance;
                                uriInstance = new URI(uriValue.getTextValue());
                                templateLinkInstance.setUri(uriInstance);
                            }
                            
                            JsonNode contentVersionValue = templateLinkValue2.get("contentVersion");
                            if (contentVersionValue != null && contentVersionValue instanceof NullNode == false) {
                                String contentVersionInstance;
                                contentVersionInstance = contentVersionValue.getTextValue();
                                templateLinkInstance.setContentVersion(contentVersionInstance);
                            }
                        }
                        
                        JsonNode parametersValue = propertiesValue2.get("parameters");
                        if (parametersValue != null && parametersValue instanceof NullNode == false) {
                            String parametersInstance;
                            parametersInstance = parametersValue.getTextValue();
                            propertiesInstance.setParameters(parametersInstance);
                        }
                        
                        JsonNode parametersLinkValue2 = propertiesValue2.get("parametersLink");
                        if (parametersLinkValue2 != null && parametersLinkValue2 instanceof NullNode == false) {
                            ParametersLink parametersLinkInstance = new ParametersLink();
                            propertiesInstance.setParametersLink(parametersLinkInstance);
                            
                            JsonNode uriValue2 = parametersLinkValue2.get("uri");
                            if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                URI uriInstance2;
                                uriInstance2 = new URI(uriValue2.getTextValue());
                                parametersLinkInstance.setUri(uriInstance2);
                            }
                            
                            JsonNode contentVersionValue2 = parametersLinkValue2.get("contentVersion");
                            if (contentVersionValue2 != null && contentVersionValue2 instanceof NullNode == false) {
                                String contentVersionInstance2;
                                contentVersionInstance2 = contentVersionValue2.getTextValue();
                                parametersLinkInstance.setContentVersion(contentVersionInstance2);
                            }
                        }
                        
                        JsonNode modeValue = propertiesValue2.get("mode");
                        if (modeValue != null && modeValue instanceof NullNode == false) {
                            DeploymentMode modeInstance;
                            modeInstance = Enum.valueOf(DeploymentMode.class, modeValue.getTextValue());
                            propertiesInstance.setMode(modeInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_OK) {
                result.setIsValid(true);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
