/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.ManagementLockGetQueryParameter;
import com.microsoft.azure.management.resources.models.ManagementLockListResult;
import com.microsoft.azure.management.resources.models.ManagementLockObject;
import com.microsoft.azure.management.resources.models.ManagementLockProperties;
import com.microsoft.azure.management.resources.models.ManagementLockReturnResult;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ResourceIdentity;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

/**
* Operations for managing locks.
*/
public class ManagementLockOperationsImpl implements ServiceOperations<AuthorizationClientImpl>, ManagementLockOperations {
    /**
    * Initializes a new instance of the ManagementLockOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    ManagementLockOperationsImpl(AuthorizationClientImpl client) {
        this.client = client;
    }
    
    private AuthorizationClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.resources.AuthorizationClientImpl.
    * @return The Client value.
    */
    public AuthorizationClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Create or update a management lock at the resource group level.
    *
    * @param resourceGroupName Required. The resource group name.
    * @param lockName Required. The lock name.
    * @param parameters Required. The management lock parameters.
    * @return Management lock information.
    */
    @Override
    public Future<ManagementLockReturnResult> createOrUpdateAtResourceGroupLevelAsync(final String resourceGroupName, final String lockName, final ManagementLockProperties parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ManagementLockReturnResult>() { 
            @Override
            public ManagementLockReturnResult call() throws Exception {
                return createOrUpdateAtResourceGroupLevel(resourceGroupName, lockName, parameters);
            }
         });
    }
    
    /**
    * Create or update a management lock at the resource group level.
    *
    * @param resourceGroupName Required. The resource group name.
    * @param lockName Required. The lock name.
    * @param parameters Required. The management lock parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Management lock information.
    */
    @Override
    public ManagementLockReturnResult createOrUpdateAtResourceGroupLevel(String resourceGroupName, String lockName, ManagementLockProperties parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (lockName == null) {
            throw new NullPointerException("lockName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("lockName", lockName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAtResourceGroupLevelAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/Microsoft.Authorization/locks/";
        url = url + URLEncoder.encode(lockName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-01-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        requestDoc = propertiesValue;
        
        if (parameters.getLevel() != null) {
            ((ObjectNode) propertiesValue).put("level", parameters.getLevel());
        }
        
        if (parameters.getNotes() != null) {
            ((ObjectNode) propertiesValue).put("notes", parameters.getNotes());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ManagementLockReturnResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ManagementLockReturnResult();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ManagementLockObject managementLockInstance = new ManagementLockObject();
                    result.setManagementLock(managementLockInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        ManagementLockProperties propertiesInstance = new ManagementLockProperties();
                        managementLockInstance.setProperties(propertiesInstance);
                        
                        JsonNode levelValue = propertiesValue2.get("level");
                        if (levelValue != null && levelValue instanceof NullNode == false) {
                            String levelInstance;
                            levelInstance = levelValue.getTextValue();
                            propertiesInstance.setLevel(levelInstance);
                        }
                        
                        JsonNode notesValue = propertiesValue2.get("notes");
                        if (notesValue != null && notesValue instanceof NullNode == false) {
                            String notesInstance;
                            notesInstance = notesValue.getTextValue();
                            propertiesInstance.setNotes(notesInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        managementLockInstance.setId(idInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        managementLockInstance.setType(typeInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        managementLockInstance.setName(nameInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Create or update a management lock at the resource level or any level
    * below resource.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param identity Required. Resource identity.
    * @param lockName Required. The name of lock.
    * @param parameters Required. Create or update management lock parameters.
    * @return Management lock information.
    */
    @Override
    public Future<ManagementLockReturnResult> createOrUpdateAtResourceLevelAsync(final String resourceGroupName, final ResourceIdentity identity, final String lockName, final ManagementLockProperties parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ManagementLockReturnResult>() { 
            @Override
            public ManagementLockReturnResult call() throws Exception {
                return createOrUpdateAtResourceLevel(resourceGroupName, identity, lockName, parameters);
            }
         });
    }
    
    /**
    * Create or update a management lock at the resource level or any level
    * below resource.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param identity Required. Resource identity.
    * @param lockName Required. The name of lock.
    * @param parameters Required. Create or update management lock parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Management lock information.
    */
    @Override
    public ManagementLockReturnResult createOrUpdateAtResourceLevel(String resourceGroupName, ResourceIdentity identity, String lockName, ManagementLockProperties parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        if (lockName == null) {
            throw new NullPointerException("lockName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("identity", identity);
            tracingParameters.put("lockName", lockName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAtResourceLevelAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/";
        if (identity.getParentResourcePath() != null) {
            url = url + identity.getParentResourcePath();
        }
        url = url + "/";
        url = url + identity.getResourceType();
        url = url + "/";
        url = url + URLEncoder.encode(identity.getResourceName(), "UTF-8");
        url = url + "/providers/Microsoft.Authorization/locks/";
        url = url + URLEncoder.encode(lockName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-01-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        requestDoc = propertiesValue;
        
        if (parameters.getLevel() != null) {
            ((ObjectNode) propertiesValue).put("level", parameters.getLevel());
        }
        
        if (parameters.getNotes() != null) {
            ((ObjectNode) propertiesValue).put("notes", parameters.getNotes());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ManagementLockReturnResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ManagementLockReturnResult();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ManagementLockObject managementLockInstance = new ManagementLockObject();
                    result.setManagementLock(managementLockInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        ManagementLockProperties propertiesInstance = new ManagementLockProperties();
                        managementLockInstance.setProperties(propertiesInstance);
                        
                        JsonNode levelValue = propertiesValue2.get("level");
                        if (levelValue != null && levelValue instanceof NullNode == false) {
                            String levelInstance;
                            levelInstance = levelValue.getTextValue();
                            propertiesInstance.setLevel(levelInstance);
                        }
                        
                        JsonNode notesValue = propertiesValue2.get("notes");
                        if (notesValue != null && notesValue instanceof NullNode == false) {
                            String notesInstance;
                            notesInstance = notesValue.getTextValue();
                            propertiesInstance.setNotes(notesInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        managementLockInstance.setId(idInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        managementLockInstance.setType(typeInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        managementLockInstance.setName(nameInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Create or update a management lock at the subscription level.
    *
    * @param lockName Required. The name of lock.
    * @param parameters Required. The management lock parameters.
    * @return Management lock information.
    */
    @Override
    public Future<ManagementLockReturnResult> createOrUpdateAtSubscriptionLevelAsync(final String lockName, final ManagementLockProperties parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ManagementLockReturnResult>() { 
            @Override
            public ManagementLockReturnResult call() throws Exception {
                return createOrUpdateAtSubscriptionLevel(lockName, parameters);
            }
         });
    }
    
    /**
    * Create or update a management lock at the subscription level.
    *
    * @param lockName Required. The name of lock.
    * @param parameters Required. The management lock parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Management lock information.
    */
    @Override
    public ManagementLockReturnResult createOrUpdateAtSubscriptionLevel(String lockName, ManagementLockProperties parameters) throws IOException, ServiceException {
        // Validate
        if (lockName == null) {
            throw new NullPointerException("lockName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("lockName", lockName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAtSubscriptionLevelAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/Microsoft.Authorization/locks/";
        url = url + URLEncoder.encode(lockName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-01-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        requestDoc = propertiesValue;
        
        if (parameters.getLevel() != null) {
            ((ObjectNode) propertiesValue).put("level", parameters.getLevel());
        }
        
        if (parameters.getNotes() != null) {
            ((ObjectNode) propertiesValue).put("notes", parameters.getNotes());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ManagementLockReturnResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ManagementLockReturnResult();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ManagementLockObject managementLockInstance = new ManagementLockObject();
                    result.setManagementLock(managementLockInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        ManagementLockProperties propertiesInstance = new ManagementLockProperties();
                        managementLockInstance.setProperties(propertiesInstance);
                        
                        JsonNode levelValue = propertiesValue2.get("level");
                        if (levelValue != null && levelValue instanceof NullNode == false) {
                            String levelInstance;
                            levelInstance = levelValue.getTextValue();
                            propertiesInstance.setLevel(levelInstance);
                        }
                        
                        JsonNode notesValue = propertiesValue2.get("notes");
                        if (notesValue != null && notesValue instanceof NullNode == false) {
                            String notesInstance;
                            notesInstance = notesValue.getTextValue();
                            propertiesInstance.setNotes(notesInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        managementLockInstance.setId(idInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        managementLockInstance.setType(typeInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        managementLockInstance.setName(nameInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes the management lock of a resource group.
    *
    * @param resourceGroup Required. The resource group names.
    * @param lockName Required. The name of lock.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAtResourceGroupLevelAsync(final String resourceGroup, final String lockName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return deleteAtResourceGroupLevel(resourceGroup, lockName);
            }
         });
    }
    
    /**
    * Deletes the management lock of a resource group.
    *
    * @param resourceGroup Required. The resource group names.
    * @param lockName Required. The name of lock.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse deleteAtResourceGroupLevel(String resourceGroup, String lockName) throws IOException, ServiceException {
        // Validate
        if (resourceGroup == null) {
            throw new NullPointerException("resourceGroup");
        }
        if (lockName == null) {
            throw new NullPointerException("lockName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroup", resourceGroup);
            tracingParameters.put("lockName", lockName);
            CloudTracing.enter(invocationId, this, "deleteAtResourceGroupLevelAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroup, "UTF-8");
        url = url + "/providers/Microsoft.Authorization/locks/";
        url = url + URLEncoder.encode(lockName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-01-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes the management lock of a resource or any level below resource.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param identity Required. Resource identity.
    * @param lockName Required. The name of lock.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAtResourceLevelAsync(final String resourceGroupName, final ResourceIdentity identity, final String lockName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return deleteAtResourceLevel(resourceGroupName, identity, lockName);
            }
         });
    }
    
    /**
    * Deletes the management lock of a resource or any level below resource.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param identity Required. Resource identity.
    * @param lockName Required. The name of lock.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse deleteAtResourceLevel(String resourceGroupName, ResourceIdentity identity, String lockName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        if (lockName == null) {
            throw new NullPointerException("lockName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("identity", identity);
            tracingParameters.put("lockName", lockName);
            CloudTracing.enter(invocationId, this, "deleteAtResourceLevelAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/";
        if (identity.getParentResourcePath() != null) {
            url = url + identity.getParentResourcePath();
        }
        url = url + "/";
        url = url + identity.getResourceType();
        url = url + "/";
        url = url + URLEncoder.encode(identity.getResourceName(), "UTF-8");
        url = url + "/providers/Microsoft.Authorization/locks/";
        url = url + URLEncoder.encode(lockName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-01-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes the management lock of a subscription.
    *
    * @param lockName Required. The name of lock.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAtSubscriptionLevelAsync(final String lockName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return deleteAtSubscriptionLevel(lockName);
            }
         });
    }
    
    /**
    * Deletes the management lock of a subscription.
    *
    * @param lockName Required. The name of lock.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse deleteAtSubscriptionLevel(String lockName) throws IOException, ServiceException {
        // Validate
        if (lockName == null) {
            throw new NullPointerException("lockName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("lockName", lockName);
            CloudTracing.enter(invocationId, this, "deleteAtSubscriptionLevelAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/Microsoft.Authorization/locks/";
        url = url + URLEncoder.encode(lockName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-01-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets the management lock of a scope.
    *
    * @param lockName Required. Name of the management lock.
    * @return Management lock information.
    */
    @Override
    public Future<ManagementLockReturnResult> getAsync(final String lockName) {
        return this.getClient().getExecutorService().submit(new Callable<ManagementLockReturnResult>() { 
            @Override
            public ManagementLockReturnResult call() throws Exception {
                return get(lockName);
            }
         });
    }
    
    /**
    * Gets the management lock of a scope.
    *
    * @param lockName Required. Name of the management lock.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Management lock information.
    */
    @Override
    public ManagementLockReturnResult get(String lockName) throws IOException, ServiceException {
        // Validate
        if (lockName == null) {
            throw new NullPointerException("lockName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("lockName", lockName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/Microsoft.Authorization/locks/";
        url = url + URLEncoder.encode(lockName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-01-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ManagementLockReturnResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_NO_CONTENT) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ManagementLockReturnResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ManagementLockObject managementLockInstance = new ManagementLockObject();
                    result.setManagementLock(managementLockInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        ManagementLockProperties propertiesInstance = new ManagementLockProperties();
                        managementLockInstance.setProperties(propertiesInstance);
                        
                        JsonNode levelValue = propertiesValue.get("level");
                        if (levelValue != null && levelValue instanceof NullNode == false) {
                            String levelInstance;
                            levelInstance = levelValue.getTextValue();
                            propertiesInstance.setLevel(levelInstance);
                        }
                        
                        JsonNode notesValue = propertiesValue.get("notes");
                        if (notesValue != null && notesValue instanceof NullNode == false) {
                            String notesInstance;
                            notesInstance = notesValue.getTextValue();
                            propertiesInstance.setNotes(notesInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        managementLockInstance.setId(idInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        managementLockInstance.setType(typeInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        managementLockInstance.setName(nameInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets all the management locks of a resource group.
    *
    * @param resourceGroupName Required. Resource group name.
    * @param parameters Optional. Query parameters. If empty is passed returns
    * all locks at, above or below the resource group.
    * @return List of management locks.
    */
    @Override
    public Future<ManagementLockListResult> listAtResourceGroupLevelAsync(final String resourceGroupName, final ManagementLockGetQueryParameter parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ManagementLockListResult>() { 
            @Override
            public ManagementLockListResult call() throws Exception {
                return listAtResourceGroupLevel(resourceGroupName, parameters);
            }
         });
    }
    
    /**
    * Gets all the management locks of a resource group.
    *
    * @param resourceGroupName Required. Resource group name.
    * @param parameters Optional. Query parameters. If empty is passed returns
    * all locks at, above or below the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of management locks.
    */
    @Override
    public ManagementLockListResult listAtResourceGroupLevel(String resourceGroupName, ManagementLockGetQueryParameter parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAtResourceGroupLevelAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/Microsoft.Authorization/locks";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-01-01");
        ArrayList<String> odataFilter = new ArrayList<String>();
        if (parameters != null && parameters.getAtScope() != null) {
            odataFilter.add(URLEncoder.encode(parameters.getAtScope(), "UTF-8"));
        }
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, null));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ManagementLockListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ManagementLockListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            ManagementLockObject managementLockObjectInstance = new ManagementLockObject();
                            result.getLock().add(managementLockObjectInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                ManagementLockProperties propertiesInstance = new ManagementLockProperties();
                                managementLockObjectInstance.setProperties(propertiesInstance);
                                
                                JsonNode levelValue = propertiesValue.get("level");
                                if (levelValue != null && levelValue instanceof NullNode == false) {
                                    String levelInstance;
                                    levelInstance = levelValue.getTextValue();
                                    propertiesInstance.setLevel(levelInstance);
                                }
                                
                                JsonNode notesValue = propertiesValue.get("notes");
                                if (notesValue != null && notesValue instanceof NullNode == false) {
                                    String notesInstance;
                                    notesInstance = notesValue.getTextValue();
                                    propertiesInstance.setNotes(notesInstance);
                                }
                            }
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                managementLockObjectInstance.setId(idInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                managementLockObjectInstance.setType(typeInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                managementLockObjectInstance.setName(nameInstance);
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets all the management locks of a resource or any level below resource.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param identity Required. Resource identity.
    * @param parameters Optional. Query parameters. If empty is passed returns
    * all locks at or below the resource.If atScope() is passed returns all
    * locks at the resource level.
    * @return List of management locks.
    */
    @Override
    public Future<ManagementLockListResult> listAtResourceLevelAsync(final String resourceGroupName, final ResourceIdentity identity, final ManagementLockGetQueryParameter parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ManagementLockListResult>() { 
            @Override
            public ManagementLockListResult call() throws Exception {
                return listAtResourceLevel(resourceGroupName, identity, parameters);
            }
         });
    }
    
    /**
    * Gets all the management locks of a resource or any level below resource.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param identity Required. Resource identity.
    * @param parameters Optional. Query parameters. If empty is passed returns
    * all locks at or below the resource.If atScope() is passed returns all
    * locks at the resource level.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of management locks.
    */
    @Override
    public ManagementLockListResult listAtResourceLevel(String resourceGroupName, ResourceIdentity identity, ManagementLockGetQueryParameter parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("identity", identity);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAtResourceLevelAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/";
        if (identity.getParentResourcePath() != null) {
            url = url + identity.getParentResourcePath();
        }
        url = url + "/";
        url = url + identity.getResourceType();
        url = url + "/";
        url = url + URLEncoder.encode(identity.getResourceName(), "UTF-8");
        url = url + "/providers/Microsoft.Authorization/locks";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-01-01");
        ArrayList<String> odataFilter = new ArrayList<String>();
        if (parameters != null && parameters.getAtScope() != null) {
            odataFilter.add(URLEncoder.encode(parameters.getAtScope(), "UTF-8"));
        }
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, null));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ManagementLockListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ManagementLockListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            ManagementLockObject managementLockObjectInstance = new ManagementLockObject();
                            result.getLock().add(managementLockObjectInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                ManagementLockProperties propertiesInstance = new ManagementLockProperties();
                                managementLockObjectInstance.setProperties(propertiesInstance);
                                
                                JsonNode levelValue = propertiesValue.get("level");
                                if (levelValue != null && levelValue instanceof NullNode == false) {
                                    String levelInstance;
                                    levelInstance = levelValue.getTextValue();
                                    propertiesInstance.setLevel(levelInstance);
                                }
                                
                                JsonNode notesValue = propertiesValue.get("notes");
                                if (notesValue != null && notesValue instanceof NullNode == false) {
                                    String notesInstance;
                                    notesInstance = notesValue.getTextValue();
                                    propertiesInstance.setNotes(notesInstance);
                                }
                            }
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                managementLockObjectInstance.setId(idInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                managementLockObjectInstance.setType(typeInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                managementLockObjectInstance.setName(nameInstance);
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets all the management locks of a subscription.
    *
    * @param parameters Optional. Query parameters. If empty is passed returns
    * all locks at, above or below the subscription.
    * @return List of management locks.
    */
    @Override
    public Future<ManagementLockListResult> listAtSubscriptionLevelAsync(final ManagementLockGetQueryParameter parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ManagementLockListResult>() { 
            @Override
            public ManagementLockListResult call() throws Exception {
                return listAtSubscriptionLevel(parameters);
            }
         });
    }
    
    /**
    * Gets all the management locks of a subscription.
    *
    * @param parameters Optional. Query parameters. If empty is passed returns
    * all locks at, above or below the subscription.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of management locks.
    */
    @Override
    public ManagementLockListResult listAtSubscriptionLevel(ManagementLockGetQueryParameter parameters) throws IOException, ServiceException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAtSubscriptionLevelAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/Microsoft.Authorization/locks";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-01-01");
        ArrayList<String> odataFilter = new ArrayList<String>();
        if (parameters != null && parameters.getAtScope() != null) {
            odataFilter.add(URLEncoder.encode(parameters.getAtScope(), "UTF-8"));
        }
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, null));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ManagementLockListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ManagementLockListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            ManagementLockObject managementLockObjectInstance = new ManagementLockObject();
                            result.getLock().add(managementLockObjectInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                ManagementLockProperties propertiesInstance = new ManagementLockProperties();
                                managementLockObjectInstance.setProperties(propertiesInstance);
                                
                                JsonNode levelValue = propertiesValue.get("level");
                                if (levelValue != null && levelValue instanceof NullNode == false) {
                                    String levelInstance;
                                    levelInstance = levelValue.getTextValue();
                                    propertiesInstance.setLevel(levelInstance);
                                }
                                
                                JsonNode notesValue = propertiesValue.get("notes");
                                if (notesValue != null && notesValue instanceof NullNode == false) {
                                    String notesInstance;
                                    notesInstance = notesValue.getTextValue();
                                    propertiesInstance.setNotes(notesInstance);
                                }
                            }
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                managementLockObjectInstance.setId(idInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                managementLockObjectInstance.setType(typeInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                managementLockObjectInstance.setName(nameInstance);
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get a list of management locks at resource level or below.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return List of management locks.
    */
    @Override
    public Future<ManagementLockListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<ManagementLockListResult>() { 
            @Override
            public ManagementLockListResult call() throws Exception {
                return listNext(nextLink);
            }
         });
    }
    
    /**
    * Get a list of management locks at resource level or below.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return List of management locks.
    */
    @Override
    public ManagementLockListResult listNext(String nextLink) throws IOException, ServiceException {
        // Validate
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter(invocationId, this, "listNextAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ManagementLockListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ManagementLockListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            ManagementLockObject managementLockObjectInstance = new ManagementLockObject();
                            result.getLock().add(managementLockObjectInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                ManagementLockProperties propertiesInstance = new ManagementLockProperties();
                                managementLockObjectInstance.setProperties(propertiesInstance);
                                
                                JsonNode levelValue = propertiesValue.get("level");
                                if (levelValue != null && levelValue instanceof NullNode == false) {
                                    String levelInstance;
                                    levelInstance = levelValue.getTextValue();
                                    propertiesInstance.setLevel(levelInstance);
                                }
                                
                                JsonNode notesValue = propertiesValue.get("notes");
                                if (notesValue != null && notesValue instanceof NullNode == false) {
                                    String notesInstance;
                                    notesInstance = notesValue.getTextValue();
                                    propertiesInstance.setNotes(notesInstance);
                                }
                            }
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                managementLockObjectInstance.setId(idInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                managementLockObjectInstance.setType(typeInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                managementLockObjectInstance.setName(nameInstance);
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
