/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.Provider;
import com.microsoft.azure.management.resources.models.ProviderGetResult;
import com.microsoft.azure.management.resources.models.ProviderListParameters;
import com.microsoft.azure.management.resources.models.ProviderListResult;
import com.microsoft.azure.management.resources.models.ProviderRegistionResult;
import com.microsoft.azure.management.resources.models.ProviderResourceType;
import com.microsoft.azure.management.resources.models.ProviderUnregistionResult;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Operations for managing providers.
*/
public class ProviderOperationsImpl implements ServiceOperations<ResourceManagementClientImpl>, ProviderOperations {
    /**
    * Initializes a new instance of the ProviderOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    ProviderOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }
    
    private ResourceManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.resources.ResourceManagementClientImpl.
    * @return The Client value.
    */
    public ResourceManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Gets a resource provider.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @return Resource provider information.
    */
    @Override
    public Future<ProviderGetResult> getAsync(final String resourceProviderNamespace) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderGetResult>() { 
            @Override
            public ProviderGetResult call() throws Exception {
                return get(resourceProviderNamespace);
            }
         });
    }
    
    /**
    * Gets a resource provider.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Resource provider information.
    */
    @Override
    public ProviderGetResult get(String resourceProviderNamespace) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceProviderNamespace == null) {
            throw new NullPointerException("resourceProviderNamespace");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceProviderNamespace", resourceProviderNamespace);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + URLEncoder.encode(resourceProviderNamespace, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProviderGetResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderGetResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    Provider providerInstance = new Provider();
                    result.setProvider(providerInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        providerInstance.setId(idInstance);
                    }
                    
                    JsonNode namespaceValue = responseDoc.get("namespace");
                    if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                        String namespaceInstance;
                        namespaceInstance = namespaceValue.getTextValue();
                        providerInstance.setNamespace(namespaceInstance);
                    }
                    
                    JsonNode registrationStateValue = responseDoc.get("registrationState");
                    if (registrationStateValue != null && registrationStateValue instanceof NullNode == false) {
                        String registrationStateInstance;
                        registrationStateInstance = registrationStateValue.getTextValue();
                        providerInstance.setRegistrationState(registrationStateInstance);
                    }
                    
                    JsonNode resourceTypesArray = responseDoc.get("resourceTypes");
                    if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                        for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                            ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                            providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                            
                            JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                            if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                String resourceTypeInstance;
                                resourceTypeInstance = resourceTypeValue.getTextValue();
                                providerResourceTypeInstance.setName(resourceTypeInstance);
                            }
                            
                            JsonNode locationsArray = resourceTypesValue.get("locations");
                            if (locationsArray != null && locationsArray instanceof NullNode == false) {
                                for (JsonNode locationsValue : ((ArrayNode) locationsArray)) {
                                    providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                }
                            }
                            
                            JsonNode apiVersionsArray = resourceTypesValue.get("apiVersions");
                            if (apiVersionsArray != null && apiVersionsArray instanceof NullNode == false) {
                                for (JsonNode apiVersionsValue : ((ArrayNode) apiVersionsArray)) {
                                    providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                }
                            }
                            
                            JsonNode propertiesSequenceElement = ((JsonNode) resourceTypesValue.get("properties"));
                            if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = propertiesSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String propertiesKey = property.getKey();
                                    String propertiesValue = property.getValue().getTextValue();
                                    providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a list of resource providers.
    *
    * @param parameters Optional. Query parameters. If null is passed returns
    * all deployments.
    * @return List of resource providers.
    */
    @Override
    public Future<ProviderListResult> listAsync(final ProviderListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderListResult>() { 
            @Override
            public ProviderListResult call() throws Exception {
                return list(parameters);
            }
         });
    }
    
    /**
    * Gets a list of resource providers.
    *
    * @param parameters Optional. Query parameters. If null is passed returns
    * all deployments.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of resource providers.
    */
    @Override
    public ProviderListResult list(ProviderListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers";
        ArrayList<String> queryParameters = new ArrayList<String>();
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProviderListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            Provider providerInstance = new Provider();
                            result.getProviders().add(providerInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                providerInstance.setId(idInstance);
                            }
                            
                            JsonNode namespaceValue = valueValue.get("namespace");
                            if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                String namespaceInstance;
                                namespaceInstance = namespaceValue.getTextValue();
                                providerInstance.setNamespace(namespaceInstance);
                            }
                            
                            JsonNode registrationStateValue = valueValue.get("registrationState");
                            if (registrationStateValue != null && registrationStateValue instanceof NullNode == false) {
                                String registrationStateInstance;
                                registrationStateInstance = registrationStateValue.getTextValue();
                                providerInstance.setRegistrationState(registrationStateInstance);
                            }
                            
                            JsonNode resourceTypesArray = valueValue.get("resourceTypes");
                            if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                                for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                                    ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                    providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                    
                                    JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                    if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                        String resourceTypeInstance;
                                        resourceTypeInstance = resourceTypeValue.getTextValue();
                                        providerResourceTypeInstance.setName(resourceTypeInstance);
                                    }
                                    
                                    JsonNode locationsArray = resourceTypesValue.get("locations");
                                    if (locationsArray != null && locationsArray instanceof NullNode == false) {
                                        for (JsonNode locationsValue : ((ArrayNode) locationsArray)) {
                                            providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                        }
                                    }
                                    
                                    JsonNode apiVersionsArray = resourceTypesValue.get("apiVersions");
                                    if (apiVersionsArray != null && apiVersionsArray instanceof NullNode == false) {
                                        for (JsonNode apiVersionsValue : ((ArrayNode) apiVersionsArray)) {
                                            providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                        }
                                    }
                                    
                                    JsonNode propertiesSequenceElement = ((JsonNode) resourceTypesValue.get("properties"));
                                    if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr = propertiesSequenceElement.getFields();
                                        while (itr.hasNext()) {
                                            Map.Entry<String, JsonNode> property = itr.next();
                                            String propertiesKey = property.getKey();
                                            String propertiesValue = property.getValue().getTextValue();
                                            providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return List of resource providers.
    */
    @Override
    public Future<ProviderListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderListResult>() { 
            @Override
            public ProviderListResult call() throws Exception {
                return listNext(nextLink);
            }
         });
    }
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of resource providers.
    */
    @Override
    public ProviderListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter(invocationId, this, "listNextAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProviderListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            Provider providerInstance = new Provider();
                            result.getProviders().add(providerInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                providerInstance.setId(idInstance);
                            }
                            
                            JsonNode namespaceValue = valueValue.get("namespace");
                            if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                String namespaceInstance;
                                namespaceInstance = namespaceValue.getTextValue();
                                providerInstance.setNamespace(namespaceInstance);
                            }
                            
                            JsonNode registrationStateValue = valueValue.get("registrationState");
                            if (registrationStateValue != null && registrationStateValue instanceof NullNode == false) {
                                String registrationStateInstance;
                                registrationStateInstance = registrationStateValue.getTextValue();
                                providerInstance.setRegistrationState(registrationStateInstance);
                            }
                            
                            JsonNode resourceTypesArray = valueValue.get("resourceTypes");
                            if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                                for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                                    ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                    providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                    
                                    JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                    if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                        String resourceTypeInstance;
                                        resourceTypeInstance = resourceTypeValue.getTextValue();
                                        providerResourceTypeInstance.setName(resourceTypeInstance);
                                    }
                                    
                                    JsonNode locationsArray = resourceTypesValue.get("locations");
                                    if (locationsArray != null && locationsArray instanceof NullNode == false) {
                                        for (JsonNode locationsValue : ((ArrayNode) locationsArray)) {
                                            providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                        }
                                    }
                                    
                                    JsonNode apiVersionsArray = resourceTypesValue.get("apiVersions");
                                    if (apiVersionsArray != null && apiVersionsArray instanceof NullNode == false) {
                                        for (JsonNode apiVersionsValue : ((ArrayNode) apiVersionsArray)) {
                                            providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                        }
                                    }
                                    
                                    JsonNode propertiesSequenceElement = ((JsonNode) resourceTypesValue.get("properties"));
                                    if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr = propertiesSequenceElement.getFields();
                                        while (itr.hasNext()) {
                                            Map.Entry<String, JsonNode> property = itr.next();
                                            String propertiesKey = property.getKey();
                                            String propertiesValue = property.getValue().getTextValue();
                                            providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Registers provider to be used with a subscription.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @return Resource provider registration information.
    */
    @Override
    public Future<ProviderRegistionResult> registerAsync(final String resourceProviderNamespace) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderRegistionResult>() { 
            @Override
            public ProviderRegistionResult call() throws Exception {
                return register(resourceProviderNamespace);
            }
         });
    }
    
    /**
    * Registers provider to be used with a subscription.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Resource provider registration information.
    */
    @Override
    public ProviderRegistionResult register(String resourceProviderNamespace) throws IOException, ServiceException {
        // Validate
        if (resourceProviderNamespace == null) {
            throw new NullPointerException("resourceProviderNamespace");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceProviderNamespace", resourceProviderNamespace);
            CloudTracing.enter(invocationId, this, "registerAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + URLEncoder.encode(resourceProviderNamespace, "UTF-8");
        url = url + "/register";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProviderRegistionResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderRegistionResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    Provider providerInstance = new Provider();
                    result.setProvider(providerInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        providerInstance.setId(idInstance);
                    }
                    
                    JsonNode namespaceValue = responseDoc.get("namespace");
                    if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                        String namespaceInstance;
                        namespaceInstance = namespaceValue.getTextValue();
                        providerInstance.setNamespace(namespaceInstance);
                    }
                    
                    JsonNode registrationStateValue = responseDoc.get("registrationState");
                    if (registrationStateValue != null && registrationStateValue instanceof NullNode == false) {
                        String registrationStateInstance;
                        registrationStateInstance = registrationStateValue.getTextValue();
                        providerInstance.setRegistrationState(registrationStateInstance);
                    }
                    
                    JsonNode resourceTypesArray = responseDoc.get("resourceTypes");
                    if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                        for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                            ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                            providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                            
                            JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                            if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                String resourceTypeInstance;
                                resourceTypeInstance = resourceTypeValue.getTextValue();
                                providerResourceTypeInstance.setName(resourceTypeInstance);
                            }
                            
                            JsonNode locationsArray = resourceTypesValue.get("locations");
                            if (locationsArray != null && locationsArray instanceof NullNode == false) {
                                for (JsonNode locationsValue : ((ArrayNode) locationsArray)) {
                                    providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                }
                            }
                            
                            JsonNode apiVersionsArray = resourceTypesValue.get("apiVersions");
                            if (apiVersionsArray != null && apiVersionsArray instanceof NullNode == false) {
                                for (JsonNode apiVersionsValue : ((ArrayNode) apiVersionsArray)) {
                                    providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                }
                            }
                            
                            JsonNode propertiesSequenceElement = ((JsonNode) resourceTypesValue.get("properties"));
                            if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = propertiesSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String propertiesKey = property.getKey();
                                    String propertiesValue = property.getValue().getTextValue();
                                    providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Unregisters provider from a subscription.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @return Resource provider registration information.
    */
    @Override
    public Future<ProviderUnregistionResult> unregisterAsync(final String resourceProviderNamespace) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderUnregistionResult>() { 
            @Override
            public ProviderUnregistionResult call() throws Exception {
                return unregister(resourceProviderNamespace);
            }
         });
    }
    
    /**
    * Unregisters provider from a subscription.
    *
    * @param resourceProviderNamespace Required. Namespace of the resource
    * provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Resource provider registration information.
    */
    @Override
    public ProviderUnregistionResult unregister(String resourceProviderNamespace) throws IOException, ServiceException {
        // Validate
        if (resourceProviderNamespace == null) {
            throw new NullPointerException("resourceProviderNamespace");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceProviderNamespace", resourceProviderNamespace);
            CloudTracing.enter(invocationId, this, "unregisterAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + URLEncoder.encode(resourceProviderNamespace, "UTF-8");
        url = url + "/unregister";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ProviderUnregistionResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderUnregistionResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    Provider providerInstance = new Provider();
                    result.setProvider(providerInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        providerInstance.setId(idInstance);
                    }
                    
                    JsonNode namespaceValue = responseDoc.get("namespace");
                    if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                        String namespaceInstance;
                        namespaceInstance = namespaceValue.getTextValue();
                        providerInstance.setNamespace(namespaceInstance);
                    }
                    
                    JsonNode registrationStateValue = responseDoc.get("registrationState");
                    if (registrationStateValue != null && registrationStateValue instanceof NullNode == false) {
                        String registrationStateInstance;
                        registrationStateInstance = registrationStateValue.getTextValue();
                        providerInstance.setRegistrationState(registrationStateInstance);
                    }
                    
                    JsonNode resourceTypesArray = responseDoc.get("resourceTypes");
                    if (resourceTypesArray != null && resourceTypesArray instanceof NullNode == false) {
                        for (JsonNode resourceTypesValue : ((ArrayNode) resourceTypesArray)) {
                            ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                            providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                            
                            JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                            if (resourceTypeValue != null && resourceTypeValue instanceof NullNode == false) {
                                String resourceTypeInstance;
                                resourceTypeInstance = resourceTypeValue.getTextValue();
                                providerResourceTypeInstance.setName(resourceTypeInstance);
                            }
                            
                            JsonNode locationsArray = resourceTypesValue.get("locations");
                            if (locationsArray != null && locationsArray instanceof NullNode == false) {
                                for (JsonNode locationsValue : ((ArrayNode) locationsArray)) {
                                    providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                }
                            }
                            
                            JsonNode apiVersionsArray = resourceTypesValue.get("apiVersions");
                            if (apiVersionsArray != null && apiVersionsArray instanceof NullNode == false) {
                                for (JsonNode apiVersionsValue : ((ArrayNode) apiVersionsArray)) {
                                    providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                }
                            }
                            
                            JsonNode propertiesSequenceElement = ((JsonNode) resourceTypesValue.get("properties"));
                            if (propertiesSequenceElement != null && propertiesSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = propertiesSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String propertiesKey = property.getKey();
                                    String propertiesValue = property.getValue().getTextValue();
                                    providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
