/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.GenericResource;
import com.microsoft.azure.management.resources.models.GenericResourceExtended;
import com.microsoft.azure.management.resources.models.LongRunningOperationResponse;
import com.microsoft.azure.management.resources.models.Plan;
import com.microsoft.azure.management.resources.models.ResourceCreateOrUpdateResult;
import com.microsoft.azure.management.resources.models.ResourceExistsResult;
import com.microsoft.azure.management.resources.models.ResourceGetResult;
import com.microsoft.azure.management.resources.models.ResourceListParameters;
import com.microsoft.azure.management.resources.models.ResourceListResult;
import com.microsoft.azure.management.resources.models.ResourcesMoveInfo;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ResourceIdentity;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

/**
* Operations for managing resources.
*/
public class ResourceOperationsImpl implements ServiceOperations<ResourceManagementClientImpl>, ResourceOperations {
    /**
    * Initializes a new instance of the ResourceOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    ResourceOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }
    
    private ResourceManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.resources.ResourceManagementClientImpl.
    * @return The Client value.
    */
    public ResourceManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Begin moving resources.To determine whether the operation has finished
    * processing the request, call GetLongRunningOperationStatus.
    *
    * @param sourceResourceGroupName Required. Source resource group name.
    * @param parameters Required. move resources' parameters.
    * @return A standard service response for long running operations.
    */
    @Override
    public Future<LongRunningOperationResponse> beginMovingAsync(final String sourceResourceGroupName, final ResourcesMoveInfo parameters) {
        return this.getClient().getExecutorService().submit(new Callable<LongRunningOperationResponse>() { 
            @Override
            public LongRunningOperationResponse call() throws Exception {
                return beginMoving(sourceResourceGroupName, parameters);
            }
         });
    }
    
    /**
    * Begin moving resources.To determine whether the operation has finished
    * processing the request, call GetLongRunningOperationStatus.
    *
    * @param sourceResourceGroupName Required. Source resource group name.
    * @param parameters Required. move resources' parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response for long running operations.
    */
    @Override
    public LongRunningOperationResponse beginMoving(String sourceResourceGroupName, ResourcesMoveInfo parameters) throws IOException, ServiceException {
        // Validate
        if (sourceResourceGroupName == null) {
            throw new NullPointerException("sourceResourceGroupName");
        }
        if (sourceResourceGroupName != null && sourceResourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("sourceResourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", sourceResourceGroupName) == false) {
            throw new IllegalArgumentException("sourceResourceGroupName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("sourceResourceGroupName", sourceResourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginMovingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(sourceResourceGroupName, "UTF-8");
        url = url + "/moveResources";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            LongRunningOperationResponse result = null;
            // Deserialize Response
            result = new LongRunningOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Location").length > 0) {
                result.setOperationStatusLink(httpResponse.getFirstHeader("Location").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_CONFLICT) {
                result.setStatus(OperationStatus.Failed);
            }
            if (statusCode == HttpStatus.SC_ACCEPTED) {
                result.setStatus(OperationStatus.InProgress);
            }
            if (statusCode == HttpStatus.SC_NO_CONTENT) {
                result.setStatus(OperationStatus.Succeeded);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Checks whether resource exists.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param identity Required. Resource identity.
    * @return Resource group information.
    */
    @Override
    public Future<ResourceExistsResult> checkExistenceAsync(final String resourceGroupName, final ResourceIdentity identity) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceExistsResult>() { 
            @Override
            public ResourceExistsResult call() throws Exception {
                return checkExistence(resourceGroupName, identity);
            }
         });
    }
    
    /**
    * Checks whether resource exists.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param identity Required. Resource identity.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Resource group information.
    */
    @Override
    public ResourceExistsResult checkExistence(String resourceGroupName, ResourceIdentity identity) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("identity", identity);
            CloudTracing.enter(invocationId, this, "checkExistenceAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/";
        if (identity.getParentResourcePath() != null) {
            url = url + identity.getParentResourcePath();
        }
        url = url + "/";
        url = url + identity.getResourceType();
        url = url + "/";
        url = url + URLEncoder.encode(identity.getResourceName(), "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + URLEncoder.encode(identity.getResourceProviderApiVersion(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_NOT_FOUND) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ResourceExistsResult result = null;
            // Deserialize Response
            result = new ResourceExistsResult();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_OK) {
                result.setExists(true);
            } else {
                result.setExists(false);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Create a resource.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param identity Required. Resource identity.
    * @param parameters Required. Create or update resource parameters.
    * @return Resource information.
    */
    @Override
    public Future<ResourceCreateOrUpdateResult> createOrUpdateAsync(final String resourceGroupName, final ResourceIdentity identity, final GenericResource parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceCreateOrUpdateResult>() { 
            @Override
            public ResourceCreateOrUpdateResult call() throws Exception {
                return createOrUpdate(resourceGroupName, identity, parameters);
            }
         });
    }
    
    /**
    * Create a resource.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param identity Required. Resource identity.
    * @param parameters Required. Create or update resource parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Resource information.
    */
    @Override
    public ResourceCreateOrUpdateResult createOrUpdate(String resourceGroupName, ResourceIdentity identity, GenericResource parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("identity", identity);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/";
        if (identity.getParentResourcePath() != null) {
            url = url + identity.getParentResourcePath();
        }
        url = url + "/";
        url = url + identity.getResourceType();
        url = url + "/";
        url = url + URLEncoder.encode(identity.getResourceName(), "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + URLEncoder.encode(identity.getResourceProviderApiVersion(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode genericResourceValue = objectMapper.createObjectNode();
        requestDoc = genericResourceValue;
        
        if (parameters.getProperties() != null) {
            ((ObjectNode) genericResourceValue).put("properties", objectMapper.readTree(parameters.getProperties()));
        }
        
        if (parameters.getProvisioningState() != null) {
            ((ObjectNode) genericResourceValue).put("provisioningState", parameters.getProvisioningState());
        }
        
        if (parameters.getPlan() != null) {
            ObjectNode planValue = objectMapper.createObjectNode();
            ((ObjectNode) genericResourceValue).put("plan", planValue);
            
            if (parameters.getPlan().getName() != null) {
                ((ObjectNode) planValue).put("name", parameters.getPlan().getName());
            }
            
            if (parameters.getPlan().getPublisher() != null) {
                ((ObjectNode) planValue).put("publisher", parameters.getPlan().getPublisher());
            }
            
            if (parameters.getPlan().getProduct() != null) {
                ((ObjectNode) planValue).put("product", parameters.getPlan().getProduct());
            }
            
            if (parameters.getPlan().getPromotionCode() != null) {
                ((ObjectNode) planValue).put("promotionCode", parameters.getPlan().getPromotionCode());
            }
        }
        
        ((ObjectNode) genericResourceValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) genericResourceValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ResourceCreateOrUpdateResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceCreateOrUpdateResult();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    GenericResourceExtended resourceInstance = new GenericResourceExtended();
                    result.setResource(resourceInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            resourceInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        String propertiesInstance;
                        propertiesInstance = propertiesValue2.getTextValue();
                        resourceInstance.setProperties(propertiesInstance);
                    }
                    
                    JsonNode provisioningStateValue2 = responseDoc.get("provisioningState");
                    if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                        String provisioningStateInstance2;
                        provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                        resourceInstance.setProvisioningState(provisioningStateInstance2);
                    }
                    
                    JsonNode planValue2 = responseDoc.get("plan");
                    if (planValue2 != null && planValue2 instanceof NullNode == false) {
                        Plan planInstance = new Plan();
                        resourceInstance.setPlan(planInstance);
                        
                        JsonNode nameValue = planValue2.get("name");
                        if (nameValue != null && nameValue instanceof NullNode == false) {
                            String nameInstance;
                            nameInstance = nameValue.getTextValue();
                            planInstance.setName(nameInstance);
                        }
                        
                        JsonNode publisherValue = planValue2.get("publisher");
                        if (publisherValue != null && publisherValue instanceof NullNode == false) {
                            String publisherInstance;
                            publisherInstance = publisherValue.getTextValue();
                            planInstance.setPublisher(publisherInstance);
                        }
                        
                        JsonNode productValue = planValue2.get("product");
                        if (productValue != null && productValue instanceof NullNode == false) {
                            String productInstance;
                            productInstance = productValue.getTextValue();
                            planInstance.setProduct(productInstance);
                        }
                        
                        JsonNode promotionCodeValue = planValue2.get("promotionCode");
                        if (promotionCodeValue != null && promotionCodeValue instanceof NullNode == false) {
                            String promotionCodeInstance;
                            promotionCodeInstance = promotionCodeValue.getTextValue();
                            planInstance.setPromotionCode(promotionCodeInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        resourceInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        resourceInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            resourceInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Delete resource and all of its resources.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param identity Required. Resource identity.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final ResourceIdentity identity) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, identity);
            }
         });
    }
    
    /**
    * Delete resource and all of its resources.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param identity Required. Resource identity.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, ResourceIdentity identity) throws InterruptedException, ExecutionException, IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("identity", identity);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/";
        if (identity.getParentResourcePath() != null) {
            url = url + identity.getParentResourcePath();
        }
        url = url + "/";
        url = url + identity.getResourceType();
        url = url + "/";
        url = url + URLEncoder.encode(identity.getResourceName(), "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + URLEncoder.encode(identity.getResourceProviderApiVersion(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns a resource belonging to a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param identity Required. Resource identity.
    * @return Resource information.
    */
    @Override
    public Future<ResourceGetResult> getAsync(final String resourceGroupName, final ResourceIdentity identity) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceGetResult>() { 
            @Override
            public ResourceGetResult call() throws Exception {
                return get(resourceGroupName, identity);
            }
         });
    }
    
    /**
    * Returns a resource belonging to a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param identity Required. Resource identity.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Resource information.
    */
    @Override
    public ResourceGetResult get(String resourceGroupName, ResourceIdentity identity) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (Pattern.matches("^[-\\w\\._]+$", resourceGroupName) == false) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("identity", identity);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/";
        if (identity.getParentResourcePath() != null) {
            url = url + identity.getParentResourcePath();
        }
        url = url + "/";
        url = url + identity.getResourceType();
        url = url + "/";
        url = url + URLEncoder.encode(identity.getResourceName(), "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + URLEncoder.encode(identity.getResourceProviderApiVersion(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ResourceGetResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_NO_CONTENT) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceGetResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    GenericResourceExtended resourceInstance = new GenericResourceExtended();
                    result.setResource(resourceInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            resourceInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        String propertiesInstance;
                        propertiesInstance = propertiesValue2.getTextValue();
                        resourceInstance.setProperties(propertiesInstance);
                    }
                    
                    JsonNode provisioningStateValue2 = responseDoc.get("provisioningState");
                    if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                        String provisioningStateInstance2;
                        provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                        resourceInstance.setProvisioningState(provisioningStateInstance2);
                    }
                    
                    JsonNode planValue = responseDoc.get("plan");
                    if (planValue != null && planValue instanceof NullNode == false) {
                        Plan planInstance = new Plan();
                        resourceInstance.setPlan(planInstance);
                        
                        JsonNode nameValue = planValue.get("name");
                        if (nameValue != null && nameValue instanceof NullNode == false) {
                            String nameInstance;
                            nameInstance = nameValue.getTextValue();
                            planInstance.setName(nameInstance);
                        }
                        
                        JsonNode publisherValue = planValue.get("publisher");
                        if (publisherValue != null && publisherValue instanceof NullNode == false) {
                            String publisherInstance;
                            publisherInstance = publisherValue.getTextValue();
                            planInstance.setPublisher(publisherInstance);
                        }
                        
                        JsonNode productValue = planValue.get("product");
                        if (productValue != null && productValue instanceof NullNode == false) {
                            String productInstance;
                            productInstance = productValue.getTextValue();
                            planInstance.setProduct(productInstance);
                        }
                        
                        JsonNode promotionCodeValue = planValue.get("promotionCode");
                        if (promotionCodeValue != null && promotionCodeValue instanceof NullNode == false) {
                            String promotionCodeInstance;
                            promotionCodeInstance = promotionCodeValue.getTextValue();
                            planInstance.setPromotionCode(promotionCodeInstance);
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        resourceInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        resourceInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            resourceInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get all of the resources under a subscription.
    *
    * @param parameters Optional. Query parameters. If null is passed returns
    * all resource groups.
    * @return List of resource groups.
    */
    @Override
    public Future<ResourceListResult> listAsync(final ResourceListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceListResult>() { 
            @Override
            public ResourceListResult call() throws Exception {
                return list(parameters);
            }
         });
    }
    
    /**
    * Get all of the resources under a subscription.
    *
    * @param parameters Optional. Query parameters. If null is passed returns
    * all resource groups.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of resource groups.
    */
    @Override
    public ResourceListResult list(ResourceListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/";
        if (parameters != null && parameters.getResourceGroupName() != null) {
            url = url + "resourceGroups/" + URLEncoder.encode(parameters.getResourceGroupName(), "UTF-8") + "/";
        }
        url = url + "resources";
        ArrayList<String> queryParameters = new ArrayList<String>();
        ArrayList<String> odataFilter = new ArrayList<String>();
        if (parameters != null && parameters.getResourceType() != null) {
            odataFilter.add("resourceType eq '" + URLEncoder.encode(parameters.getResourceType(), "UTF-8") + "'");
        }
        if (parameters != null && parameters.getTagName() != null) {
            odataFilter.add("tagname eq '" + URLEncoder.encode(parameters.getTagName(), "UTF-8") + "'");
        }
        if (parameters != null && parameters.getTagValue() != null) {
            odataFilter.add("tagvalue eq '" + URLEncoder.encode(parameters.getTagValue(), "UTF-8") + "'");
        }
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, " and "));
        }
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ResourceListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            GenericResourceExtended resourceJsonFormatInstance = new GenericResourceExtended();
                            result.getResources().add(resourceJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    resourceJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            
                            JsonNode propertiesValue2 = valueValue.get("properties");
                            if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                String propertiesInstance;
                                propertiesInstance = propertiesValue2.getTextValue();
                                resourceJsonFormatInstance.setProperties(propertiesInstance);
                            }
                            
                            JsonNode provisioningStateValue2 = valueValue.get("provisioningState");
                            if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                String provisioningStateInstance2;
                                provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                resourceJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                            }
                            
                            JsonNode planValue = valueValue.get("plan");
                            if (planValue != null && planValue instanceof NullNode == false) {
                                Plan planInstance = new Plan();
                                resourceJsonFormatInstance.setPlan(planInstance);
                                
                                JsonNode nameValue = planValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    planInstance.setName(nameInstance);
                                }
                                
                                JsonNode publisherValue = planValue.get("publisher");
                                if (publisherValue != null && publisherValue instanceof NullNode == false) {
                                    String publisherInstance;
                                    publisherInstance = publisherValue.getTextValue();
                                    planInstance.setPublisher(publisherInstance);
                                }
                                
                                JsonNode productValue = planValue.get("product");
                                if (productValue != null && productValue instanceof NullNode == false) {
                                    String productInstance;
                                    productInstance = productValue.getTextValue();
                                    planInstance.setProduct(productInstance);
                                }
                                
                                JsonNode promotionCodeValue = planValue.get("promotionCode");
                                if (promotionCodeValue != null && promotionCodeValue instanceof NullNode == false) {
                                    String promotionCodeInstance;
                                    promotionCodeInstance = promotionCodeValue.getTextValue();
                                    planInstance.setPromotionCode(promotionCodeInstance);
                                }
                            }
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                resourceJsonFormatInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue2 = valueValue.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                resourceJsonFormatInstance.setName(nameInstance2);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                resourceJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                resourceJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    resourceJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return List of resource groups.
    */
    @Override
    public Future<ResourceListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceListResult>() { 
            @Override
            public ResourceListResult call() throws Exception {
                return listNext(nextLink);
            }
         });
    }
    
    /**
    * Get a list of deployments.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of resource groups.
    */
    @Override
    public ResourceListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter(invocationId, this, "listNextAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ResourceListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            GenericResourceExtended resourceJsonFormatInstance = new GenericResourceExtended();
                            result.getResources().add(resourceJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    resourceJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            
                            JsonNode propertiesValue2 = valueValue.get("properties");
                            if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                String propertiesInstance;
                                propertiesInstance = propertiesValue2.getTextValue();
                                resourceJsonFormatInstance.setProperties(propertiesInstance);
                            }
                            
                            JsonNode provisioningStateValue2 = valueValue.get("provisioningState");
                            if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                String provisioningStateInstance2;
                                provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                resourceJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                            }
                            
                            JsonNode planValue = valueValue.get("plan");
                            if (planValue != null && planValue instanceof NullNode == false) {
                                Plan planInstance = new Plan();
                                resourceJsonFormatInstance.setPlan(planInstance);
                                
                                JsonNode nameValue = planValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    planInstance.setName(nameInstance);
                                }
                                
                                JsonNode publisherValue = planValue.get("publisher");
                                if (publisherValue != null && publisherValue instanceof NullNode == false) {
                                    String publisherInstance;
                                    publisherInstance = publisherValue.getTextValue();
                                    planInstance.setPublisher(publisherInstance);
                                }
                                
                                JsonNode productValue = planValue.get("product");
                                if (productValue != null && productValue instanceof NullNode == false) {
                                    String productInstance;
                                    productInstance = productValue.getTextValue();
                                    planInstance.setProduct(productInstance);
                                }
                                
                                JsonNode promotionCodeValue = planValue.get("promotionCode");
                                if (promotionCodeValue != null && promotionCodeValue instanceof NullNode == false) {
                                    String promotionCodeInstance;
                                    promotionCodeInstance = promotionCodeValue.getTextValue();
                                    planInstance.setPromotionCode(promotionCodeInstance);
                                }
                            }
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                resourceJsonFormatInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue2 = valueValue.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                resourceJsonFormatInstance.setName(nameInstance2);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                resourceJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                resourceJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    resourceJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Move resources within or across subscriptions.
    *
    * @param sourceResourceGroupName Required. Source resource group name.
    * @param parameters Required. move resources' parameters.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> moveResourcesAsync(final String sourceResourceGroupName, final ResourcesMoveInfo parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return moveResources(sourceResourceGroupName, parameters);
            }
         });
    }
    
    /**
    * Move resources within or across subscriptions.
    *
    * @param sourceResourceGroupName Required. Source resource group name.
    * @param parameters Required. move resources' parameters.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse moveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) throws InterruptedException, ExecutionException, IOException {
        ResourceManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("sourceResourceGroupName", sourceResourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "moveResourcesAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            LongRunningOperationResponse response = client2.getResourcesOperations().beginMovingAsync(sourceResourceGroupName, parameters).get();
            LongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getOperationStatusLink()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getOperationStatusLink()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}
