/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.ResourceProviderOperationDefinition;
import com.microsoft.azure.management.resources.models.ResourceProviderOperationDetailListResult;
import com.microsoft.azure.management.resources.models.ResourceProviderOperationDisplayProperties;
import com.microsoft.windowsazure.core.ResourceIdentity;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Operations for managing Resource provider operations.
*/
public class ResourceProviderOperationDetailsOperationsImpl implements ServiceOperations<ResourceManagementClientImpl>, ResourceProviderOperationDetailsOperations {
    /**
    * Initializes a new instance of the
    * ResourceProviderOperationDetailsOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    ResourceProviderOperationDetailsOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }
    
    private ResourceManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.resources.ResourceManagementClientImpl.
    * @return The Client value.
    */
    public ResourceManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Gets a list of resource providers.
    *
    * @param identity Required. Resource identity.
    * @return List of resource provider operations.
    */
    @Override
    public Future<ResourceProviderOperationDetailListResult> listAsync(final ResourceIdentity identity) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceProviderOperationDetailListResult>() { 
            @Override
            public ResourceProviderOperationDetailListResult call() throws Exception {
                return list(identity);
            }
         });
    }
    
    /**
    * Gets a list of resource providers.
    *
    * @param identity Required. Resource identity.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of resource provider operations.
    */
    @Override
    public ResourceProviderOperationDetailListResult list(ResourceIdentity identity) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("identity", identity);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/operations";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + URLEncoder.encode(identity.getResourceProviderApiVersion(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ResourceProviderOperationDetailListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_NO_CONTENT) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceProviderOperationDetailListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            ResourceProviderOperationDefinition resourceProviderOperationDefinitionInstance = new ResourceProviderOperationDefinition();
                            result.getResourceProviderOperationDetails().add(resourceProviderOperationDefinitionInstance);
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                resourceProviderOperationDefinitionInstance.setName(nameInstance);
                            }
                            
                            JsonNode displayValue = valueValue.get("display");
                            if (displayValue != null && displayValue instanceof NullNode == false) {
                                ResourceProviderOperationDisplayProperties displayInstance = new ResourceProviderOperationDisplayProperties();
                                resourceProviderOperationDefinitionInstance.setResourceProviderOperationDisplayProperties(displayInstance);
                                
                                JsonNode publisherValue = displayValue.get("publisher");
                                if (publisherValue != null && publisherValue instanceof NullNode == false) {
                                    String publisherInstance;
                                    publisherInstance = publisherValue.getTextValue();
                                    displayInstance.setPublisher(publisherInstance);
                                }
                                
                                JsonNode providerValue = displayValue.get("provider");
                                if (providerValue != null && providerValue instanceof NullNode == false) {
                                    String providerInstance;
                                    providerInstance = providerValue.getTextValue();
                                    displayInstance.setProvider(providerInstance);
                                }
                                
                                JsonNode resourceValue = displayValue.get("resource");
                                if (resourceValue != null && resourceValue instanceof NullNode == false) {
                                    String resourceInstance;
                                    resourceInstance = resourceValue.getTextValue();
                                    displayInstance.setResource(resourceInstance);
                                }
                                
                                JsonNode operationValue = displayValue.get("operation");
                                if (operationValue != null && operationValue instanceof NullNode == false) {
                                    String operationInstance;
                                    operationInstance = operationValue.getTextValue();
                                    displayInstance.setOperation(operationInstance);
                                }
                                
                                JsonNode descriptionValue = displayValue.get("description");
                                if (descriptionValue != null && descriptionValue instanceof NullNode == false) {
                                    String descriptionInstance;
                                    descriptionInstance = descriptionValue.getTextValue();
                                    displayInstance.setDescription(descriptionInstance);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
