/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.TagCount;
import com.microsoft.azure.management.resources.models.TagCreateResult;
import com.microsoft.azure.management.resources.models.TagCreateValueResult;
import com.microsoft.azure.management.resources.models.TagDetails;
import com.microsoft.azure.management.resources.models.TagValue;
import com.microsoft.azure.management.resources.models.TagsListResult;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Operations for managing tags.
*/
public class TagOperationsImpl implements ServiceOperations<ResourceManagementClientImpl>, TagOperations {
    /**
    * Initializes a new instance of the TagOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    TagOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }
    
    private ResourceManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.resources.ResourceManagementClientImpl.
    * @return The Client value.
    */
    public ResourceManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Create a subscription resource tag.
    *
    * @param tagName Required. The name of the tag.
    * @return Tag information.
    */
    @Override
    public Future<TagCreateResult> createOrUpdateAsync(final String tagName) {
        return this.getClient().getExecutorService().submit(new Callable<TagCreateResult>() { 
            @Override
            public TagCreateResult call() throws Exception {
                return createOrUpdate(tagName);
            }
         });
    }
    
    /**
    * Create a subscription resource tag.
    *
    * @param tagName Required. The name of the tag.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Tag information.
    */
    @Override
    public TagCreateResult createOrUpdate(String tagName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (tagName == null) {
            throw new NullPointerException("tagName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("tagName", tagName);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/tagNames/";
        url = url + URLEncoder.encode(tagName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            TagCreateResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new TagCreateResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    TagDetails tagInstance = new TagDetails();
                    result.setTag(tagInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        tagInstance.setId(idInstance);
                    }
                    
                    JsonNode tagNameValue = responseDoc.get("tagName");
                    if (tagNameValue != null && tagNameValue instanceof NullNode == false) {
                        String tagNameInstance;
                        tagNameInstance = tagNameValue.getTextValue();
                        tagInstance.setName(tagNameInstance);
                    }
                    
                    JsonNode countValue = responseDoc.get("count");
                    if (countValue != null && countValue instanceof NullNode == false) {
                        TagCount countInstance = new TagCount();
                        tagInstance.setCount(countInstance);
                        
                        JsonNode typeValue = countValue.get("type");
                        if (typeValue != null && typeValue instanceof NullNode == false) {
                            String typeInstance;
                            typeInstance = typeValue.getTextValue();
                            countInstance.setType(typeInstance);
                        }
                        
                        JsonNode valueValue = countValue.get("value");
                        if (valueValue != null && valueValue instanceof NullNode == false) {
                            String valueInstance;
                            valueInstance = valueValue.getTextValue();
                            countInstance.setValue(valueInstance);
                        }
                    }
                    
                    JsonNode valuesArray = responseDoc.get("values");
                    if (valuesArray != null && valuesArray instanceof NullNode == false) {
                        for (JsonNode valuesValue : ((ArrayNode) valuesArray)) {
                            TagValue tagValueInstance = new TagValue();
                            tagInstance.getValues().add(tagValueInstance);
                            
                            JsonNode idValue2 = valuesValue.get("id");
                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                String idInstance2;
                                idInstance2 = idValue2.getTextValue();
                                tagValueInstance.setId(idInstance2);
                            }
                            
                            JsonNode tagValueValue = valuesValue.get("tagValue");
                            if (tagValueValue != null && tagValueValue instanceof NullNode == false) {
                                String tagValueInstance2;
                                tagValueInstance2 = tagValueValue.getTextValue();
                                tagValueInstance.setValue(tagValueInstance2);
                            }
                            
                            JsonNode countValue2 = valuesValue.get("count");
                            if (countValue2 != null && countValue2 instanceof NullNode == false) {
                                TagCount countInstance2 = new TagCount();
                                tagValueInstance.setCount(countInstance2);
                                
                                JsonNode typeValue2 = countValue2.get("type");
                                if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                    String typeInstance2;
                                    typeInstance2 = typeValue2.getTextValue();
                                    countInstance2.setType(typeInstance2);
                                }
                                
                                JsonNode valueValue2 = countValue2.get("value");
                                if (valueValue2 != null && valueValue2 instanceof NullNode == false) {
                                    String valueInstance2;
                                    valueInstance2 = valueValue2.getTextValue();
                                    countInstance2.setValue(valueInstance2);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Create a subscription resource tag value.
    *
    * @param tagName Required. The name of the tag.
    * @param tagValue Required. The value of the tag.
    * @return Tag information.
    */
    @Override
    public Future<TagCreateValueResult> createOrUpdateValueAsync(final String tagName, final String tagValue) {
        return this.getClient().getExecutorService().submit(new Callable<TagCreateValueResult>() { 
            @Override
            public TagCreateValueResult call() throws Exception {
                return createOrUpdateValue(tagName, tagValue);
            }
         });
    }
    
    /**
    * Create a subscription resource tag value.
    *
    * @param tagName Required. The name of the tag.
    * @param tagValue Required. The value of the tag.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Tag information.
    */
    @Override
    public TagCreateValueResult createOrUpdateValue(String tagName, String tagValue) throws IOException, ServiceException {
        // Validate
        if (tagName == null) {
            throw new NullPointerException("tagName");
        }
        if (tagValue == null) {
            throw new NullPointerException("tagValue");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("tagName", tagName);
            tracingParameters.put("tagValue", tagValue);
            CloudTracing.enter(invocationId, this, "createOrUpdateValueAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/tagNames/";
        url = url + URLEncoder.encode(tagName, "UTF-8");
        url = url + "/tagValues/";
        url = url + URLEncoder.encode(tagValue, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            TagCreateValueResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new TagCreateValueResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    TagValue valueInstance = new TagValue();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode tagValueValue = responseDoc.get("tagValue");
                    if (tagValueValue != null && tagValueValue instanceof NullNode == false) {
                        String tagValueInstance;
                        tagValueInstance = tagValueValue.getTextValue();
                        valueInstance.setValue(tagValueInstance);
                    }
                    
                    JsonNode countValue = responseDoc.get("count");
                    if (countValue != null && countValue instanceof NullNode == false) {
                        TagCount countInstance = new TagCount();
                        valueInstance.setCount(countInstance);
                        
                        JsonNode typeValue = countValue.get("type");
                        if (typeValue != null && typeValue instanceof NullNode == false) {
                            String typeInstance;
                            typeInstance = typeValue.getTextValue();
                            countInstance.setType(typeInstance);
                        }
                        
                        JsonNode valueValue = countValue.get("value");
                        if (valueValue != null && valueValue instanceof NullNode == false) {
                            String valueInstance2;
                            valueInstance2 = valueValue.getTextValue();
                            countInstance.setValue(valueInstance2);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Delete a subscription resource tag.
    *
    * @param tagName Required. The name of the tag.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String tagName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(tagName);
            }
         });
    }
    
    /**
    * Delete a subscription resource tag.
    *
    * @param tagName Required. The name of the tag.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String tagName) throws InterruptedException, ExecutionException, IOException, ServiceException {
        // Validate
        if (tagName == null) {
            throw new NullPointerException("tagName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("tagName", tagName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/tagNames/";
        url = url + URLEncoder.encode(tagName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Delete a subscription resource tag value.
    *
    * @param tagName Required. The name of the tag.
    * @param tagValue Required. The value of the tag.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteValueAsync(final String tagName, final String tagValue) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return deleteValue(tagName, tagValue);
            }
         });
    }
    
    /**
    * Delete a subscription resource tag value.
    *
    * @param tagName Required. The name of the tag.
    * @param tagValue Required. The value of the tag.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse deleteValue(String tagName, String tagValue) throws IOException, ServiceException {
        // Validate
        if (tagName == null) {
            throw new NullPointerException("tagName");
        }
        if (tagValue == null) {
            throw new NullPointerException("tagValue");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("tagName", tagName);
            tracingParameters.put("tagValue", tagValue);
            CloudTracing.enter(invocationId, this, "deleteValueAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/tagNames/";
        url = url + URLEncoder.encode(tagName, "UTF-8");
        url = url + "/tagValues/";
        url = url + URLEncoder.encode(tagValue, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get a list of subscription resource tags.
    *
    * @return List of subscription tags.
    */
    @Override
    public Future<TagsListResult> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<TagsListResult>() { 
            @Override
            public TagsListResult call() throws Exception {
                return list();
            }
         });
    }
    
    /**
    * Get a list of subscription resource tags.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of subscription tags.
    */
    @Override
    public TagsListResult list() throws IOException, ServiceException, URISyntaxException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/tagNames";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            TagsListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new TagsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            TagDetails tagDetailsInstance = new TagDetails();
                            result.getTags().add(tagDetailsInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                tagDetailsInstance.setId(idInstance);
                            }
                            
                            JsonNode tagNameValue = valueValue.get("tagName");
                            if (tagNameValue != null && tagNameValue instanceof NullNode == false) {
                                String tagNameInstance;
                                tagNameInstance = tagNameValue.getTextValue();
                                tagDetailsInstance.setName(tagNameInstance);
                            }
                            
                            JsonNode countValue = valueValue.get("count");
                            if (countValue != null && countValue instanceof NullNode == false) {
                                TagCount countInstance = new TagCount();
                                tagDetailsInstance.setCount(countInstance);
                                
                                JsonNode typeValue = countValue.get("type");
                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                    String typeInstance;
                                    typeInstance = typeValue.getTextValue();
                                    countInstance.setType(typeInstance);
                                }
                                
                                JsonNode valueValue2 = countValue.get("value");
                                if (valueValue2 != null && valueValue2 instanceof NullNode == false) {
                                    String valueInstance;
                                    valueInstance = valueValue2.getTextValue();
                                    countInstance.setValue(valueInstance);
                                }
                            }
                            
                            JsonNode valuesArray = valueValue.get("values");
                            if (valuesArray != null && valuesArray instanceof NullNode == false) {
                                for (JsonNode valuesValue : ((ArrayNode) valuesArray)) {
                                    TagValue tagValueInstance = new TagValue();
                                    tagDetailsInstance.getValues().add(tagValueInstance);
                                    
                                    JsonNode idValue2 = valuesValue.get("id");
                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                        String idInstance2;
                                        idInstance2 = idValue2.getTextValue();
                                        tagValueInstance.setId(idInstance2);
                                    }
                                    
                                    JsonNode tagValueValue = valuesValue.get("tagValue");
                                    if (tagValueValue != null && tagValueValue instanceof NullNode == false) {
                                        String tagValueInstance2;
                                        tagValueInstance2 = tagValueValue.getTextValue();
                                        tagValueInstance.setValue(tagValueInstance2);
                                    }
                                    
                                    JsonNode countValue2 = valuesValue.get("count");
                                    if (countValue2 != null && countValue2 instanceof NullNode == false) {
                                        TagCount countInstance2 = new TagCount();
                                        tagValueInstance.setCount(countInstance2);
                                        
                                        JsonNode typeValue2 = countValue2.get("type");
                                        if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                            String typeInstance2;
                                            typeInstance2 = typeValue2.getTextValue();
                                            countInstance2.setType(typeInstance2);
                                        }
                                        
                                        JsonNode valueValue3 = countValue2.get("value");
                                        if (valueValue3 != null && valueValue3 instanceof NullNode == false) {
                                            String valueInstance2;
                                            valueInstance2 = valueValue3.getTextValue();
                                            countInstance2.setValue(valueInstance2);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get a list of tags under a subscription.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return List of subscription tags.
    */
    @Override
    public Future<TagsListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<TagsListResult>() { 
            @Override
            public TagsListResult call() throws Exception {
                return listNext(nextLink);
            }
         });
    }
    
    /**
    * Get a list of tags under a subscription.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of subscription tags.
    */
    @Override
    public TagsListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter(invocationId, this, "listNextAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            TagsListResult result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new TagsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            TagDetails tagDetailsInstance = new TagDetails();
                            result.getTags().add(tagDetailsInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                tagDetailsInstance.setId(idInstance);
                            }
                            
                            JsonNode tagNameValue = valueValue.get("tagName");
                            if (tagNameValue != null && tagNameValue instanceof NullNode == false) {
                                String tagNameInstance;
                                tagNameInstance = tagNameValue.getTextValue();
                                tagDetailsInstance.setName(tagNameInstance);
                            }
                            
                            JsonNode countValue = valueValue.get("count");
                            if (countValue != null && countValue instanceof NullNode == false) {
                                TagCount countInstance = new TagCount();
                                tagDetailsInstance.setCount(countInstance);
                                
                                JsonNode typeValue = countValue.get("type");
                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                    String typeInstance;
                                    typeInstance = typeValue.getTextValue();
                                    countInstance.setType(typeInstance);
                                }
                                
                                JsonNode valueValue2 = countValue.get("value");
                                if (valueValue2 != null && valueValue2 instanceof NullNode == false) {
                                    String valueInstance;
                                    valueInstance = valueValue2.getTextValue();
                                    countInstance.setValue(valueInstance);
                                }
                            }
                            
                            JsonNode valuesArray = valueValue.get("values");
                            if (valuesArray != null && valuesArray instanceof NullNode == false) {
                                for (JsonNode valuesValue : ((ArrayNode) valuesArray)) {
                                    TagValue tagValueInstance = new TagValue();
                                    tagDetailsInstance.getValues().add(tagValueInstance);
                                    
                                    JsonNode idValue2 = valuesValue.get("id");
                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                        String idInstance2;
                                        idInstance2 = idValue2.getTextValue();
                                        tagValueInstance.setId(idInstance2);
                                    }
                                    
                                    JsonNode tagValueValue = valuesValue.get("tagValue");
                                    if (tagValueValue != null && tagValueValue instanceof NullNode == false) {
                                        String tagValueInstance2;
                                        tagValueInstance2 = tagValueValue.getTextValue();
                                        tagValueInstance.setValue(tagValueInstance2);
                                    }
                                    
                                    JsonNode countValue2 = valuesValue.get("count");
                                    if (countValue2 != null && countValue2 instanceof NullNode == false) {
                                        TagCount countInstance2 = new TagCount();
                                        tagValueInstance.setCount(countInstance2);
                                        
                                        JsonNode typeValue2 = countValue2.get("type");
                                        if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                            String typeInstance2;
                                            typeInstance2 = typeValue2.getTextValue();
                                            countInstance2.setType(typeInstance2);
                                        }
                                        
                                        JsonNode valueValue3 = countValue2.get("value");
                                        if (valueValue3 != null && valueValue3 instanceof NullNode == false) {
                                            String valueInstance2;
                                            valueInstance2 = valueValue3.getTextValue();
                                            countInstance2.setValue(valueInstance2);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
