/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;

/**
* Resource provider information.
*/
public class Provider extends OperationResponse {
    private String id;
    
    /**
    * Optional. Gets or sets the provider id.
    * @return The Id value.
    */
    public String getId() {
        return this.id;
    }
    
    /**
    * Optional. Gets or sets the provider id.
    * @param idValue The Id value.
    */
    public void setId(final String idValue) {
        this.id = idValue;
    }
    
    private String namespace;
    
    /**
    * Optional. Gets or sets the namespace of the provider.
    * @return The Namespace value.
    */
    public String getNamespace() {
        return this.namespace;
    }
    
    /**
    * Optional. Gets or sets the namespace of the provider.
    * @param namespaceValue The Namespace value.
    */
    public void setNamespace(final String namespaceValue) {
        this.namespace = namespaceValue;
    }
    
    private String registrationState;
    
    /**
    * Optional. Gets or sets the registration state of the provider.
    * @return The RegistrationState value.
    */
    public String getRegistrationState() {
        return this.registrationState;
    }
    
    /**
    * Optional. Gets or sets the registration state of the provider.
    * @param registrationStateValue The RegistrationState value.
    */
    public void setRegistrationState(final String registrationStateValue) {
        this.registrationState = registrationStateValue;
    }
    
    private ArrayList<ProviderResourceType> resourceTypes;
    
    /**
    * Optional. Gets or sets the collection of provider resource types.
    * @return The ResourceTypes value.
    */
    public ArrayList<ProviderResourceType> getResourceTypes() {
        return this.resourceTypes;
    }
    
    /**
    * Optional. Gets or sets the collection of provider resource types.
    * @param resourceTypesValue The ResourceTypes value.
    */
    public void setResourceTypes(final ArrayList<ProviderResourceType> resourceTypesValue) {
        this.resourceTypes = resourceTypesValue;
    }
    
    /**
    * Initializes a new instance of the Provider class.
    *
    */
    public Provider() {
        super();
        this.setResourceTypes(new LazyArrayList<ProviderResourceType>());
    }
}
