/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Provider Operations metadata
*/
public class ProviderOperationsMetadata {
    private String displayName;
    
    /**
    * Optional. Gets or sets the provider display name
    * @return The DisplayName value.
    */
    public String getDisplayName() {
        return this.displayName;
    }
    
    /**
    * Optional. Gets or sets the provider display name
    * @param displayNameValue The DisplayName value.
    */
    public void setDisplayName(final String displayNameValue) {
        this.displayName = displayNameValue;
    }
    
    private String id;
    
    /**
    * Optional. Gets or sets the provider id.
    * @return The Id value.
    */
    public String getId() {
        return this.id;
    }
    
    /**
    * Optional. Gets or sets the provider id.
    * @param idValue The Id value.
    */
    public void setId(final String idValue) {
        this.id = idValue;
    }
    
    private String name;
    
    /**
    * Optional. Gets or sets the provider name
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Gets or sets the provider name
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private ArrayList<Operation> operations;
    
    /**
    * Optional. Gets or sets the provider operations
    * @return The Operations value.
    */
    public ArrayList<Operation> getOperations() {
        return this.operations;
    }
    
    /**
    * Optional. Gets or sets the provider operations
    * @param operationsValue The Operations value.
    */
    public void setOperations(final ArrayList<Operation> operationsValue) {
        this.operations = operationsValue;
    }
    
    private ArrayList<ResourceType> resourceTypes;
    
    /**
    * Optional. Gets or sets the provider resource types
    * @return The ResourceTypes value.
    */
    public ArrayList<ResourceType> getResourceTypes() {
        return this.resourceTypes;
    }
    
    /**
    * Optional. Gets or sets the provider resource types
    * @param resourceTypesValue The ResourceTypes value.
    */
    public void setResourceTypes(final ArrayList<ResourceType> resourceTypesValue) {
        this.resourceTypes = resourceTypesValue;
    }
    
    private String type;
    
    /**
    * Optional. Gets or sets the provider type
    * @return The Type value.
    */
    public String getType() {
        return this.type;
    }
    
    /**
    * Optional. Gets or sets the provider type
    * @param typeValue The Type value.
    */
    public void setType(final String typeValue) {
        this.type = typeValue;
    }
    
    /**
    * Initializes a new instance of the ProviderOperationsMetadata class.
    *
    */
    public ProviderOperationsMetadata() {
        this.setOperations(new LazyArrayList<Operation>());
        this.setResourceTypes(new LazyArrayList<ResourceType>());
    }
}
