/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources.models;

import java.net.URI;

/**
* Entity representing the reference to the template.
*/
public class TemplateLink {
    private String contentVersion;
    
    /**
    * Optional. If included it must match the ContentVersion in the template.
    * @return The ContentVersion value.
    */
    public String getContentVersion() {
        return this.contentVersion;
    }
    
    /**
    * Optional. If included it must match the ContentVersion in the template.
    * @param contentVersionValue The ContentVersion value.
    */
    public void setContentVersion(final String contentVersionValue) {
        this.contentVersion = contentVersionValue;
    }
    
    private URI uri;
    
    /**
    * Required. URI referencing the template.
    * @return The Uri value.
    */
    public URI getUri() {
        return this.uri;
    }
    
    /**
    * Required. URI referencing the template.
    * @param uriValue The Uri value.
    */
    public void setUri(final URI uriValue) {
        this.uri = uriValue;
    }
    
    /**
    * Initializes a new instance of the TemplateLink class.
    *
    */
    public TemplateLink() {
    }
    
    /**
    * Initializes a new instance of the TemplateLink class with required
    * arguments.
    *
    * @param uri URI referencing the template.
    */
    public TemplateLink(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        this.setUri(uri);
    }
}
