/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.subscriptions;

import com.microsoft.azure.subscriptions.models.GetSubscriptionResult;
import com.microsoft.azure.subscriptions.models.SubscriptionListResult;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.Future;

/**
* Operations for managing subscriptions.
*/
public interface SubscriptionOperations {
    /**
    * Gets details about particular subscription.
    *
    * @param subscriptionId Required. Id of the subscription.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Subscription detailed information.
    */
    GetSubscriptionResult get(String subscriptionId) throws IOException, ServiceException;
    
    /**
    * Gets details about particular subscription.
    *
    * @param subscriptionId Required. Id of the subscription.
    * @return Subscription detailed information.
    */
    Future<GetSubscriptionResult> getAsync(String subscriptionId);
    
    /**
    * Gets a list of the subscriptionIds.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Subscription list operation response.
    */
    SubscriptionListResult list() throws IOException, ServiceException;
    
    /**
    * Gets a list of the subscriptionIds.
    *
    * @return Subscription list operation response.
    */
    Future<SubscriptionListResult> listAsync();
}
