/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.ErrorResponseException;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.PolicyAssignmentInner;
import com.microsoft.azure.management.resources.implementation.PolicyClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PolicyAssignmentsInner
implements InnerSupportsDelete<PolicyAssignmentInner>,
InnerSupportsListing<PolicyAssignmentInner> {
    private PolicyAssignmentsService service;
    private PolicyClientImpl client;

    public PolicyAssignmentsInner(Retrofit retrofit, PolicyClientImpl client) {
        this.service = (PolicyAssignmentsService)retrofit.create(PolicyAssignmentsService.class);
        this.client = client;
    }

    public PolicyAssignmentInner delete(String scope, String policyAssignmentName) {
        return (PolicyAssignmentInner)((ServiceResponse)this.deleteWithServiceResponseAsync(scope, policyAssignmentName).toBlocking().single()).body();
    }

    public ServiceFuture<PolicyAssignmentInner> deleteAsync(String scope, String policyAssignmentName, ServiceCallback<PolicyAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(scope, policyAssignmentName), serviceCallback);
    }

    @Override
    public Observable<PolicyAssignmentInner> deleteAsync(String scope, String policyAssignmentName) {
        return this.deleteWithServiceResponseAsync(scope, policyAssignmentName).map((Func1)new Func1<ServiceResponse<PolicyAssignmentInner>, PolicyAssignmentInner>(){

            public PolicyAssignmentInner call(ServiceResponse<PolicyAssignmentInner> response) {
                return (PolicyAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicyAssignmentInner>> deleteWithServiceResponseAsync(String scope, String policyAssignmentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (policyAssignmentName == null) {
            throw new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.delete(scope, policyAssignmentName, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicyAssignmentInner>>>(){

            public Observable<ServiceResponse<PolicyAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyAssignmentsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicyAssignmentInner> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicyAssignmentInner>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PolicyAssignmentInner create(String scope, String policyAssignmentName, PolicyAssignmentInner parameters) {
        return (PolicyAssignmentInner)((ServiceResponse)this.createWithServiceResponseAsync(scope, policyAssignmentName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<PolicyAssignmentInner> createAsync(String scope, String policyAssignmentName, PolicyAssignmentInner parameters, ServiceCallback<PolicyAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(scope, policyAssignmentName, parameters), serviceCallback);
    }

    public Observable<PolicyAssignmentInner> createAsync(String scope, String policyAssignmentName, PolicyAssignmentInner parameters) {
        return this.createWithServiceResponseAsync(scope, policyAssignmentName, parameters).map((Func1)new Func1<ServiceResponse<PolicyAssignmentInner>, PolicyAssignmentInner>(){

            public PolicyAssignmentInner call(ServiceResponse<PolicyAssignmentInner> response) {
                return (PolicyAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicyAssignmentInner>> createWithServiceResponseAsync(String scope, String policyAssignmentName, PolicyAssignmentInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (policyAssignmentName == null) {
            throw new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-06-01-preview";
        return this.service.create(scope, policyAssignmentName, parameters, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicyAssignmentInner>>>(){

            public Observable<ServiceResponse<PolicyAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyAssignmentsInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicyAssignmentInner> createDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<PolicyAssignmentInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PolicyAssignmentInner get(String scope, String policyAssignmentName) {
        return (PolicyAssignmentInner)((ServiceResponse)this.getWithServiceResponseAsync(scope, policyAssignmentName).toBlocking().single()).body();
    }

    public ServiceFuture<PolicyAssignmentInner> getAsync(String scope, String policyAssignmentName, ServiceCallback<PolicyAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(scope, policyAssignmentName), serviceCallback);
    }

    public Observable<PolicyAssignmentInner> getAsync(String scope, String policyAssignmentName) {
        return this.getWithServiceResponseAsync(scope, policyAssignmentName).map((Func1)new Func1<ServiceResponse<PolicyAssignmentInner>, PolicyAssignmentInner>(){

            public PolicyAssignmentInner call(ServiceResponse<PolicyAssignmentInner> response) {
                return (PolicyAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicyAssignmentInner>> getWithServiceResponseAsync(String scope, String policyAssignmentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (policyAssignmentName == null) {
            throw new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.get(scope, policyAssignmentName, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicyAssignmentInner>>>(){

            public Observable<ServiceResponse<PolicyAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyAssignmentsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicyAssignmentInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicyAssignmentInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public PagedList<PolicyAssignmentInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<PolicyAssignmentInner>((Page)response.body()){

            public Page<PolicyAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyAssignmentInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<PolicyAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(String nextPageLink) {
                return PolicyAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<PolicyAssignmentInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Page<PolicyAssignmentInner>>(){

            public Page<PolicyAssignmentInner> call(ServiceResponse<Page<PolicyAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(ServiceResponse<Page<PolicyAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyAssignmentsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        String filter = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyAssignmentsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<PolicyAssignmentInner> listByResourceGroup(String resourceGroupName, String filter) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, filter).toBlocking().single();
        return new PagedList<PolicyAssignmentInner>((Page)response.body()){

            public Page<PolicyAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyAssignmentInner>> listByResourceGroupAsync(String resourceGroupName, String filter, ListOperationCallback<PolicyAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(String nextPageLink) {
                return PolicyAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyAssignmentInner>> listByResourceGroupAsync(String resourceGroupName, String filter) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter).map((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Page<PolicyAssignmentInner>>(){

            public Page<PolicyAssignmentInner> call(ServiceResponse<Page<PolicyAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String filter) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, filter).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(ServiceResponse<Page<PolicyAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyAssignmentsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyAssignmentsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyAssignmentInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyAssignmentInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<PolicyAssignmentInner> listForResource(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        ServiceResponse response = (ServiceResponse)this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).toBlocking().single();
        return new PagedList<PolicyAssignmentInner>((Page)response.body()){

            public Page<PolicyAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyAssignmentInner>> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, ListOperationCallback<PolicyAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(String nextPageLink) {
                return PolicyAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyAssignmentInner>> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        return this.listForResourceWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).map((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Page<PolicyAssignmentInner>>(){

            public Page<PolicyAssignmentInner> call(ServiceResponse<Page<PolicyAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listForResourceWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        return this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(ServiceResponse<Page<PolicyAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyAssignmentsInner.this.listForResourceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listForResourceSinglePageAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        String filter = null;
        return this.service.listForResource(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyAssignmentsInner.this.listForResourceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<PolicyAssignmentInner> listForResource(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        ServiceResponse response = (ServiceResponse)this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).toBlocking().single();
        return new PagedList<PolicyAssignmentInner>((Page)response.body()){

            public Page<PolicyAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyAssignmentInner>> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter, ListOperationCallback<PolicyAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(String nextPageLink) {
                return PolicyAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyAssignmentInner>> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        return this.listForResourceWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).map((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Page<PolicyAssignmentInner>>(){

            public Page<PolicyAssignmentInner> call(ServiceResponse<Page<PolicyAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listForResourceWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        return this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(ServiceResponse<Page<PolicyAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyAssignmentsInner.this.listForResourceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listForResourceSinglePageAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.listForResource(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyAssignmentsInner.this.listForResourceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyAssignmentInner>> listForResourceDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyAssignmentInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public PagedList<PolicyAssignmentInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<PolicyAssignmentInner>((Page)response.body()){

            public Page<PolicyAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyAssignmentsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyAssignmentInner>> listAsync(ListOperationCallback<PolicyAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(String nextPageLink) {
                return PolicyAssignmentsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<PolicyAssignmentInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Page<PolicyAssignmentInner>>(){

            public Page<PolicyAssignmentInner> call(ServiceResponse<Page<PolicyAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(ServiceResponse<Page<PolicyAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyAssignmentsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        String filter = null;
        return this.service.list(this.client.subscriptionId(), filter, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyAssignmentsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<PolicyAssignmentInner> list(String filter) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<PolicyAssignmentInner>((Page)response.body()){

            public Page<PolicyAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyAssignmentsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyAssignmentInner>> listAsync(String filter, ListOperationCallback<PolicyAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(String nextPageLink) {
                return PolicyAssignmentsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyAssignmentInner>> listAsync(String filter) {
        return this.listWithServiceResponseAsync(filter).map((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Page<PolicyAssignmentInner>>(){

            public Page<PolicyAssignmentInner> call(ServiceResponse<Page<PolicyAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listWithServiceResponseAsync(String filter) {
        return this.listSinglePageAsync(filter).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(ServiceResponse<Page<PolicyAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyAssignmentsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listSinglePageAsync(String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.list(this.client.subscriptionId(), filter, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyAssignmentsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyAssignmentInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyAssignmentInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PolicyAssignmentInner deleteById(String policyAssignmentId) {
        return (PolicyAssignmentInner)((ServiceResponse)this.deleteByIdWithServiceResponseAsync(policyAssignmentId).toBlocking().single()).body();
    }

    public ServiceFuture<PolicyAssignmentInner> deleteByIdAsync(String policyAssignmentId, ServiceCallback<PolicyAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteByIdWithServiceResponseAsync(policyAssignmentId), serviceCallback);
    }

    public Observable<PolicyAssignmentInner> deleteByIdAsync(String policyAssignmentId) {
        return this.deleteByIdWithServiceResponseAsync(policyAssignmentId).map((Func1)new Func1<ServiceResponse<PolicyAssignmentInner>, PolicyAssignmentInner>(){

            public PolicyAssignmentInner call(ServiceResponse<PolicyAssignmentInner> response) {
                return (PolicyAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicyAssignmentInner>> deleteByIdWithServiceResponseAsync(String policyAssignmentId) {
        if (policyAssignmentId == null) {
            throw new IllegalArgumentException("Parameter policyAssignmentId is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.deleteById(policyAssignmentId, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicyAssignmentInner>>>(){

            public Observable<ServiceResponse<PolicyAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyAssignmentsInner.this.deleteByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicyAssignmentInner> deleteByIdDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicyAssignmentInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PolicyAssignmentInner createById(String policyAssignmentId, PolicyAssignmentInner parameters) {
        return (PolicyAssignmentInner)((ServiceResponse)this.createByIdWithServiceResponseAsync(policyAssignmentId, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<PolicyAssignmentInner> createByIdAsync(String policyAssignmentId, PolicyAssignmentInner parameters, ServiceCallback<PolicyAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createByIdWithServiceResponseAsync(policyAssignmentId, parameters), serviceCallback);
    }

    public Observable<PolicyAssignmentInner> createByIdAsync(String policyAssignmentId, PolicyAssignmentInner parameters) {
        return this.createByIdWithServiceResponseAsync(policyAssignmentId, parameters).map((Func1)new Func1<ServiceResponse<PolicyAssignmentInner>, PolicyAssignmentInner>(){

            public PolicyAssignmentInner call(ServiceResponse<PolicyAssignmentInner> response) {
                return (PolicyAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicyAssignmentInner>> createByIdWithServiceResponseAsync(String policyAssignmentId, PolicyAssignmentInner parameters) {
        if (policyAssignmentId == null) {
            throw new IllegalArgumentException("Parameter policyAssignmentId is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-06-01-preview";
        return this.service.createById(policyAssignmentId, parameters, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicyAssignmentInner>>>(){

            public Observable<ServiceResponse<PolicyAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyAssignmentsInner.this.createByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicyAssignmentInner> createByIdDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<PolicyAssignmentInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PolicyAssignmentInner getById(String policyAssignmentId) {
        return (PolicyAssignmentInner)((ServiceResponse)this.getByIdWithServiceResponseAsync(policyAssignmentId).toBlocking().single()).body();
    }

    public ServiceFuture<PolicyAssignmentInner> getByIdAsync(String policyAssignmentId, ServiceCallback<PolicyAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByIdWithServiceResponseAsync(policyAssignmentId), serviceCallback);
    }

    public Observable<PolicyAssignmentInner> getByIdAsync(String policyAssignmentId) {
        return this.getByIdWithServiceResponseAsync(policyAssignmentId).map((Func1)new Func1<ServiceResponse<PolicyAssignmentInner>, PolicyAssignmentInner>(){

            public PolicyAssignmentInner call(ServiceResponse<PolicyAssignmentInner> response) {
                return (PolicyAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PolicyAssignmentInner>> getByIdWithServiceResponseAsync(String policyAssignmentId) {
        if (policyAssignmentId == null) {
            throw new IllegalArgumentException("Parameter policyAssignmentId is required and cannot be null.");
        }
        String apiVersion = "2017-06-01-preview";
        return this.service.getById(policyAssignmentId, "2017-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicyAssignmentInner>>>(){

            public Observable<ServiceResponse<PolicyAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PolicyAssignmentsInner.this.getByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PolicyAssignmentInner> getByIdDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PolicyAssignmentInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<PolicyAssignmentInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicyAssignmentInner>((Page)response.body()){

            public Page<PolicyAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyAssignmentInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<PolicyAssignmentInner>> serviceFuture, ListOperationCallback<PolicyAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(String nextPageLink) {
                return PolicyAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyAssignmentInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Page<PolicyAssignmentInner>>(){

            public Page<PolicyAssignmentInner> call(ServiceResponse<Page<PolicyAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(ServiceResponse<Page<PolicyAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyAssignmentsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyAssignmentsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyAssignmentInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyAssignmentInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<PolicyAssignmentInner> listForResourceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicyAssignmentInner>((Page)response.body()){

            public Page<PolicyAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyAssignmentInner>> listForResourceNextAsync(String nextPageLink, ServiceFuture<List<PolicyAssignmentInner>> serviceFuture, ListOperationCallback<PolicyAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listForResourceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(String nextPageLink) {
                return PolicyAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyAssignmentInner>> listForResourceNextAsync(String nextPageLink) {
        return this.listForResourceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Page<PolicyAssignmentInner>>(){

            public Page<PolicyAssignmentInner> call(ServiceResponse<Page<PolicyAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listForResourceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listForResourceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(ServiceResponse<Page<PolicyAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyAssignmentsInner.this.listForResourceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listForResourceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listForResourceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyAssignmentsInner.this.listForResourceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyAssignmentInner>> listForResourceNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyAssignmentInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<PolicyAssignmentInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicyAssignmentInner>((Page)response.body()){

            public Page<PolicyAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PolicyAssignmentsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PolicyAssignmentInner>> listNextAsync(String nextPageLink, ServiceFuture<List<PolicyAssignmentInner>> serviceFuture, ListOperationCallback<PolicyAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(String nextPageLink) {
                return PolicyAssignmentsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PolicyAssignmentInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Page<PolicyAssignmentInner>>(){

            public Page<PolicyAssignmentInner> call(ServiceResponse<Page<PolicyAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PolicyAssignmentInner>>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(ServiceResponse<Page<PolicyAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PolicyAssignmentsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicyAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<PolicyAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PolicyAssignmentsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PolicyAssignmentInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PolicyAssignmentInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface PolicyAssignmentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments delete"})
        @HTTP(path="{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="scope", encoded=true) String var1, @Path(value="policyAssignmentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments create"})
        @PUT(value="{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}")
        public Observable<Response<ResponseBody>> create(@Path(value="scope", encoded=true) String var1, @Path(value="policyAssignmentName") String var2, @Body PolicyAssignmentInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments get"})
        @GET(value="{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}")
        public Observable<Response<ResponseBody>> get(@Path(value="scope", encoded=true) String var1, @Path(value="policyAssignmentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/policyAssignments")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="$filter", encoded=true) String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments listForResource"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/policyAssignments")
        public Observable<Response<ResponseBody>> listForResource(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="subscriptionId") String var6, @Query(value="$filter") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyAssignments")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$filter") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments deleteById"})
        @HTTP(path="{policyAssignmentId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteById(@Path(value="policyAssignmentId", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments createById"})
        @PUT(value="{policyAssignmentId}")
        public Observable<Response<ResponseBody>> createById(@Path(value="policyAssignmentId", encoded=true) String var1, @Body PolicyAssignmentInner var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments getById"})
        @GET(value="{policyAssignmentId}")
        public Observable<Response<ResponseBody>> getById(@Path(value="policyAssignmentId", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments listForResourceNext"})
        @GET
        public Observable<Response<ResponseBody>> listForResourceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicyAssignments listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

