/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.servicebus;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Message Count Details.
 */
public class MessageCountDetails {
    /**
     * Number of active messages in the queue, topic, or subscription.
     */
    @JsonProperty(value = "activeMessageCount", access = JsonProperty.Access.WRITE_ONLY)
    private Long activeMessageCount;

    /**
     * Number of messages that are dead lettered.
     */
    @JsonProperty(value = "deadLetterMessageCount", access = JsonProperty.Access.WRITE_ONLY)
    private Long deadLetterMessageCount;

    /**
     * Number of scheduled messages.
     */
    @JsonProperty(value = "scheduledMessageCount", access = JsonProperty.Access.WRITE_ONLY)
    private Long scheduledMessageCount;

    /**
     * Number of messages transferred into dead letters.
     */
    @JsonProperty(value = "transferDeadLetterMessageCount", access = JsonProperty.Access.WRITE_ONLY)
    private Long transferDeadLetterMessageCount;

    /**
     * Number of messages transferred to another queue, topic, or subscription.
     */
    @JsonProperty(value = "transferMessageCount", access = JsonProperty.Access.WRITE_ONLY)
    private Long transferMessageCount;

    /**
     * Get the activeMessageCount value.
     *
     * @return the activeMessageCount value
     */
    public Long activeMessageCount() {
        return this.activeMessageCount;
    }

    /**
     * Get the deadLetterMessageCount value.
     *
     * @return the deadLetterMessageCount value
     */
    public Long deadLetterMessageCount() {
        return this.deadLetterMessageCount;
    }

    /**
     * Get the scheduledMessageCount value.
     *
     * @return the scheduledMessageCount value
     */
    public Long scheduledMessageCount() {
        return this.scheduledMessageCount;
    }

    /**
     * Get the transferDeadLetterMessageCount value.
     *
     * @return the transferDeadLetterMessageCount value
     */
    public Long transferDeadLetterMessageCount() {
        return this.transferDeadLetterMessageCount;
    }

    /**
     * Get the transferMessageCount value.
     *
     * @return the transferMessageCount value
     */
    public Long transferMessageCount() {
        return this.transferMessageCount;
    }

}
