/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.servicebus.implementation;

import org.joda.time.DateTime;
import com.microsoft.azure.management.servicebus.MessageCountDetails;
import com.microsoft.azure.management.servicebus.EntityStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Description of subscription resource.
 */
@JsonFlatten
public class SubscriptionInner extends Resource {
    /**
     * Last time there was a receive request to this subscription.
     */
    @JsonProperty(value = "properties.accessedAt", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime accessedAt;

    /**
     * TimeSpan idle interval after which the topic is automatically deleted.
     * The minimum duration is 5 minutes. The service accepts a C# Standard
     * TimeSpan Format for loc duration
     * https://msdn.microsoft.com/en-us/library/ee372286(v=vs.110).aspx. Format
     * is 'DD.HH:MM:SS' and default value of this property is 10675199 days.
     */
    @JsonProperty(value = "properties.autoDeleteOnIdle")
    private String autoDeleteOnIdle;

    /**
     * The countDetails property.
     */
    @JsonProperty(value = "properties.countDetails", access = JsonProperty.Access.WRITE_ONLY)
    private MessageCountDetails countDetails;

    /**
     * Exact time the Subscription was created.
     */
    @JsonProperty(value = "properties.createdAt", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime createdAt;

    /**
     * Default message time to live value. This is the duration after which the
     * message expires, starting from when the message is sent to Service Bus.
     * This is the default value used when TimeToLive is not set on a message
     * itself. The service accepts a C# Standard TimeSpan Format for loc
     * duration
     * https://msdn.microsoft.com/en-us/library/ee372286(v=vs.110).aspx .
     * Format is 'DD.HH:MM:SS' and default value of this property is 10675199
     * days.
     */
    @JsonProperty(value = "properties.defaultMessageTimeToLive")
    private String defaultMessageTimeToLive;

    /**
     * Value that indicates whether a subscription has dead letter support on
     * filter evaluation exceptions.
     */
    @JsonProperty(value = "properties.deadLetteringOnFilterEvaluationExceptions")
    private Boolean deadLetteringOnFilterEvaluationExceptions;

    /**
     * Value that indicates whether a subscription has dead letter support when
     * a message expires.
     */
    @JsonProperty(value = "properties.deadLetteringOnMessageExpiration")
    private Boolean deadLetteringOnMessageExpiration;

    /**
     * Value that indicates whether server-side batched operations are enabled.
     */
    @JsonProperty(value = "properties.enableBatchedOperations")
    private Boolean enableBatchedOperations;

    /**
     * The lock duration time span for the subscription. The service accepts a
     * C# Standard TimeSpan Format for loc duration
     * https://msdn.microsoft.com/en-us/library/ee372286(v=vs.110).aspx.
     */
    @JsonProperty(value = "properties.lockDuration")
    private String lockDuration;

    /**
     * Number of maximum deliveries.
     */
    @JsonProperty(value = "properties.maxDeliveryCount")
    private Integer maxDeliveryCount;

    /**
     * Number of messages.
     */
    @JsonProperty(value = "properties.messageCount", access = JsonProperty.Access.WRITE_ONLY)
    private Long messageCount;

    /**
     * Value indicating if a subscription supports the concept of sessions.
     */
    @JsonProperty(value = "properties.requiresSession")
    private Boolean requiresSession;

    /**
     * Enumerates the possible values for the status of a messaging entity.
     * Possible values include: 'Active', 'Creating', 'Deleting', 'Disabled',
     * 'ReceiveDisabled', 'Renaming', 'Restoring', 'SendDisabled', 'Unknown'.
     */
    @JsonProperty(value = "properties.status")
    private EntityStatus status;

    /**
     * The exact time the subscription was updated.
     */
    @JsonProperty(value = "properties.updatedAt", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime updatedAt;

    /**
     * Get the accessedAt value.
     *
     * @return the accessedAt value
     */
    public DateTime accessedAt() {
        return this.accessedAt;
    }

    /**
     * Get the autoDeleteOnIdle value.
     *
     * @return the autoDeleteOnIdle value
     */
    public String autoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    /**
     * Set the autoDeleteOnIdle value.
     *
     * @param autoDeleteOnIdle the autoDeleteOnIdle value to set
     * @return the SubscriptionInner object itself.
     */
    public SubscriptionInner withAutoDeleteOnIdle(String autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    /**
     * Get the countDetails value.
     *
     * @return the countDetails value
     */
    public MessageCountDetails countDetails() {
        return this.countDetails;
    }

    /**
     * Get the createdAt value.
     *
     * @return the createdAt value
     */
    public DateTime createdAt() {
        return this.createdAt;
    }

    /**
     * Get the defaultMessageTimeToLive value.
     *
     * @return the defaultMessageTimeToLive value
     */
    public String defaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    /**
     * Set the defaultMessageTimeToLive value.
     *
     * @param defaultMessageTimeToLive the defaultMessageTimeToLive value to set
     * @return the SubscriptionInner object itself.
     */
    public SubscriptionInner withDefaultMessageTimeToLive(String defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    /**
     * Get the deadLetteringOnFilterEvaluationExceptions value.
     *
     * @return the deadLetteringOnFilterEvaluationExceptions value
     */
    public Boolean deadLetteringOnFilterEvaluationExceptions() {
        return this.deadLetteringOnFilterEvaluationExceptions;
    }

    /**
     * Set the deadLetteringOnFilterEvaluationExceptions value.
     *
     * @param deadLetteringOnFilterEvaluationExceptions the deadLetteringOnFilterEvaluationExceptions value to set
     * @return the SubscriptionInner object itself.
     */
    public SubscriptionInner withDeadLetteringOnFilterEvaluationExceptions(Boolean deadLetteringOnFilterEvaluationExceptions) {
        this.deadLetteringOnFilterEvaluationExceptions = deadLetteringOnFilterEvaluationExceptions;
        return this;
    }

    /**
     * Get the deadLetteringOnMessageExpiration value.
     *
     * @return the deadLetteringOnMessageExpiration value
     */
    public Boolean deadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    /**
     * Set the deadLetteringOnMessageExpiration value.
     *
     * @param deadLetteringOnMessageExpiration the deadLetteringOnMessageExpiration value to set
     * @return the SubscriptionInner object itself.
     */
    public SubscriptionInner withDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    /**
     * Get the enableBatchedOperations value.
     *
     * @return the enableBatchedOperations value
     */
    public Boolean enableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    /**
     * Set the enableBatchedOperations value.
     *
     * @param enableBatchedOperations the enableBatchedOperations value to set
     * @return the SubscriptionInner object itself.
     */
    public SubscriptionInner withEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    /**
     * Get the lockDuration value.
     *
     * @return the lockDuration value
     */
    public String lockDuration() {
        return this.lockDuration;
    }

    /**
     * Set the lockDuration value.
     *
     * @param lockDuration the lockDuration value to set
     * @return the SubscriptionInner object itself.
     */
    public SubscriptionInner withLockDuration(String lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    /**
     * Get the maxDeliveryCount value.
     *
     * @return the maxDeliveryCount value
     */
    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    /**
     * Set the maxDeliveryCount value.
     *
     * @param maxDeliveryCount the maxDeliveryCount value to set
     * @return the SubscriptionInner object itself.
     */
    public SubscriptionInner withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    /**
     * Get the messageCount value.
     *
     * @return the messageCount value
     */
    public Long messageCount() {
        return this.messageCount;
    }

    /**
     * Get the requiresSession value.
     *
     * @return the requiresSession value
     */
    public Boolean requiresSession() {
        return this.requiresSession;
    }

    /**
     * Set the requiresSession value.
     *
     * @param requiresSession the requiresSession value to set
     * @return the SubscriptionInner object itself.
     */
    public SubscriptionInner withRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    /**
     * Get the status value.
     *
     * @return the status value
     */
    public EntityStatus status() {
        return this.status;
    }

    /**
     * Set the status value.
     *
     * @param status the status value to set
     * @return the SubscriptionInner object itself.
     */
    public SubscriptionInner withStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the updatedAt value.
     *
     * @return the updatedAt value
     */
    public DateTime updatedAt() {
        return this.updatedAt;
    }

}
