/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.gateway.core;

import com.microsoft.azure.gateway.core.Broker;
import com.microsoft.azure.gateway.core.IGatewayModule;
import com.microsoft.azure.gateway.messaging.Message;
import java.io.IOException;

public abstract class GatewayModule
implements IGatewayModule {
    private long _addr;
    private Broker broker;
    private String configuration;

    public abstract void receive(Message var1);

    @Override
    public abstract void destroy();

    public GatewayModule(long address, Broker broker, String configuration) {
        if (broker == null) {
            throw new IllegalArgumentException("Broker can not be null.");
        }
        this.create(address, broker, configuration);
    }

    @Override
    public void create(long moduleAddr, Broker broker, String configuration) {
        this._addr = moduleAddr;
        this.broker = broker;
        this.configuration = configuration;
    }

    @Override
    public void start() {
    }

    @Override
    public void receive(byte[] serializedMessage) {
        this.receive(new Message(serializedMessage));
    }

    public int publish(Message message) throws IOException {
        return this.broker.publishMessage(message, this._addr);
    }

    public final Broker getBroker() {
        return this.broker;
    }

    public final String getConfiguration() {
        return this.configuration;
    }
}

