/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.gateway.messaging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class Message {
    private Map<String, String> properties;
    private byte[] content;

    public Message(byte[] content, Map<String, String> properties) {
        this.content = content != null ? content : new byte[]{};
        this.properties = properties != null ? properties : new HashMap();
    }

    public Message(byte[] serializedMessage) {
        try {
            this.fromByteArray(serializedMessage);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid byte array input.");
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream _bos = new ByteArrayOutputStream();
        DataOutputStream _dos = new DataOutputStream(_bos);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        _dos.writeInt(this.properties.size());
        Object[] keys = this.properties.keySet().toArray();
        for (int index = 0; index < keys.length; ++index) {
            byte[] key = ((String)keys[index]).getBytes("UTF-8");
            _dos.write(key);
            _dos.writeByte(0);
            byte[] value = this.properties.get(keys[index]).getBytes("UTF-8");
            _dos.write(value);
            _dos.writeByte(0);
        }
        _dos.writeInt(this.content.length);
        _dos.write(this.content);
        byte[] _result = _bos.toByteArray();
        dos.writeByte(161);
        dos.writeByte(96);
        dos.writeInt(_result.length + 6);
        dos.write(_result);
        byte[] result = bos.toByteArray();
        return result;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String toString() {
        return "Content: " + new String(this.content) + "\nProperties: " + this.properties.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fromByteArray(byte[] serializedMessage) throws IOException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(serializedMessage);
            DataInputStream dis = new DataInputStream(bis);
            byte header1 = dis.readByte();
            byte header2 = dis.readByte();
            if (header1 != -95 || header2 != 96) throw new IOException("Invalid byte array header.");
            int arraySize = dis.readInt();
            if (arraySize < 14) throw new IOException("Invalid byte array size.");
            HashMap<String, String> _properties = new HashMap<String, String>();
            int propCount = dis.readInt();
            if (propCount > 0) {
                for (int count = 0; count < propCount; ++count) {
                    byte[] key = this.readNullTerminatedString(bis);
                    byte[] value = this.readNullTerminatedString(bis);
                    _properties.put(new String(key), new String(value));
                }
            }
            int contentLength = dis.readInt();
            byte[] content = new byte[contentLength];
            dis.readFully(content);
            this.properties = _properties;
            this.content = content;
            return;
        }
        catch (Exception e) {
            throw new IOException("Unexpected exception occurred: " + e.getMessage());
        }
    }

    private byte[] readNullTerminatedString(ByteArrayInputStream bis) throws IOException {
        byte[] result;
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        byte b = (byte)bis.read();
        while (b != 0 && b != -1) {
            byteArray.add(b);
            b = (byte)bis.read();
        }
        if (b != -1) {
            result = new byte[byteArray.size()];
            for (int index = 0; index < result.length; ++index) {
                result[index] = (Byte)byteArray.get(index);
            }
        } else {
            throw new IOException("Could not read null-terminated string.");
        }
        return result;
    }
}

