/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.gateway;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class IoTGateway {
    private static final String GW_EXECUTABLE_NAME_WIN32 = "gw.exe";
    private static final String GW_EXECUTABLE_NAME_LINUX = "gw";
    private static final String LD_LIBRARY_PATH_ENV_NAME = "LD_LIBRARY_PATH";
    private static boolean needToSetLdPath = false;
    private static String executableContainerPath = null;
    private static String executablePath = null;

    public static void main(String[] args) throws IOException, SecurityException, InterruptedException {
        IoTGateway.parseAmbientEnvironment();
        IoTGateway.setExecutablePermission(executablePath);
        ArrayList<String> gwArguments = new ArrayList<String>();
        gwArguments.add(executablePath);
        gwArguments.addAll(Arrays.asList(args));
        ProcessBuilder gwProcBuilder = new ProcessBuilder(gwArguments);
        gwProcBuilder.inheritIO();
        if (needToSetLdPath) {
            Map<String, String> environmentVars = gwProcBuilder.environment();
            environmentVars.put(LD_LIBRARY_PATH_ENV_NAME, executableContainerPath);
        }
        Process gwProc = gwProcBuilder.start();
        gwProc.waitFor();
    }

    private static void parseAmbientEnvironment() throws IOException {
        String GW_EXECUTABLE_NAME_WIN32 = GW_EXECUTABLE_NAME_WIN32;
        String GW_EXECUTABLE_NAME_LINUX = GW_EXECUTABLE_NAME_LINUX;
        String gwExecutableFileName = null;
        if (IoTGateway.hasResourceFileInRoot(GW_EXECUTABLE_NAME_WIN32)) {
            gwExecutableFileName = GW_EXECUTABLE_NAME_WIN32;
        } else if (IoTGateway.hasResourceFileInRoot(GW_EXECUTABLE_NAME_LINUX)) {
            gwExecutableFileName = GW_EXECUTABLE_NAME_LINUX;
            needToSetLdPath = true;
        } else {
            throw new IOException("No gateway executable found in this jar file");
        }
        File gwInCurrentFolder = new File(gwExecutableFileName);
        if (gwInCurrentFolder.exists()) {
            executablePath = gwInCurrentFolder.getAbsolutePath();
            executableContainerPath = new File(".").getAbsolutePath();
            return;
        }
        URL jarFileUrl = IoTGateway.class.getProtectionDomain().getCodeSource().getLocation();
        File gwJarFile = new File(jarFileUrl.getPath());
        String gwJarContainerPath = gwJarFile.getParent();
        File gwInJarFolder = new File(gwJarContainerPath, gwExecutableFileName);
        if (gwInJarFolder.exists()) {
            executablePath = gwInJarFolder.getAbsolutePath();
            executableContainerPath = gwJarContainerPath;
            return;
        }
        throw new IOException(String.format("Could not find gateway executable (%s)", gwExecutableFileName));
    }

    private static boolean hasResourceFileInRoot(String filename) {
        String filepath = String.format("/%s", filename);
        return IoTGateway.class.getResource(filepath) != null;
    }

    private static void setExecutablePermission(String filename) throws SecurityException {
        File executableFile = new File(filename);
        if (!executableFile.canExecute()) {
            executableFile.setExecutable(true);
        }
    }
}

