/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.requests;

import com.microsoft.graph.core.requests.GraphClientFactory;
import com.microsoft.graph.core.requests.options.GraphClientOption;
import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.authentication.AuthenticationProvider;
import com.microsoft.kiota.http.OkHttpRequestAdapter;
import com.microsoft.kiota.serialization.ParseNodeFactory;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumMap;
import okhttp3.Call;
import okhttp3.OkHttpClient;

public class BaseGraphRequestAdapter
extends OkHttpRequestAdapter {
    private static EnumMap<Clouds, String> getCloudList() {
        EnumMap<Clouds, String> cloudList = new EnumMap<Clouds, String>(Clouds.class);
        cloudList.put(Clouds.GLOBAL_CLOUD, "https://graph.microsoft.com");
        cloudList.put(Clouds.USGOV_CLOUD, "https://graph.microsoft.us");
        cloudList.put(Clouds.CHINA_CLOUD, "https://microsoftgraph.chinacloudapi.cn");
        cloudList.put(Clouds.GERMANY_CLOUD, "https://graph.microsoft.de");
        cloudList.put(Clouds.USGOV_DOD_CLOUD, "https://dod-graph.microsoft.us");
        return cloudList;
    }

    public BaseGraphRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider, @Nullable ParseNodeFactory parseNodeFactory, @Nullable SerializationWriterFactory serializationWriterFactory, @Nullable OkHttpClient client, @Nullable GraphClientOption graphClientOption, @Nullable String baseUrl) {
        super(authenticationProvider, parseNodeFactory, serializationWriterFactory, (Call.Factory)(client != null ? client : GraphClientFactory.create(graphClientOption).build()));
        if (!Compatibility.isBlank((String)baseUrl)) {
            this.setBaseUrl(baseUrl);
        } else {
            this.setBaseUrl(BaseGraphRequestAdapter.determineBaseAddress(null, null));
        }
    }

    public BaseGraphRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider) {
        this(authenticationProvider, BaseGraphRequestAdapter.determineBaseAddress(null, null));
    }

    public BaseGraphRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider, @Nonnull String baseUrl) {
        this(authenticationProvider, baseUrl, new GraphClientOption());
    }

    public BaseGraphRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider, @Nonnull String baseUrl, @Nonnull OkHttpClient client) {
        this(authenticationProvider, null, null, client, null, baseUrl);
    }

    public BaseGraphRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider, @Nonnull String baseUrl, @Nonnull GraphClientOption graphClientOption) {
        this(authenticationProvider, null, null, null, graphClientOption, baseUrl);
    }

    public BaseGraphRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider, @Nullable Clouds cloud, @Nullable String version) {
        this(authenticationProvider, BaseGraphRequestAdapter.determineBaseAddress(cloud, version));
    }

    public BaseGraphRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider, @Nullable Clouds cloud, @Nullable String version, @Nonnull OkHttpClient client) {
        this(authenticationProvider, BaseGraphRequestAdapter.determineBaseAddress(cloud, version), client);
    }

    public BaseGraphRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider, @Nullable Clouds cloud, @Nullable String version, @Nonnull GraphClientOption graphClientOption) {
        this(authenticationProvider, BaseGraphRequestAdapter.determineBaseAddress(cloud, version), graphClientOption);
    }

    private static String determineBaseAddress(@Nullable Clouds nationalCloud, @Nullable String version) {
        String cloud;
        String string = cloud = nationalCloud == null ? BaseGraphRequestAdapter.getCloudList().get((Object)Clouds.GLOBAL_CLOUD) : BaseGraphRequestAdapter.getCloudList().get((Object)nationalCloud);
        if (cloud == null) {
            throw new IllegalArgumentException((Object)((Object)nationalCloud) + " is an unexpected national cloud.");
        }
        return version == null ? cloud + "/v1.0" : cloud + "/" + version;
    }

    protected final void finalize() throws Throwable {
    }

    public static enum Clouds {
        GLOBAL_CLOUD,
        USGOV_CLOUD,
        CHINA_CLOUD,
        GERMANY_CLOUD,
        USGOV_DOD_CLOUD;

    }
}

