/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.example.jdbc;

import com.mockrunner.example.jdbc.PayForm;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class PayAction
extends Action {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PayForm payForm = (PayForm)form;
        ActionMessages errors = new ActionMessages();
        Connection connection = this.initializeDatabase();
        try {
            String name = this.getName(connection, payForm);
            if (null == name) {
                this.createErrorAndRollback(request, connection, errors, "unknown.customer.error");
                ActionForward actionForward = mapping.findForward("failure");
                return actionForward;
            }
            if (!this.checkBillIntegrity(request, connection, errors, payForm)) {
                ActionForward actionForward = mapping.findForward("failure");
                return actionForward;
            }
            this.markBillAsPaid(connection, payForm);
            connection.commit();
            System.out.println(payForm.getAmount() + " paid from customer " + name);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.createErrorAndRollback(request, connection, errors, "general.database.error");
            ActionForward actionForward = mapping.findForward("failure");
            return actionForward;
        }
        finally {
            connection.close();
        }
        return mapping.findForward("success");
    }

    private Connection initializeDatabase() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:mysql://localhost:3306/test");
        connection.setAutoCommit(false);
        return connection;
    }

    private void createErrorAndRollback(HttpServletRequest request, Connection connection, ActionMessages errors, String errorKey) throws SQLException {
        ActionMessage error = new ActionMessage(errorKey);
        errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        this.saveErrors(request, errors);
        connection.rollback();
    }

    private String getName(Connection connection, PayForm payForm) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet result = statement.executeQuery("select name from customers where id='" + payForm.getCustomerId() + "'");
        String name = null;
        if (result.next()) {
            name = result.getString("name");
        }
        result.close();
        statement.close();
        return name;
    }

    private void markBillAsPaid(Connection connection, PayForm payForm) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("delete from openbills where id='" + payForm.getBillId() + "'");
        statement.executeUpdate("insert into paidbills values('" + payForm.getBillId() + "','" + payForm.getCustomerId() + "'," + payForm.getAmount() + ")");
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkBillIntegrity(HttpServletRequest request, Connection connection, ActionMessages errors, PayForm payForm) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet result = statement.executeQuery("select * from openbills where id='" + payForm.getBillId() + "'");
        try {
            if (!result.next()) {
                this.createErrorAndRollback(request, connection, errors, "unknown.bill.error");
                boolean bl = false;
                return bl;
            }
            if (!result.getString("customerid").equals(payForm.getCustomerId())) {
                this.createErrorAndRollback(request, connection, errors, "wrong.bill.for.customer");
                boolean bl = false;
                return bl;
            }
            if (result.getDouble("amount") != payForm.getAmount()) {
                this.createErrorAndRollback(request, connection, errors, "wrong.amount.for.bill");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            result.close();
            statement.close();
        }
        return true;
    }
}

