/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.jdbc.FileResultSetFactory;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import junit.framework.TestCase;

public class FileResultSetFactoryTest
extends TestCase {
    public void testGoodCreate() throws Exception {
        FileResultSetFactory factory = new FileResultSetFactory("target/test-classes/com/mockrunner/test/jdbc/testresult.txt");
        MockResultSet resultSet = factory.create("");
        this.doTestResultSet(factory, resultSet);
        factory = new FileResultSetFactory("/com/mockrunner/test/jdbc/testresult.txt");
        resultSet = factory.create("");
        this.doTestResultSet(factory, resultSet);
        factory = new FileResultSetFactory("com/mockrunner/test/jdbc/testresult.txt");
        resultSet = factory.create("");
        this.doTestResultSet(factory, resultSet);
        factory = new FileResultSetFactory(new File("target/test-classes/com/mockrunner/test/jdbc/testresult.txt"));
        resultSet = factory.create("");
        this.doTestResultSet(factory, resultSet);
    }

    public void testBadCreate() throws Exception {
        FileResultSetFactory factory = new FileResultSetFactory("not found");
        try {
            factory.create("");
            FileResultSetFactoryTest.fail();
        }
        catch (RuntimeException exc) {
            // empty catch block
        }
        factory = new FileResultSetFactory(new File("not found"));
        try {
            factory.create("");
            FileResultSetFactoryTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void doTestResultSet(FileResultSetFactory factory, MockResultSet resultSet) throws SQLException {
        FileResultSetFactoryTest.assertEquals((int)5, (int)resultSet.getRowCount());
        FileResultSetFactoryTest.assertEquals((int)3, (int)resultSet.getColumnCount());
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((String)"TestColumn1", (String)resultSet.getString(1));
        FileResultSetFactoryTest.assertEquals((String)"TestColumn2", (String)resultSet.getString(2));
        FileResultSetFactoryTest.assertEquals((String)"TestColumn3", (String)resultSet.getString(3));
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((int)1, (int)resultSet.getInt(1));
        FileResultSetFactoryTest.assertEquals((long)3L, (long)resultSet.getLong("Column2"));
        FileResultSetFactoryTest.assertEquals((int)4, (int)resultSet.getShort(3));
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((Object)"Entry1", (Object)resultSet.getObject(1));
        FileResultSetFactoryTest.assertEquals((String)"Entry2", (String)resultSet.getString(2));
        FileResultSetFactoryTest.assertEquals((Object)"Entry3", (Object)resultSet.getObject("Column3"));
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((double)25.3, (double)resultSet.getDouble("Column1"), (double)0.01);
        FileResultSetFactoryTest.assertEquals((double)26.7, (double)resultSet.getDouble(2), (double)0.01);
        FileResultSetFactoryTest.assertEquals((double)12.3, (double)resultSet.getFloat(3), (double)0.01);
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((String)"Test", (String)resultSet.getString(1));
        FileResultSetFactoryTest.assertEquals(null, (String)resultSet.getString(2));
        FileResultSetFactoryTest.assertEquals((String)"Test", (String)resultSet.getString(3));
        factory.setFirstLineContainsColumnNames(true);
        resultSet = factory.create("");
        FileResultSetFactoryTest.assertEquals((int)4, (int)resultSet.getRowCount());
        FileResultSetFactoryTest.assertEquals((int)3, (int)resultSet.getColumnCount());
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((int)1, (int)resultSet.getInt("TestColumn1"));
        FileResultSetFactoryTest.assertEquals((long)3L, (long)resultSet.getLong("TestColumn2"));
        FileResultSetFactoryTest.assertEquals((int)4, (int)resultSet.getShort("TestColumn3"));
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((Object)"Entry1", (Object)resultSet.getObject(1));
        FileResultSetFactoryTest.assertEquals((String)"Entry2", (String)resultSet.getString(2));
        FileResultSetFactoryTest.assertEquals((Object)"Entry3", (Object)resultSet.getObject(3));
    }

    public void testCreateWithTemplates() throws Exception {
        FileResultSetFactory factory = new FileResultSetFactory("target/test-classes/com/mockrunner/test/jdbc/testtemplateresult.txt");
        factory.setFirstLineContainsColumnNames(true);
        MockResultSet resultSet = factory.create("");
        this.doTestResultSetTemplatesDisabled(resultSet);
        factory.setUseTemplates(true);
        resultSet = factory.create("");
        this.doTestResultSetDefaultTemplatesEnabled(resultSet);
        HashMap<String, String> customMap = new HashMap<String, String>();
        customMap.put("customMarker", "template1");
        customMap.put("anotherCustomMarker", "template2");
        factory.setTemplateConfiguration("%", customMap);
        resultSet = factory.create("");
        this.doTestResultSetCustomTemplatesEnabled(resultSet);
        factory.setUseTemplates(false);
        resultSet = factory.create("");
        this.doTestResultSetTemplatesDisabled(resultSet);
    }

    private void doTestResultSetTemplatesDisabled(MockResultSet resultSet) throws SQLException {
        FileResultSetFactoryTest.assertEquals((int)2, (int)resultSet.getRowCount());
        FileResultSetFactoryTest.assertEquals((int)3, (int)resultSet.getColumnCount());
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((String)"$defaultDate", (String)resultSet.getString("TestColumn1"));
        FileResultSetFactoryTest.assertEquals((String)"$defaultString", (String)resultSet.getString("TestColumn2"));
        FileResultSetFactoryTest.assertEquals((String)"$defaultInteger", (String)resultSet.getString(3));
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((Object)"%customMarker", (Object)resultSet.getObject(1));
        FileResultSetFactoryTest.assertEquals(null, (String)resultSet.getString(2));
        FileResultSetFactoryTest.assertEquals((Object)"%anotherCustomMarker", (Object)resultSet.getObject("TestColumn3"));
    }

    private void doTestResultSetDefaultTemplatesEnabled(MockResultSet resultSet) throws SQLException {
        FileResultSetFactoryTest.assertEquals((int)2, (int)resultSet.getRowCount());
        FileResultSetFactoryTest.assertEquals((int)3, (int)resultSet.getColumnCount());
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((String)"1970-01-01", (String)resultSet.getString(1));
        FileResultSetFactoryTest.assertEquals((String)"", (String)resultSet.getString("TestColumn2"));
        FileResultSetFactoryTest.assertEquals((int)0, (int)resultSet.getInt("TestColumn3"));
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((Object)"%customMarker", (Object)resultSet.getObject(1));
        FileResultSetFactoryTest.assertEquals(null, (String)resultSet.getString(2));
        FileResultSetFactoryTest.assertEquals((Object)"%anotherCustomMarker", (Object)resultSet.getObject("TestColumn3"));
    }

    private void doTestResultSetCustomTemplatesEnabled(MockResultSet resultSet) throws SQLException {
        FileResultSetFactoryTest.assertEquals((int)2, (int)resultSet.getRowCount());
        FileResultSetFactoryTest.assertEquals((int)3, (int)resultSet.getColumnCount());
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((String)"$defaultDate", (String)resultSet.getString("TestColumn1"));
        FileResultSetFactoryTest.assertEquals((String)"$defaultString", (String)resultSet.getString("TestColumn2"));
        FileResultSetFactoryTest.assertEquals((String)"$defaultInteger", (String)resultSet.getString(3));
        resultSet.next();
        FileResultSetFactoryTest.assertEquals((Object)"template1", (Object)resultSet.getObject(1));
        FileResultSetFactoryTest.assertEquals(null, (String)resultSet.getString("TestColumn2"));
        FileResultSetFactoryTest.assertEquals((Object)"template2", (Object)resultSet.getObject("TestColumn3"));
    }

    public void testGetFile() {
        FileResultSetFactory factory = new FileResultSetFactory("target/test-classes/com/mockrunner/test/jdbc/testresult.txt");
        FileResultSetFactoryTest.assertEquals((Object)new File("target/test-classes/com/mockrunner/test/jdbc/testresult.txt"), (Object)factory.getFile());
        factory = new FileResultSetFactory(new File("target/test-classes/com/mockrunner/test/jdbc/testresult.txt"));
        FileResultSetFactoryTest.assertEquals((Object)new File("target/test-classes/com/mockrunner/test/jdbc/testresult.txt"), (Object)factory.getFile());
        factory = new FileResultSetFactory("badfile");
        try {
            factory.getFile();
            FileResultSetFactoryTest.fail();
        }
        catch (RuntimeException exc) {
            // empty catch block
        }
        factory = new FileResultSetFactory(new File("badfile"));
        try {
            factory.getFile();
            FileResultSetFactoryTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

