/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import junit.framework.TestCase;

public class MockArrayTest
extends TestCase {
    private MockArray stringArray;
    private MockArray byteArray;

    protected void setUp() throws Exception {
        super.setUp();
        this.stringArray = new MockArray(new String[]{"This", "is", "a", "test", "array"});
        this.byteArray = new MockArray(new byte[]{1, 2, 3, 4, 5, 6, 7});
    }

    public void testGetArray() throws Exception {
        Object array = this.stringArray.getArray();
        MockArrayTest.assertTrue((boolean)(array instanceof String[]));
        MockArrayTest.assertTrue((boolean)Arrays.equals((String[])array, new String[]{"This", "is", "a", "test", "array"}));
        array = this.stringArray.getArray(2L, 3);
        MockArrayTest.assertTrue((boolean)(array instanceof String[]));
        MockArrayTest.assertTrue((boolean)Arrays.equals((String[])array, new String[]{"is", "a", "test"}));
        array = this.byteArray.getArray(1L, 7);
        MockArrayTest.assertTrue((boolean)(array instanceof byte[]));
        MockArrayTest.assertTrue((boolean)Arrays.equals((byte[])array, new byte[]{1, 2, 3, 4, 5, 6, 7}));
        array = this.byteArray.getArray(1L, 1);
        MockArrayTest.assertTrue((boolean)(array instanceof byte[]));
        MockArrayTest.assertTrue((boolean)Arrays.equals((byte[])array, new byte[]{1}));
    }

    public void testGetResultSet() throws Exception {
        MockResultSet resultSet = (MockResultSet)this.stringArray.getResultSet();
        MockArrayTest.assertEquals((int)5, (int)resultSet.getRowCount());
        resultSet.next();
        MockArrayTest.assertEquals((int)1, (int)resultSet.getInt(1));
        MockArrayTest.assertEquals((String)"This", (String)resultSet.getString(2));
        resultSet.next();
        MockArrayTest.assertEquals((int)2, (int)resultSet.getInt(1));
        MockArrayTest.assertEquals((String)"is", (String)resultSet.getString(2));
        resultSet.next();
        MockArrayTest.assertEquals((int)3, (int)resultSet.getInt(1));
        MockArrayTest.assertEquals((String)"a", (String)resultSet.getString(2));
        resultSet.next();
        MockArrayTest.assertEquals((int)4, (int)resultSet.getInt(1));
        MockArrayTest.assertEquals((String)"test", (String)resultSet.getString(2));
        resultSet.next();
        MockArrayTest.assertEquals((int)5, (int)resultSet.getInt(1));
        MockArrayTest.assertEquals((String)"array", (String)resultSet.getString(2));
        resultSet = (MockResultSet)this.byteArray.getResultSet(3L, 2);
        MockArrayTest.assertEquals((int)2, (int)resultSet.getRowCount());
        resultSet.next();
        MockArrayTest.assertEquals((int)1, (int)resultSet.getInt(1));
        MockArrayTest.assertEquals((int)3, (int)resultSet.getByte(2));
        resultSet.next();
        MockArrayTest.assertEquals((int)2, (int)resultSet.getInt(1));
        MockArrayTest.assertEquals((int)4, (int)resultSet.getByte(2));
    }

    public void testFree() throws Exception {
        MockArrayTest.assertFalse((boolean)this.byteArray.wasFreeCalled());
        this.byteArray.free();
        MockArrayTest.assertTrue((boolean)this.byteArray.wasFreeCalled());
        try {
            this.byteArray.getArray();
            MockArrayTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.byteArray.getResultSet(1L, 1);
            MockArrayTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.byteArray.getBaseType();
            MockArrayTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        MockArray copy = (MockArray)this.byteArray.clone();
        MockArrayTest.assertTrue((boolean)copy.wasFreeCalled());
    }

    public void testEquals() throws Exception {
        MockArray stringArray1 = new MockArray(new String[]{"1", "2"});
        MockArrayTest.assertFalse((boolean)stringArray1.equals(null));
        MockArrayTest.assertTrue((boolean)stringArray1.equals(stringArray1));
        MockArray stringArray2 = new MockArray(new String[]{"1", "2", "3"});
        MockArrayTest.assertFalse((boolean)stringArray1.equals(stringArray2));
        MockArrayTest.assertFalse((boolean)stringArray2.equals(stringArray1));
        stringArray2 = new MockArray(new String[]{"1", "2"});
        MockArrayTest.assertTrue((boolean)stringArray1.equals(stringArray2));
        MockArrayTest.assertTrue((boolean)stringArray2.equals(stringArray1));
        MockArrayTest.assertEquals((int)stringArray1.hashCode(), (int)stringArray2.hashCode());
        stringArray2.setBaseTypeName(null);
        MockArrayTest.assertFalse((boolean)stringArray1.equals(stringArray2));
        MockArrayTest.assertFalse((boolean)stringArray2.equals(stringArray1));
        stringArray1.setBaseTypeName(null);
        MockArrayTest.assertTrue((boolean)stringArray1.equals(stringArray2));
        MockArrayTest.assertTrue((boolean)stringArray2.equals(stringArray1));
        MockArrayTest.assertEquals((int)stringArray1.hashCode(), (int)stringArray2.hashCode());
        stringArray1.setBaseTypeName("xyz");
        stringArray2.setBaseTypeName("xyz1");
        MockArrayTest.assertFalse((boolean)stringArray1.equals(stringArray2));
        MockArrayTest.assertFalse((boolean)stringArray2.equals(stringArray1));
        stringArray2.setBaseTypeName("xyz");
        MockArrayTest.assertTrue((boolean)stringArray1.equals(stringArray2));
        MockArrayTest.assertTrue((boolean)stringArray2.equals(stringArray1));
        MockArrayTest.assertEquals((int)stringArray1.hashCode(), (int)stringArray2.hashCode());
        stringArray1.setBaseType(5);
        MockArrayTest.assertFalse((boolean)stringArray1.equals(stringArray2));
        MockArrayTest.assertFalse((boolean)stringArray2.equals(stringArray1));
        stringArray2.setBaseType(5);
        MockArrayTest.assertTrue((boolean)stringArray1.equals(stringArray2));
        MockArrayTest.assertTrue((boolean)stringArray2.equals(stringArray1));
        MockArrayTest.assertEquals((int)stringArray1.hashCode(), (int)stringArray2.hashCode());
        stringArray1.free();
        MockArrayTest.assertFalse((boolean)stringArray1.equals(stringArray2));
        MockArrayTest.assertFalse((boolean)stringArray2.equals(stringArray1));
    }

    public void testClone() throws Exception {
        MockArray copy = (MockArray)this.stringArray.clone();
        MockArrayTest.assertTrue((boolean)Arrays.equals((Object[])this.stringArray.getArray(), (Object[])copy.getArray()));
        String[] array = (String[])this.stringArray.getArray();
        array[0] = "Test";
        MockArrayTest.assertFalse((boolean)Arrays.equals((Object[])this.stringArray.getArray(), (Object[])copy.getArray()));
    }

    public void testToString() throws Exception {
        MockArray array = new MockArray(new Object[0]);
        MockArrayTest.assertEquals((String)"Array data: []", (String)array.toString());
        array = new MockArray(new Object[]{"1"});
        MockArrayTest.assertEquals((String)"Array data: [1]", (String)array.toString());
        array = new MockArray(new Object[]{"1", new Integer(1)});
        MockArrayTest.assertEquals((String)"Array data: [1, 1]", (String)array.toString());
    }
}

