/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockRef;
import junit.framework.TestCase;

public class MockRefTest
extends TestCase {
    public void testClone() throws Exception {
        MockRef ref = new MockRef((Object)this);
        MockRef copy = (MockRef)ref.clone();
        MockRefTest.assertNotSame((Object)ref, (Object)copy);
        MockRefTest.assertSame((Object)ref.getObject(), (Object)copy.getObject());
        MockRefTest.assertSame((Object)((Object)this), (Object)copy.getObject());
    }

    public void testEquals() throws Exception {
        MockRef nullRef = new MockRef(null);
        MockRefTest.assertFalse((boolean)nullRef.equals(null));
        MockRefTest.assertTrue((boolean)nullRef.equals(nullRef));
        MockRef ref = new MockRef("test");
        MockRefTest.assertFalse((boolean)ref.equals(nullRef));
        MockRefTest.assertFalse((boolean)nullRef.equals(ref));
        MockRef other = new MockRef("test");
        MockRefTest.assertTrue((boolean)ref.equals(other));
        MockRefTest.assertTrue((boolean)other.equals(ref));
        MockRefTest.assertEquals((int)ref.hashCode(), (int)other.hashCode());
        other = new MockRef("test"){};
        MockRefTest.assertFalse((boolean)other.equals(ref));
        MockRefTest.assertFalse((boolean)ref.equals(other));
        other = new MockRef("test");
        other.setBaseTypeName("baseTypeName");
        MockRefTest.assertFalse((boolean)other.equals(ref));
        MockRefTest.assertFalse((boolean)ref.equals(other));
        ref.setBaseTypeName("baseTypeName");
        MockRefTest.assertTrue((boolean)ref.equals(other));
        MockRefTest.assertTrue((boolean)other.equals(ref));
        MockRefTest.assertEquals((int)ref.hashCode(), (int)other.hashCode());
        other = new MockRef(new Integer(3));
        other.setBaseTypeName("baseTypeName");
        MockRefTest.assertFalse((boolean)ref.equals(other));
        MockRefTest.assertFalse((boolean)other.equals(ref));
        ref = new MockRef(new Integer(3));
        MockRefTest.assertFalse((boolean)ref.equals(other));
        MockRefTest.assertFalse((boolean)other.equals(ref));
        ref.setBaseTypeName("baseTypeName");
        MockRefTest.assertTrue((boolean)ref.equals(other));
        MockRefTest.assertTrue((boolean)other.equals(ref));
        MockRefTest.assertEquals((int)ref.hashCode(), (int)other.hashCode());
    }

    public void testToString() throws Exception {
        MockRef ref = new MockRef("abc");
        MockRefTest.assertEquals((String)"Ref data: abc", (String)ref.toString());
    }
}

