/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.example.jdbc;

import com.mockrunner.example.jdbc.Bookstore;
import com.mockrunner.jdbc.BasicJDBCTestCaseAdapter;
import com.mockrunner.jdbc.FileResultSetFactory;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BookstoreTest
extends BasicJDBCTestCaseAdapter {
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setUseRegularExpressions(true);
        this.getStatementResultSetHandler().setUseRegularExpressions(true);
    }

    @Test
    public void testSuccessfulOrder() throws Exception {
        FileResultSetFactory factory = new FileResultSetFactory("target/test-classes/com/mockrunner/example/jdbc/bookstore.txt");
        factory.setFirstLineContainsColumnNames(true);
        MockResultSet result = this.getStatementResultSetHandler().createResultSet("bookresult", factory);
        this.getStatementResultSetHandler().prepareResultSet("select.*isbn,.*quantity.*", result);
        List resultList = Bookstore.order(this.getJDBCMockObjectFactory().getMockConnection(), new ArrayList());
        Assert.assertEquals((long)4L, (long)resultList.size());
        Assert.assertTrue((boolean)resultList.contains("1234567890"));
        Assert.assertTrue((boolean)resultList.contains("1111111111"));
        Assert.assertTrue((boolean)resultList.contains("1212121212"));
        Assert.assertTrue((boolean)resultList.contains("3333333333"));
        this.verifyResultSetRow("bookresult", 1, (Object[])new String[]{"1234567890", "0"});
        this.verifyResultSetRow("bookresult", 2, (Object[])new String[]{"1111111111", "4"});
        this.verifyResultSetRow("bookresult", 3, (Object[])new String[]{"0987654321", "0"});
        this.verifyResultSetRow("bookresult", 4, (Object[])new String[]{"1212121212", "2"});
        this.verifyResultSetRow("bookresult", 5, (Object[])new String[]{"3333333333", "0"});
        this.verifyCommitted();
        this.verifyAllResultSetsClosed();
        this.verifyAllStatementsClosed();
    }

    @Test
    public void testCorrectSQL() throws Exception {
        MockResultSet result = this.getStatementResultSetHandler().createResultSet();
        this.getStatementResultSetHandler().prepareResultSet("select.*isbn,.*quantity.*", result);
        ArrayList<String> orderList = new ArrayList<String>();
        orderList.add("1234567890");
        orderList.add("1111111111");
        Bookstore.order(this.getJDBCMockObjectFactory().getMockConnection(), orderList);
        this.verifySQLStatementExecuted("select.*isbn,.*quantity.*\\(isbn='1234567890'.*or.*isbn='1111111111'\\)");
    }

    @Test
    public void testException() throws Exception {
        this.getStatementResultSetHandler().prepareThrowsSQLException("select.*isbn,.*quantity.*");
        Bookstore.order(this.getJDBCMockObjectFactory().getMockConnection(), new ArrayList());
        this.verifyRolledBack();
        this.verifyAllResultSetsClosed();
        this.verifyAllStatementsClosed();
    }
}

