/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.io;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(RateLimitInputStream.class);
    private static final int DEFAULT_PERMITS = 102400000;
    private final int permits;
    private RateLimiter limiter;
    private final InputStream in;

    public RateLimitInputStream(InputStream in) {
        this(in, 102400000);
    }

    public RateLimitInputStream(InputStream in, int permits) {
        if (permits <= 1000) {
            permits = 1000;
        } else if (permits > 1000) {
            permits = permits / 1000 * 1000;
        }
        logger.info("rate limit force set to {}", (Object)permits);
        this.in = in;
        this.permits = permits;
        this.limiter = new TokenBucketRateLimiter(this.permits);
    }

    @Override
    public int read() throws IOException {
        this.limiter.acquire(1L);
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int total;
        int r;
        int index = offset;
        for (total = length; total > 0; total -= r) {
            int len = Math.min(this.permits, total);
            this.limiter.acquire(len);
            r = this.in.read(b, index, len);
            index += r;
            if (r >= 0) continue;
            return r;
        }
        assert (total == 0);
        return length;
    }

    @Override
    public long skip(long length) throws IOException {
        long total;
        long r;
        for (total = length; total > 0L; total -= r) {
            int skip = (int)Math.min((long)this.permits, total);
            this.limiter.acquire(skip);
            r = this.in.skip(skip);
            if (r >= (long)skip) continue;
            return length - total;
        }
        assert (total == 0L);
        return length;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private class TokenBucketRateLimiter
    implements RateLimiter {
        private long access = System.currentTimeMillis();
        private long borrow;
        private long permits;
        private final long size;
        private final double sleep;

        private TokenBucketRateLimiter(int permits) {
            this.size = this.permits = (long)permits;
            this.sleep = (double)(1L * this.size) / 1000.0;
        }

        @Override
        public void acquire(long permits) {
            try {
                while (true) {
                    this.generate();
                    if (this.permits >= permits) {
                        this.permits -= permits;
                        return;
                    }
                    double r = (double)(permits -= this.permits) / this.sleep;
                    if (r < 1.0) {
                        this.borrow += permits;
                        while ((double)this.borrow >= this.sleep) {
                            Thread.sleep(1L);
                            this.borrow = (long)((double)this.borrow - this.sleep);
                        }
                        return;
                    }
                    Thread.sleep((int)r);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        private long generate() {
            long access = System.currentTimeMillis();
            if (access <= this.access) {
                return 0L;
            }
            long p = (access - this.access) * this.size / 1000L;
            this.permits += p;
            if (this.permits > this.size) {
                this.permits = this.size;
            }
            this.access = access;
            return p;
        }
    }

    private static interface RateLimiter {
        public void acquire(long var1);
    }
}

