package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
/**
 * Settings for authenticated webdeployments.
 */
@ApiModel(description = "Settings for authenticated webdeployments.")

public class AuthenticationSettings  implements Serializable {
  
  private Boolean enabled = null;
  private String integrationId = null;
  private Boolean allowSessionUpgrade = null;

  
  /**
   * Indicate if these auth is required for this deployment. If, for example, this flag is set to true then webmessaging sessions can not send messages unless the end-user is authenticated.
   **/
  public AuthenticationSettings enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Indicate if these auth is required for this deployment. If, for example, this flag is set to true then webmessaging sessions can not send messages unless the end-user is authenticated.")
  @JsonProperty("enabled")
  public Boolean getEnabled() {
    return enabled;
  }
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  /**
   * The integration identifier which contains the auth settings required on the deployment.
   **/
  public AuthenticationSettings integrationId(String integrationId) {
    this.integrationId = integrationId;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "The integration identifier which contains the auth settings required on the deployment.")
  @JsonProperty("integrationId")
  public String getIntegrationId() {
    return integrationId;
  }
  public void setIntegrationId(String integrationId) {
    this.integrationId = integrationId;
  }


  /**
   * Allow end-users to upgrade an anonymous session to authenticated conversation.
   **/
  public AuthenticationSettings allowSessionUpgrade(Boolean allowSessionUpgrade) {
    this.allowSessionUpgrade = allowSessionUpgrade;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Allow end-users to upgrade an anonymous session to authenticated conversation.")
  @JsonProperty("allowSessionUpgrade")
  public Boolean getAllowSessionUpgrade() {
    return allowSessionUpgrade;
  }
  public void setAllowSessionUpgrade(Boolean allowSessionUpgrade) {
    this.allowSessionUpgrade = allowSessionUpgrade;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthenticationSettings authenticationSettings = (AuthenticationSettings) o;

    return Objects.equals(this.enabled, authenticationSettings.enabled) &&
            Objects.equals(this.integrationId, authenticationSettings.integrationId) &&
            Objects.equals(this.allowSessionUpgrade, authenticationSettings.allowSessionUpgrade);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enabled, integrationId, allowSessionUpgrade);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthenticationSettings {\n");
    
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    integrationId: ").append(toIndentedString(integrationId)).append("\n");
    sb.append("    allowSessionUpgrade: ").append(toIndentedString(allowSessionUpgrade)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

