package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ConversationChatEventTopicJourneyAction;
import com.mypurecloud.sdk.v2.model.ConversationChatEventTopicJourneyCustomer;
import com.mypurecloud.sdk.v2.model.ConversationChatEventTopicJourneyCustomerSession;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
/**
 * ConversationChatEventTopicJourneyContext
 */

public class ConversationChatEventTopicJourneyContext  implements Serializable {
  
  private ConversationChatEventTopicJourneyCustomer customer = null;
  private ConversationChatEventTopicJourneyCustomerSession customerSession = null;
  private ConversationChatEventTopicJourneyAction triggeringAction = null;

  
  /**
   **/
  public ConversationChatEventTopicJourneyContext customer(ConversationChatEventTopicJourneyCustomer customer) {
    this.customer = customer;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("customer")
  public ConversationChatEventTopicJourneyCustomer getCustomer() {
    return customer;
  }
  public void setCustomer(ConversationChatEventTopicJourneyCustomer customer) {
    this.customer = customer;
  }


  /**
   **/
  public ConversationChatEventTopicJourneyContext customerSession(ConversationChatEventTopicJourneyCustomerSession customerSession) {
    this.customerSession = customerSession;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("customerSession")
  public ConversationChatEventTopicJourneyCustomerSession getCustomerSession() {
    return customerSession;
  }
  public void setCustomerSession(ConversationChatEventTopicJourneyCustomerSession customerSession) {
    this.customerSession = customerSession;
  }


  /**
   **/
  public ConversationChatEventTopicJourneyContext triggeringAction(ConversationChatEventTopicJourneyAction triggeringAction) {
    this.triggeringAction = triggeringAction;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("triggeringAction")
  public ConversationChatEventTopicJourneyAction getTriggeringAction() {
    return triggeringAction;
  }
  public void setTriggeringAction(ConversationChatEventTopicJourneyAction triggeringAction) {
    this.triggeringAction = triggeringAction;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConversationChatEventTopicJourneyContext conversationChatEventTopicJourneyContext = (ConversationChatEventTopicJourneyContext) o;

    return Objects.equals(this.customer, conversationChatEventTopicJourneyContext.customer) &&
            Objects.equals(this.customerSession, conversationChatEventTopicJourneyContext.customerSession) &&
            Objects.equals(this.triggeringAction, conversationChatEventTopicJourneyContext.triggeringAction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customer, customerSession, triggeringAction);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConversationChatEventTopicJourneyContext {\n");
    
    sb.append("    customer: ").append(toIndentedString(customer)).append("\n");
    sb.append("    customerSession: ").append(toIndentedString(customerSession)).append("\n");
    sb.append("    triggeringAction: ").append(toIndentedString(triggeringAction)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

