package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Miner;
import com.mypurecloud.sdk.v2.model.TopicPhrase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

import java.io.Serializable;
/**
 * MinerTopic
 */

public class MinerTopic  implements Serializable {
  
  private String id = null;
  private String name = null;
  private Miner miner = null;
  private Integer conversationCount = null;
  private Float conversationPercent = null;
  private Integer utteranceCount = null;
  private Integer phraseCount = null;
  private List<TopicPhrase> phrases = new ArrayList<TopicPhrase>();
  private String selfUri = null;

  
  @ApiModelProperty(example = "null", value = "The globally unique identifier for the object.")
  @JsonProperty("id")
  public String getId() {
    return id;
  }


  /**
   * Topic name.
   **/
  public MinerTopic name(String name) {
    this.name = name;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Topic name.")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }


  @ApiModelProperty(example = "null", value = "The miner to which the topic belongs.")
  @JsonProperty("miner")
  public Miner getMiner() {
    return miner;
  }


  @ApiModelProperty(example = "null", value = "Number of conversations where a topic has occurred.")
  @JsonProperty("conversationCount")
  public Integer getConversationCount() {
    return conversationCount;
  }


  @ApiModelProperty(example = "null", value = "Percentage of conversations where a topic has occurred.")
  @JsonProperty("conversationPercent")
  public Float getConversationPercent() {
    return conversationPercent;
  }


  @ApiModelProperty(example = "null", value = "Number of unique utterances where a topic has occurred.")
  @JsonProperty("utteranceCount")
  public Integer getUtteranceCount() {
    return utteranceCount;
  }


  @ApiModelProperty(example = "null", value = "Number of unique phrases (sub-utterances) where a topic has occurred.")
  @JsonProperty("phraseCount")
  public Integer getPhraseCount() {
    return phraseCount;
  }


  /**
   * Phrases associated with a topic.
   **/
  public MinerTopic phrases(List<TopicPhrase> phrases) {
    this.phrases = phrases;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Phrases associated with a topic.")
  @JsonProperty("phrases")
  public List<TopicPhrase> getPhrases() {
    return phrases;
  }
  public void setPhrases(List<TopicPhrase> phrases) {
    this.phrases = phrases;
  }


  @ApiModelProperty(example = "null", value = "The URI for this object")
  @JsonProperty("selfUri")
  public String getSelfUri() {
    return selfUri;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MinerTopic minerTopic = (MinerTopic) o;

    return Objects.equals(this.id, minerTopic.id) &&
            Objects.equals(this.name, minerTopic.name) &&
            Objects.equals(this.miner, minerTopic.miner) &&
            Objects.equals(this.conversationCount, minerTopic.conversationCount) &&
            Objects.equals(this.conversationPercent, minerTopic.conversationPercent) &&
            Objects.equals(this.utteranceCount, minerTopic.utteranceCount) &&
            Objects.equals(this.phraseCount, minerTopic.phraseCount) &&
            Objects.equals(this.phrases, minerTopic.phrases) &&
            Objects.equals(this.selfUri, minerTopic.selfUri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, miner, conversationCount, conversationPercent, utteranceCount, phraseCount, phrases, selfUri);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MinerTopic {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    miner: ").append(toIndentedString(miner)).append("\n");
    sb.append("    conversationCount: ").append(toIndentedString(conversationCount)).append("\n");
    sb.append("    conversationPercent: ").append(toIndentedString(conversationPercent)).append("\n");
    sb.append("    utteranceCount: ").append(toIndentedString(utteranceCount)).append("\n");
    sb.append("    phraseCount: ").append(toIndentedString(phraseCount)).append("\n");
    sb.append("    phrases: ").append(toIndentedString(phrases)).append("\n");
    sb.append("    selfUri: ").append(toIndentedString(selfUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

