/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.ws.client;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListenerManager {
    private final WebSocket mWebSocket;
    private final List<WebSocketListener> mListeners = new ArrayList<WebSocketListener>();

    public ListenerManager(WebSocket websocket) {
        this.mWebSocket = websocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(WebSocketListener listener) {
        if (listener == null) {
            return;
        }
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            this.mListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnConnected(Map<String, List<String>> headers) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onConnected(this.mWebSocket, headers);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnDisconnected(WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onDisconnected(this.mWebSocket, serverCloseFrame, clientCloseFrame, closedByServer);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnFrame(WebSocketFrame frame) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onFrame(this.mWebSocket, frame);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnContinuationFrame(WebSocketFrame frame) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onContinuationFrame(this.mWebSocket, frame);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnTextFrame(WebSocketFrame frame) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onTextFrame(this.mWebSocket, frame);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnBinaryFrame(WebSocketFrame frame) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onBinaryFrame(this.mWebSocket, frame);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnCloseFrame(WebSocketFrame frame) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onCloseFrame(this.mWebSocket, frame);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnPingFrame(WebSocketFrame frame) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onPingFrame(this.mWebSocket, frame);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnPongFrame(WebSocketFrame frame) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onPongFrame(this.mWebSocket, frame);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnTextMessage(String message) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onTextMessage(this.mWebSocket, message);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnBinaryMessage(byte[] message) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onBinaryMessage(this.mWebSocket, message);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnFrameSent(WebSocketFrame frame) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onFrameSent(this.mWebSocket, frame);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnFrameUnsent(WebSocketFrame frame) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onFrameUnsent(this.mWebSocket, frame);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnError(WebSocketException cause) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onError(this.mWebSocket, cause);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnFrameError(WebSocketException cause, WebSocketFrame frame) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onFrameError(this.mWebSocket, cause, frame);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnMessageError(WebSocketException cause, List<WebSocketFrame> frames) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onMessageError(this.mWebSocket, cause, frames);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnTextMessageError(WebSocketException cause, byte[] data) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onTextMessageError(this.mWebSocket, cause, data);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnSendError(WebSocketException cause, WebSocketFrame frame) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onSendError(this.mWebSocket, cause, frame);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callOnUnexpectedError(WebSocketException cause) {
        List<WebSocketListener> list = this.mListeners;
        synchronized (list) {
            for (WebSocketListener listener : this.mListeners) {
                try {
                    listener.onUnexpectedError(this.mWebSocket, cause);
                }
                catch (Throwable t) {}
            }
        }
    }
}

