/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.session.SessionAutoConfiguration;

@SpringBootApplication(exclude={SessionAutoConfiguration.class, RedisAutoConfiguration.class})
public class GenieWeb {
    protected static final String SPRING_CONFIG_LOCATION = "spring.config.location";
    protected static final String USER_HOME_GENIE = "${user.home}/.genie/";

    protected GenieWeb() {
    }

    public static void main(String[] args) throws Exception {
        SpringApplication genie = new SpringApplication(new Object[]{GenieWeb.class});
        genie.setDefaultProperties(GenieWeb.getDefaultProperties());
        genie.run(args);
    }

    protected static Map<String, Object> getDefaultProperties() {
        HashMap defaultProperties = Maps.newHashMap();
        defaultProperties.put(SPRING_CONFIG_LOCATION, USER_HOME_GENIE);
        return defaultProperties;
    }
}

