/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.google.common.collect.Lists;
import com.netflix.genie.web.resources.handlers.GenieResourceHttpRequestHandler;
import com.netflix.genie.web.resources.writers.DefaultDirectoryWriter;
import com.netflix.genie.web.resources.writers.DirectoryWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class MvcConfig
extends WebMvcConfigurerAdapter {
    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseRegisteredSuffixPatternMatch(Boolean.valueOf(true));
    }

    @Bean
    @ConditionalOnMissingBean
    public ResourceLoader resourceLoader() {
        return new DefaultResourceLoader();
    }

    @Bean
    @ConditionalOnMissingBean
    public String hostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    @Bean(name={"genieRestTemplate"})
    public RestTemplate restTemplate(@Value(value="${genie.http.connect.timeout:2000}") int httpConnectTimeout, @Value(value="${genie.http.connect.timeout:10000}") int httpReadTimeout) {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setConnectTimeout(httpConnectTimeout);
        factory.setReadTimeout(httpReadTimeout);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    @ConditionalOnMissingBean
    public DirectoryWriter directoryWriter() {
        return new DefaultDirectoryWriter();
    }

    @Bean
    @ConditionalOnMissingBean
    public Resource jobsDir(ResourceLoader resourceLoader, @Value(value="${genie.jobs.dir.location}") String jobsDirLocation) throws IOException {
        File file;
        Resource jobsDirResource;
        Resource tmpJobsDirResource = resourceLoader.getResource(jobsDirLocation);
        if (tmpJobsDirResource.exists() && !tmpJobsDirResource.getFile().isDirectory()) {
            throw new IllegalStateException(jobsDirLocation + " exists but isn't a directory. Unable to continue");
        }
        String slash = "/";
        String localJobsDir = jobsDirLocation;
        if (!jobsDirLocation.endsWith("/")) {
            localJobsDir = localJobsDir + "/";
        }
        if (!(jobsDirResource = resourceLoader.getResource(localJobsDir)).exists() && !(file = jobsDirResource.getFile()).mkdirs()) {
            throw new IllegalStateException("Unable to create jobs directory " + jobsDirLocation + " and it doesn't exist.");
        }
        return jobsDirResource;
    }

    @Bean
    @ConditionalOnMissingBean
    public GenieResourceHttpRequestHandler genieResourceHttpRequestHandler(DirectoryWriter directoryWriter, ApplicationContext context, Resource jobsDir) {
        GenieResourceHttpRequestHandler handler = new GenieResourceHttpRequestHandler(directoryWriter);
        handler.setApplicationContext(context);
        handler.setLocations(Lists.newArrayList((Object[])new Resource[]{jobsDir}));
        return handler;
    }
}

