/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.core.jobs.workflow.WorkflowTask;
import com.netflix.genie.core.jpa.repositories.JpaApplicationRepository;
import com.netflix.genie.core.jpa.repositories.JpaClusterRepository;
import com.netflix.genie.core.jpa.repositories.JpaCommandRepository;
import com.netflix.genie.core.jpa.repositories.JpaJobExecutionRepository;
import com.netflix.genie.core.jpa.repositories.JpaJobRepository;
import com.netflix.genie.core.jpa.repositories.JpaJobRequestRepository;
import com.netflix.genie.core.jpa.services.JpaApplicationServiceImpl;
import com.netflix.genie.core.jpa.services.JpaClusterServiceImpl;
import com.netflix.genie.core.jpa.services.JpaCommandServiceImpl;
import com.netflix.genie.core.jpa.services.JpaJobPersistenceServiceImpl;
import com.netflix.genie.core.jpa.services.JpaJobSearchServiceImpl;
import com.netflix.genie.core.services.ApplicationService;
import com.netflix.genie.core.services.AttachmentService;
import com.netflix.genie.core.services.ClusterLoadBalancer;
import com.netflix.genie.core.services.ClusterService;
import com.netflix.genie.core.services.CommandService;
import com.netflix.genie.core.services.FileTransfer;
import com.netflix.genie.core.services.FileTransferFactory;
import com.netflix.genie.core.services.JobCoordinatorService;
import com.netflix.genie.core.services.JobCountService;
import com.netflix.genie.core.services.JobKillService;
import com.netflix.genie.core.services.JobPersistenceService;
import com.netflix.genie.core.services.JobSearchService;
import com.netflix.genie.core.services.JobSubmitterService;
import com.netflix.genie.core.services.MailService;
import com.netflix.genie.core.services.impl.CacheGenieFileTransferService;
import com.netflix.genie.core.services.impl.DefaultMailServiceImpl;
import com.netflix.genie.core.services.impl.FileSystemAttachmentService;
import com.netflix.genie.core.services.impl.GenieFileTransferService;
import com.netflix.genie.core.services.impl.LocalJobKillServiceImpl;
import com.netflix.genie.core.services.impl.LocalJobRunner;
import com.netflix.genie.core.services.impl.MailServiceImpl;
import com.netflix.genie.core.services.impl.RandomizedClusterLoadBalancerImpl;
import com.netflix.spectator.api.Registry;
import java.util.List;
import org.apache.commons.exec.Executor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ServiceLocatorFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration
public class ServicesConfig {
    @Bean
    @ConditionalOnProperty(value={"spring.mail.host"})
    public MailService getJavaMailSenderMailService(JavaMailSender javaMailSender, @Value(value="${genie.mail.fromAddress}") String fromAddress, @Value(value="${genie.mail.user:#{null}}") String mailUser, @Value(value="${genie.mail.password:#{null}}") String mailPassword) throws GenieException {
        return new MailServiceImpl(javaMailSender, fromAddress, mailUser, mailPassword);
    }

    @Bean
    @ConditionalOnMissingBean
    public MailService getDefaultMailServiceImpl() {
        return new DefaultMailServiceImpl();
    }

    @Bean
    public ApplicationService applicationService(JpaApplicationRepository applicationRepo, JpaCommandRepository commandRepo) {
        return new JpaApplicationServiceImpl(applicationRepo, commandRepo);
    }

    @Bean
    public ClusterService clusterService(JpaClusterRepository clusterRepo, JpaCommandRepository commandRepo) {
        return new JpaClusterServiceImpl(clusterRepo, commandRepo);
    }

    @Bean
    public CommandService commandService(JpaCommandRepository commandRepo, JpaApplicationRepository appRepo, JpaClusterRepository clusterRepo) {
        return new JpaCommandServiceImpl(commandRepo, appRepo, clusterRepo);
    }

    @Bean
    public JobSearchService jobSearchService(JpaJobRepository jobRepository, JpaJobRequestRepository jobRequestRepository, JpaJobExecutionRepository jobExecutionRepository) {
        return new JpaJobSearchServiceImpl(jobRepository, jobRequestRepository, jobExecutionRepository);
    }

    @Bean
    public JobPersistenceService jobPersistenceService(JpaJobRepository jobRepo, JpaJobRequestRepository jobRequestRepo, JpaJobExecutionRepository jobExecutionRepo, JpaApplicationRepository applicationRepo, JpaClusterRepository clusterRepo, JpaCommandRepository commandRepo) {
        return new JpaJobPersistenceServiceImpl(jobRepo, jobRequestRepo, jobExecutionRepo, applicationRepo, clusterRepo, commandRepo);
    }

    @Bean
    public JobKillService jobKillService(String hostName, JobSearchService jobSearchService, Executor executor, @Value(value="${genie.jobs.runAsUser.enabled:false}") boolean runAsUser, ApplicationEventPublisher eventPublisher) {
        return new LocalJobKillServiceImpl(hostName, jobSearchService, executor, runAsUser, eventPublisher);
    }

    @Bean
    public ClusterLoadBalancer clusterLoadBalancer() {
        return new RandomizedClusterLoadBalancerImpl();
    }

    @Bean
    public GenieFileTransferService genieFileTransferService(FileTransferFactory fileTransferFactory) throws GenieException {
        return new GenieFileTransferService(fileTransferFactory);
    }

    @Bean
    public GenieFileTransferService cacheGenieFileTransferService(FileTransferFactory fileTransferFactory, @Value(value="${genie.file.cache.location}") String baseCacheLocation, @Qualifier(value="file.system.file") FileTransfer localFileTransfer, Registry registry) throws GenieException {
        return new CacheGenieFileTransferService(fileTransferFactory, baseCacheLocation, localFileTransfer, registry);
    }

    @Bean
    public JobSubmitterService jobSubmitterService(JobPersistenceService jps, ApplicationService applicationService, ClusterService clusterService, CommandService commandService, ClusterLoadBalancer clusterLoadBalancer, ApplicationEventPublisher aep, List<WorkflowTask> workflowTasks, Resource genieWorkingDir, Registry registry) {
        return new LocalJobRunner(jps, applicationService, clusterService, commandService, clusterLoadBalancer, aep, workflowTasks, genieWorkingDir, registry);
    }

    @Bean
    public JobCoordinatorService jobCoordinatorService(AsyncTaskExecutor taskExecutor, JobPersistenceService jobPersistenceService, JobSubmitterService jobSubmitterService, JobKillService jobKillService, @Qualifier(value="jobMonitoringCoordinator") JobCountService jobCountService, @Value(value="${genie.jobs.archive.location}") String baseArchiveLocation, @Value(value="${genie.jobs.max.running:2}") int maxRunningJobs, Registry registry, ApplicationEventPublisher eventPublisher, String hostName) {
        return new JobCoordinatorService(taskExecutor, jobPersistenceService, jobSubmitterService, jobKillService, jobCountService, baseArchiveLocation, maxRunningJobs, registry, eventPublisher, hostName);
    }

    @Bean
    public AttachmentService attachmentService(@Value(value="${genie.jobs.attachments.dir:#{null}}") String attachmentsDirectory) {
        return new FileSystemAttachmentService(attachmentsDirectory);
    }

    @Bean
    public FactoryBean fileTransferFactory() {
        ServiceLocatorFactoryBean factoryBean = new ServiceLocatorFactoryBean();
        factoryBean.setServiceLocatorInterface(FileTransferFactory.class);
        return factoryBean;
    }
}

