/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.netflix.genie.web.tasks.leader.LeadershipTask;
import com.netflix.genie.web.tasks.leader.LeadershipTasksCoordinator;
import com.netflix.genie.web.tasks.leader.LocalLeader;
import java.util.Collection;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
public class TaskConfig {
    @Bean
    public Executor processExecutor() {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(null, null));
        return executor;
    }

    @Bean
    public TaskScheduler taskScheduler(@Value(value="${genie.tasks.scheduler.pool.size:1}") int poolSize) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(poolSize);
        return scheduler;
    }

    @Bean
    public AsyncTaskExecutor taskExecutor(@Value(value="${genie.tasks.executor.pool.size:1}") int poolSize) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(poolSize);
        return executor;
    }

    @Bean
    @ConditionalOnBean(value={LeadershipTask.class})
    public LeadershipTasksCoordinator leadershipTasksCoordinator(TaskScheduler taskScheduler, Collection<LeadershipTask> tasks) {
        return new LeadershipTasksCoordinator(taskScheduler, tasks);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.cluster.leader.enabled"}, havingValue="false")
    public LocalLeader localLeader(ApplicationEventPublisher publisher, @Value(value="${genie.leader.enabled}") boolean isLeader) {
        return new LocalLeader(publisher, isLeader);
    }
}

