/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3Client;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.core.services.FileTransfer;
import com.netflix.genie.core.services.impl.S3FileTransferImpl;
import com.netflix.spectator.api.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;

@Profile(value={"s3"})
@Configuration
public class AwsS3Config {
    private static final Logger log = LoggerFactory.getLogger(AwsS3Config.class);

    @Bean
    @ConditionalOnProperty(value={"genie.aws.credentials.file"})
    public ClasspathPropertiesFileCredentialsProvider awsCredentialsFromFile(@Value(value="${genie.aws.credentials.file}") String credentialsFilePath) {
        log.info("Creating file credentials provider bean");
        return new ClasspathPropertiesFileCredentialsProvider(credentialsFilePath);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.aws.credentials.role"})
    public STSAssumeRoleSessionCredentialsProvider awsCredentialsProvider(@Value(value="${genie.aws.credentials.role}") String roleArn) {
        log.info("Creating STS Assume Role Session Credentials provider bean");
        return new STSAssumeRoleSessionCredentialsProvider(roleArn, "Genie");
    }

    @Bean
    @ConditionalOnBean(value={AWSCredentialsProvider.class})
    public AmazonS3Client genieS3Client(AWSCredentialsProvider awsCredentialsProvider) {
        return new AmazonS3Client(awsCredentialsProvider);
    }

    @Bean(name={"file.system.s3", "file.system.s3n", "file.system.s3a"})
    @Order(value=1)
    @ConditionalOnBean(value={AmazonS3Client.class})
    public FileTransfer s3FileTransferImpl(AmazonS3Client s3Client, Registry registry) throws GenieException {
        return new S3FileTransferImpl(s3Client, registry);
    }
}

