/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.controllers;

import com.github.fge.jsonpatch.JsonPatch;
import com.netflix.genie.common.dto.Cluster;
import com.netflix.genie.common.dto.ClusterStatus;
import com.netflix.genie.common.dto.CommandStatus;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.core.services.ClusterService;
import com.netflix.genie.web.hateoas.assemblers.ClusterResourceAssembler;
import com.netflix.genie.web.hateoas.assemblers.CommandResourceAssembler;
import com.netflix.genie.web.hateoas.resources.ClusterResource;
import com.netflix.genie.web.hateoas.resources.CommandResource;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/v3/clusters"})
public class ClusterRestController {
    private static final Logger log = LoggerFactory.getLogger(ClusterRestController.class);
    private final ClusterService clusterService;
    private final ClusterResourceAssembler clusterResourceAssembler;
    private final CommandResourceAssembler commandResourceAssembler;

    @Autowired
    public ClusterRestController(ClusterService clusterService, ClusterResourceAssembler clusterResourceAssembler, CommandResourceAssembler commandResourceAssembler) {
        this.clusterService = clusterService;
        this.clusterResourceAssembler = clusterResourceAssembler;
        this.commandResourceAssembler = commandResourceAssembler;
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Void> createCluster(@RequestBody Cluster cluster) throws GenieException {
        log.debug("Called to create new cluster {}", (Object)cluster);
        String id = this.clusterService.createCluster(cluster);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{id}).toUri());
        return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ClusterResource getCluster(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id: {}", (Object)id);
        return this.clusterResourceAssembler.toResource(this.clusterService.getCluster(id));
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResources<ClusterResource> getClusters(@RequestParam(value="name", required=false) String name, @RequestParam(value="status", required=false) Set<String> statuses, @RequestParam(value="tag", required=false) Set<String> tags, @RequestParam(value="minUpdateTime", required=false) Long minUpdateTime, @RequestParam(value="maxUpdateTime", required=false) Long maxUpdateTime, @PageableDefault(page=0, size=64, sort={"updated"}, direction=Sort.Direction.DESC) Pageable page, PagedResourcesAssembler<Cluster> assembler) throws GenieException {
        log.debug("Called [name | statuses | tags | minUpdateTime | maxUpdateTime | page]");
        log.debug("{} | {} | {} | {} | {} | {}", new Object[]{name, statuses, tags, minUpdateTime, maxUpdateTime, page});
        EnumSet<ClusterStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(ClusterStatus.class);
            for (String status : statuses) {
                enumStatuses.add(ClusterStatus.parse((String)status));
            }
        }
        Link self = ControllerLinkBuilder.linkTo(((ClusterRestController)ControllerLinkBuilder.methodOn(ClusterRestController.class, (Object[])new Object[0])).getClusters(name, statuses, tags, minUpdateTime, maxUpdateTime, page, assembler)).withSelfRel();
        return assembler.toResource(this.clusterService.getClusters(name, enumStatuses, tags, minUpdateTime == null ? null : new Date(minUpdateTime), maxUpdateTime == null ? null : new Date(maxUpdateTime), page), (ResourceAssembler)this.clusterResourceAssembler, self);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateCluster(@PathVariable(value="id") String id, @RequestBody Cluster updateCluster) throws GenieException {
        log.debug("Called to update cluster with id {} update fields {}", (Object)id, (Object)updateCluster);
        this.clusterService.updateCluster(id, updateCluster);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PATCH}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patchCluster(@PathVariable(value="id") String id, @RequestBody JsonPatch patch) throws GenieException {
        log.debug("Called to patch cluster {} with patch {}", (Object)id, (Object)patch);
        this.clusterService.patchCluster(id, patch);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCluster(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Delete called for id: {}", (Object)id);
        this.clusterService.deleteCluster(id);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllClusters() throws GenieException {
        log.debug("called");
        this.clusterService.deleteAllClusters();
    }

    @RequestMapping(value={"/{id}/configs"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addConfigsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.debug("Called with id {} and config {}", (Object)id, configs);
        this.clusterService.addConfigsForCluster(id, configs);
    }

    @RequestMapping(value={"/{id}/configs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getConfigsForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return this.clusterService.getConfigsForCluster(id);
    }

    @RequestMapping(value={"/{id}/configs"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConfigsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.debug("Called with id {} and configs {}", (Object)id, configs);
        this.clusterService.updateConfigsForCluster(id, configs);
    }

    @RequestMapping(value={"/{id}/configs"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllConfigsForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        this.clusterService.removeAllConfigsForCluster(id);
    }

    @RequestMapping(value={"/{id}/tags"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addTagsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.debug("Called with id {} and tags {}", (Object)id, tags);
        this.clusterService.addTagsForCluster(id, tags);
    }

    @RequestMapping(value={"/{id}/tags"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getTagsForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return this.clusterService.getTagsForCluster(id);
    }

    @RequestMapping(value={"/{id}/tags"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateTagsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.debug("Called with id {} and tags {}", (Object)id, tags);
        this.clusterService.updateTagsForCluster(id, tags);
    }

    @RequestMapping(value={"/{id}/tags"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllTagsForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        this.clusterService.removeAllTagsForCluster(id);
    }

    @RequestMapping(value={"/{id}/tags/{tag}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeTagForCluster(@PathVariable(value="id") String id, @PathVariable(value="tag") String tag) throws GenieException {
        log.debug("Called with id {} and tag {}", (Object)id, (Object)tag);
        this.clusterService.removeTagForCluster(id, tag);
    }

    @RequestMapping(value={"/{id}/commands"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addCommandsForCluster(@PathVariable(value="id") String id, @RequestBody List<String> commandIds) throws GenieException {
        log.debug("Called with id {} and commandIds {}", (Object)id, commandIds);
        this.clusterService.addCommandsForCluster(id, commandIds);
    }

    @RequestMapping(value={"/{id}/commands"}, method={RequestMethod.GET}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<CommandResource> getCommandsForCluster(@PathVariable(value="id") String id, @RequestParam(value="status", required=false) Set<String> statuses) throws GenieException {
        log.debug("Called with id {} status {}", (Object)id, statuses);
        EnumSet<CommandStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(CommandStatus.class);
            for (String status : statuses) {
                enumStatuses.add(CommandStatus.parse((String)status));
            }
        }
        return this.clusterService.getCommandsForCluster(id, enumStatuses).stream().map(this.commandResourceAssembler::toResource).collect(Collectors.toList());
    }

    @RequestMapping(value={"/{id}/commands"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setCommandsForCluster(@PathVariable(value="id") String id, @RequestBody List<String> commandIds) throws GenieException {
        log.debug("Called with id {} and commandIds {}", (Object)id, commandIds);
        this.clusterService.setCommandsForCluster(id, commandIds);
    }

    @RequestMapping(value={"/{id}/commands"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllCommandsForCluster(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        this.clusterService.removeAllCommandsForCluster(id);
    }

    @RequestMapping(value={"/{id}/commands/{commandId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeCommandForCluster(@PathVariable(value="id") String id, @PathVariable(value="commandId") String commandId) throws GenieException {
        log.debug("Called with id {} and command id {}", (Object)id, (Object)commandId);
        this.clusterService.removeCommandForCluster(id, commandId);
    }
}

