/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.hateoas.assemblers;

import com.netflix.genie.common.dto.Command;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.controllers.CommandRestController;
import com.netflix.genie.web.hateoas.resources.CommandResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;

@Component
public class CommandResourceAssembler
implements ResourceAssembler<Command, CommandResource> {
    public CommandResource toResource(Command command) {
        CommandResource commandResource = new CommandResource(command);
        try {
            commandResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((CommandRestController)ControllerLinkBuilder.methodOn(CommandRestController.class, (Object[])new Object[0])).getCommand(command.getId()))).withSelfRel());
            commandResource.add(ControllerLinkBuilder.linkTo(((CommandRestController)ControllerLinkBuilder.methodOn(CommandRestController.class, (Object[])new Object[0])).getApplicationsForCommand(command.getId())).withRel("applications"));
            commandResource.add(ControllerLinkBuilder.linkTo(((CommandRestController)ControllerLinkBuilder.methodOn(CommandRestController.class, (Object[])new Object[0])).getClustersForCommand(command.getId(), null)).withRel("clusters"));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return commandResource;
    }
}

